/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.paimon.flink.action.cdc.SyncDatabaseActionBase;
import org.apache.paimon.flink.action.cdc.kafka.KafkaSyncDatabaseAction;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecordEventParser;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowKind;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SyncDatabaseActionBaseTest {
    private static final String ANY_DB = "any_db";
    private static final String WHITE_DB = "white_db";
    private static final String BLACK_DB = "black_db";
    private static final String WHITE_TBL = "white_tbl";
    private static final String BLACK_TBL = "black_tbl";
    private SyncDatabaseActionBase kafkaSyncDbAction;
    private RichCdcMultiplexRecord whiteAnyDbCdcRecord;
    private RichCdcMultiplexRecord blackAnyDbCdcRecord;
    private RichCdcMultiplexRecord whiteCdcRecord;
    private RichCdcMultiplexRecord blackCdcRecord;
    private RichCdcMultiplexRecord whiteDbBlackTblCdcRecord;
    private RichCdcMultiplexRecord blackDbWhiteTblCdcRecord;
    @TempDir
    private Path tmp;

    @BeforeEach
    public void setUp() throws Exception {
        LocalFileIO localFileIO = new LocalFileIO();
        org.apache.paimon.fs.Path defaultDb = new org.apache.paimon.fs.Path(this.tmp.toString(), "default.db");
        localFileIO.mkdirs(defaultDb);
        this.kafkaSyncDbAction = new KafkaSyncDatabaseAction("default", Collections.singletonMap("warehouse", this.tmp.toString()), new HashMap());
        HashMap<String, String> rawData = new HashMap<String, String>();
        rawData.put("field", "value");
        CdcRecord cdcData = new CdcRecord(RowKind.INSERT, rawData);
        this.whiteAnyDbCdcRecord = new RichCdcMultiplexRecord(ANY_DB, WHITE_TBL, Arrays.asList(new DataField[0]), Arrays.asList(new String[0]), cdcData);
        this.blackAnyDbCdcRecord = new RichCdcMultiplexRecord(ANY_DB, BLACK_TBL, Arrays.asList(new DataField[0]), Arrays.asList(new String[0]), cdcData);
        this.whiteCdcRecord = new RichCdcMultiplexRecord(WHITE_DB, WHITE_TBL, Arrays.asList(new DataField[0]), Arrays.asList(new String[0]), cdcData);
        this.blackCdcRecord = new RichCdcMultiplexRecord(BLACK_DB, WHITE_TBL, Arrays.asList(new DataField[0]), Arrays.asList(new String[0]), cdcData);
        this.whiteDbBlackTblCdcRecord = new RichCdcMultiplexRecord(WHITE_DB, BLACK_TBL, Arrays.asList(new DataField[0]), Arrays.asList(new String[0]), cdcData);
        this.blackDbWhiteTblCdcRecord = new RichCdcMultiplexRecord(BLACK_DB, WHITE_TBL, Arrays.asList(new DataField[0]), Arrays.asList(new String[0]), cdcData);
    }

    @Test
    public void testSyncTablesWithoutDbLists() throws NoSuchMethodException, IOException {
        this.kafkaSyncDbAction.includingTables(WHITE_TBL);
        this.kafkaSyncDbAction.excludingTables(BLACK_TBL);
        RichCdcMultiplexRecordEventParser parser = (RichCdcMultiplexRecordEventParser)this.kafkaSyncDbAction.buildEventParserFactory().create();
        parser.setRawEvent(this.whiteAnyDbCdcRecord);
        List parsedRecords = parser.parseRecords();
        Assert.assertEquals((long)1L, (long)parsedRecords.size());
        parser.setRawEvent(this.blackAnyDbCdcRecord);
        parsedRecords = parser.parseRecords();
        Assert.assertEquals((long)0L, (long)parsedRecords.size());
    }

    @Test
    public void testSyncTablesWithDbList() {
        this.kafkaSyncDbAction.includingDbs(WHITE_DB);
        this.kafkaSyncDbAction.excludingDbs(BLACK_DB);
        RichCdcMultiplexRecordEventParser parser = (RichCdcMultiplexRecordEventParser)this.kafkaSyncDbAction.buildEventParserFactory().create();
        parser.setRawEvent(this.whiteAnyDbCdcRecord);
        List parsedRecords = parser.parseRecords();
        Assert.assertEquals((long)0L, (long)parsedRecords.size());
        parser.setRawEvent(this.blackAnyDbCdcRecord);
        parsedRecords = parser.parseRecords();
        Assert.assertEquals((long)0L, (long)parsedRecords.size());
        parser.setRawEvent(this.whiteCdcRecord);
        parsedRecords = parser.parseRecords();
        Assert.assertEquals((long)1L, (long)parsedRecords.size());
        parser.setRawEvent(this.blackAnyDbCdcRecord);
        parsedRecords = parser.parseRecords();
        Assert.assertEquals((long)0L, (long)parsedRecords.size());
    }

    @Test
    public void testSycTablesCrossDB() {
        this.kafkaSyncDbAction.includingDbs(WHITE_DB);
        this.kafkaSyncDbAction.excludingDbs(BLACK_DB);
        this.kafkaSyncDbAction.excludingTables(BLACK_TBL);
        RichCdcMultiplexRecordEventParser parser = (RichCdcMultiplexRecordEventParser)this.kafkaSyncDbAction.buildEventParserFactory().create();
        parser.setRawEvent(this.whiteDbBlackTblCdcRecord);
        List parsedRecords = parser.parseRecords();
        Assert.assertEquals((long)0L, (long)parsedRecords.size());
        parser.setRawEvent(this.blackDbWhiteTblCdcRecord);
        parsedRecords = parser.parseRecords();
        Assert.assertEquals((long)0L, (long)parsedRecords.size());
    }
}

