/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.paimon.flink.action.cdc.CdcActionITCaseBase;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBContainer;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBSyncDatabaseAction;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBSyncTableAction;
import org.junit.jupiter.api.BeforeAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startables;

public abstract class MongoDBActionITCaseBase
extends CdcActionITCaseBase {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBActionITCaseBase.class);
    protected static MongoClient client;
    public static final MongoDBContainer MONGODB_CONTAINER;

    @BeforeAll
    public static void startContainers() {
        LOG.info("Starting containers...");
        Startables.deepStart(Stream.of(MONGODB_CONTAINER)).join();
        LOG.info("Containers are started.");
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(MONGODB_CONTAINER.getConnectionString())).build();
        client = MongoClients.create((MongoClientSettings)settings);
    }

    protected Map<String, String> getBasicMongoDBConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("hosts", MONGODB_CONTAINER.getHostAndPort());
        config.put("username", "flinkuser");
        config.put("password", "a1?~!@#$%^&*(){}[]<>.,+_-=/|:;");
        return config;
    }

    protected String createRecordsToMongoDB(String fileName, String content) {
        return MONGODB_CONTAINER.executeCommandFileInSeparateDatabase(fileName, content);
    }

    protected static void writeRecordsToMongoDB(String fileName, String dbName, String content) {
        MONGODB_CONTAINER.executeCommandFileInSeparateDatabase(fileName, dbName, content);
    }

    protected MongoDBSyncTableActionBuilder syncTableActionBuilder(Map<String, String> mongodbConfig) {
        return new MongoDBSyncTableActionBuilder(mongodbConfig);
    }

    protected MongoDBSyncDatabaseActionBuilder syncDatabaseActionBuilder(Map<String, String> mongodbConfig) {
        return new MongoDBSyncDatabaseActionBuilder(mongodbConfig);
    }

    static {
        MONGODB_CONTAINER = new MongoDBContainer("mongo:6.0.6").withSharding().withLogConsumer((Consumer<OutputFrame>)new Slf4jLogConsumer(LOG));
    }

    protected class MongoDBSyncDatabaseActionBuilder
    extends CdcActionITCaseBase.SyncDatabaseActionBuilder<MongoDBSyncDatabaseAction> {
        public MongoDBSyncDatabaseActionBuilder(Map<String, String> mongodbConfig) {
            super(MongoDBSyncDatabaseAction.class, mongodbConfig);
        }
    }

    protected class MongoDBSyncTableActionBuilder
    extends CdcActionITCaseBase.SyncTableActionBuilder<MongoDBSyncTableAction> {
        public MongoDBSyncTableActionBuilder(Map<String, String> mongodbConfig) {
            super(MongoDBSyncTableAction.class, mongodbConfig);
        }
    }
}

