/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Random;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class MongoDBContainer
extends org.testcontainers.containers.MongoDBContainer {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBContainer.class);
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(.*)//.*$");
    public static final String PAIMON_USER = "flinkuser";
    public static final String PAIMON_USER_PASSWORD = "a1?~!@#$%^&*(){}[]<>.,+_-=/|:;";
    public static final int MONGODB_PORT = 27017;

    public MongoDBContainer(String imageName) {
        super(imageName);
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarted(containerInfo, reused);
        String setupFilePath = "mongodb/docker/setup.js";
        URL setupFile = MongoDBContainer.class.getClassLoader().getResource("mongodb/docker/setup.js");
        Assert.assertNotNull((String)"Cannot locate mongodb/docker/setup.js", (Object)setupFile);
        try {
            String createUserCommand = Files.readAllLines(Paths.get(setupFile.toURI())).stream().filter(x -> StringUtils.isNotBlank((CharSequence)x) && !x.trim().startsWith("//")).map(x -> {
                Matcher m = COMMENT_PATTERN.matcher((CharSequence)x);
                return m.matches() ? m.group(1) : x;
            }).collect(Collectors.joining(" "));
            Container.ExecResult execResult = this.execInContainer(new String[]{"mongosh", "--eval", "use admin", "--eval", createUserCommand, "--eval", "console.log('Flink test user created.\\n');"});
            LOG.info(execResult.getStdout());
            if (execResult.getExitCode() != 0) {
                throw new IllegalStateException("Execute mongo command failed " + execResult.getStderr());
            }
            this.waitingFor((WaitStrategy)Wait.forLogMessage((String)"Flink test user created.\\s", (int)1));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MongoDBContainer withSharding() {
        return (MongoDBContainer)super.withSharding();
    }

    public MongoDBContainer withLogConsumer(Consumer<OutputFrame> consumer) {
        return (MongoDBContainer)super.withLogConsumer(consumer);
    }

    public MongoDBContainer withNetwork(Network network) {
        return (MongoDBContainer)super.withNetwork(network);
    }

    public MongoDBContainer withNetworkAliases(String ... aliases) {
        return (MongoDBContainer)super.withNetworkAliases(aliases);
    }

    public MongoDBContainer withStartupTimeout(Duration timeout) {
        return (MongoDBContainer)super.withStartupTimeout(timeout);
    }

    public void executeCommand(String command) {
        try {
            LOG.info("Executing mongo command: {}", (Object)command);
            Container.ExecResult execResult = this.execInContainer(new String[]{"mongosh", "--eval", command});
            LOG.info(execResult.getStdout());
            if (execResult.getExitCode() != 0) {
                throw new IllegalStateException("Execute mongo command failed " + execResult.getStderr());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Execute mongo command failed", e);
        }
    }

    public String executeCommandInDatabase(String command, String databaseName) {
        try {
            this.executeCommand(String.format("db = db.getSiblingDB('%s');\n", databaseName) + command);
            return databaseName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String executeCommandFileInSeparateDatabase(String fileNameIgnoreSuffix, String content) {
        return this.executeCommandFileInDatabase(fileNameIgnoreSuffix, fileNameIgnoreSuffix + "_" + Integer.toUnsignedString(new Random().nextInt(), 36), content);
    }

    public String executeCommandFileInSeparateDatabase(String fileNameIgnoreSuffix, String dbName, String content) {
        return this.executeCommandFileInDatabase(fileNameIgnoreSuffix, dbName, content);
    }

    public String executeCommandFileInDatabase(String fileNameIgnoreSuffix, String databaseName, String content) {
        String dbName = databaseName != null ? databaseName : fileNameIgnoreSuffix;
        String ddlFile = String.format("mongodb/%s/%s.js", content, fileNameIgnoreSuffix);
        URL ddlTestFile = MongoDBContainer.class.getClassLoader().getResource(ddlFile);
        Assert.assertNotNull((String)("Cannot locate " + ddlFile), (Object)ddlTestFile);
        try {
            String command0 = String.format("db = db.getSiblingDB('%s');\n", dbName);
            String command1 = Files.readAllLines(Paths.get(ddlTestFile.toURI())).stream().filter(x -> StringUtils.isNotBlank((CharSequence)x) && !x.trim().startsWith("//")).map(x -> {
                Matcher m = COMMENT_PATTERN.matcher((CharSequence)x);
                return m.matches() ? m.group(1) : x;
            }).collect(Collectors.joining("\n"));
            this.executeCommand(command0 + command1);
            return dbName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getConnectionString() {
        return String.format("mongodb://%s:%d", this.getHost(), this.getMappedPort(27017));
    }

    public String getHostAndPort() {
        return String.format("%s:%s", this.getHost(), this.getMappedPort(27017));
    }
}

