/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import org.apache.paimon.flink.sink.cdc.UpdatedDataFieldsProcessFunctionBase;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.VarCharType;
import org.junit.Assert;
import org.junit.Test;

public class UpdatedDataFieldsProcessFunctionBaseTest {
    @Test
    public void testCanConvertString() {
        VarCharType oldVarchar = new VarCharType(true, 10);
        VarCharType biggerLengthVarchar = new VarCharType(true, 20);
        VarCharType smallerLengthVarchar = new VarCharType(true, 5);
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = null;
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldVarchar, (DataType)biggerLengthVarchar);
        Assert.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldVarchar, (DataType)smallerLengthVarchar);
        Assert.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.IGNORE, (Object)convertAction);
    }

    @Test
    public void testCanConvertNumber() {
        IntType oldType = new IntType();
        BigIntType bigintType = new BigIntType();
        SmallIntType smallintType = new SmallIntType();
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = null;
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)bigintType);
        Assert.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)smallintType);
        Assert.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.IGNORE, (Object)convertAction);
    }

    @Test
    public void testCanConvertDecimal() {
        DecimalType oldType = new DecimalType(20, 9);
        DecimalType biggerRangeType = new DecimalType(30, 10);
        DecimalType smallerRangeType = new DecimalType(10, 3);
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = null;
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)biggerRangeType);
        Assert.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)smallerRangeType);
        Assert.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.IGNORE, (Object)convertAction);
    }

    @Test
    public void testCanConvertTimestamp() {
        TimestampType oldType = new TimestampType(true, 3);
        TimestampType biggerLengthTimestamp = new TimestampType(true, 5);
        TimestampType smallerLengthTimestamp = new TimestampType(true, 2);
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = null;
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)biggerLengthTimestamp);
        Assert.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)smallerLengthTimestamp);
        Assert.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.IGNORE, (Object)convertAction);
    }
}

