/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.postgres;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.cdc.connectors.base.source.jdbc.JdbcIncrementalSource;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.SyncJobHandler;
import org.apache.paimon.flink.action.cdc.SyncTableActionBase;
import org.apache.paimon.flink.action.cdc.postgres.PostgresActionUtils;
import org.apache.paimon.flink.action.cdc.schema.JdbcSchemasInfo;
import org.apache.paimon.flink.action.cdc.schema.JdbcTableInfo;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.utils.Preconditions;

public class PostgresSyncTableAction
extends SyncTableActionBase {
    private JdbcSchemasInfo postgresSchemasInfo;

    public PostgresSyncTableAction(String database, String table, Map<String, String> catalogConfig, Map<String, String> postgresConfig) {
        super(database, table, catalogConfig, postgresConfig, SyncJobHandler.SourceType.POSTGRES);
    }

    @Override
    protected Schema retrieveSchema() throws Exception {
        this.postgresSchemasInfo = PostgresActionUtils.getPostgresTableInfos(this.cdcSourceConfig, this.monitorTablePredication(), new ArrayList<Identifier>(), this.typeMapping);
        this.validatePostgresTableInfos(this.postgresSchemasInfo);
        JdbcTableInfo tableInfo = this.postgresSchemasInfo.mergeAll();
        return tableInfo.schema();
    }

    protected JdbcIncrementalSource<CdcSourceRecord> buildSource() {
        this.validateRuntimeExecutionMode();
        List<JdbcSchemasInfo.JdbcSchemaInfo> pkTables = this.postgresSchemasInfo.pkTables();
        HashSet<String> schemaList = new HashSet<String>();
        String[] tableList = new String[pkTables.size()];
        for (int i = 0; i < pkTables.size(); ++i) {
            JdbcSchemasInfo.JdbcSchemaInfo pkTable = pkTables.get(i);
            tableList[i] = pkTable.schemaName() + "." + pkTable.identifier().getObjectName();
            schemaList.add(pkTable.schemaName());
        }
        return PostgresActionUtils.buildPostgresSource(this.cdcSourceConfig, schemaList.toArray(new String[0]), tableList);
    }

    private void validatePostgresTableInfos(JdbcSchemasInfo jdbcSchemasInfo) {
        List<Identifier> nonPkTables = jdbcSchemasInfo.nonPkTables();
        Preconditions.checkArgument((boolean)nonPkTables.isEmpty(), (String)"Source tables of PostgreSQL table synchronization job cannot contain table which doesn't have primary keys.\nThey are: %s", (Object[])new Object[]{nonPkTables.stream().map(Identifier::getFullName).collect(Collectors.joining(","))});
        Preconditions.checkArgument((!jdbcSchemasInfo.pkTables().isEmpty() ? 1 : 0) != 0, (Object)"No table satisfies the given database name and table name.");
    }

    private Predicate<String> monitorTablePredication() {
        return tableName -> {
            Pattern tableNamePattern = Pattern.compile((String)this.cdcSourceConfig.get(PostgresSourceOptions.TABLE_NAME));
            return tableNamePattern.matcher((CharSequence)tableName).matches();
        };
    }
}

