/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.serialization;

import java.io.IOException;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcJsonDeserializationSchema
implements DeserializationSchema<CdcSourceRecord> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CdcJsonDeserializationSchema.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public CdcJsonDeserializationSchema(Configuration cdcSourceConfig) {
        this();
    }

    public CdcJsonDeserializationSchema() {
        this.objectMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public CdcSourceRecord deserialize(byte[] message) throws IOException {
        if (message == null) {
            return null;
        }
        try {
            return new CdcSourceRecord(this.objectMapper.readValue(message, JsonNode.class));
        }
        catch (Exception e) {
            LOG.error("Invalid Json:\n{}", (Object)new String(message));
            throw e;
        }
    }

    public boolean isEndOfStream(CdcSourceRecord nextElement) {
        return false;
    }

    public TypeInformation<CdcSourceRecord> getProducedType() {
        return TypeExtractor.getForClass(CdcSourceRecord.class);
    }
}

