/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.net.URL;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBCdcTimestampExtractor;
import org.apache.paimon.flink.action.cdc.mysql.DebeziumEventTest;
import org.apache.paimon.flink.action.cdc.mysql.MysqlCdcTimestampExtractor;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CdcDebeziumTimestampExtractorITCase {
    private ObjectMapper objectMapper;

    @BeforeEach
    public void before() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Test
    public void testMysqlCdcTimestampExtractor() throws Exception {
        MysqlCdcTimestampExtractor extractor = new MysqlCdcTimestampExtractor();
        JsonNode data = (JsonNode)this.objectMapper.readValue("{\"payload\" : {\"ts_ms\": 1}}", JsonNode.class);
        CdcSourceRecord record = new CdcSourceRecord((Object)data.toString());
        Assertions.assertThat((long)extractor.extractTimestamp(record)).isEqualTo(1L);
        URL url = DebeziumEventTest.class.getClassLoader().getResource("mysql/debezium-event-change.json");
        Assertions.assertThat((URL)url).isNotNull();
        JsonNode schemaChangeEvent = (JsonNode)this.objectMapper.readValue(url, JsonNode.class);
        record = new CdcSourceRecord((Object)schemaChangeEvent.toString());
        Assertions.assertThat((long)extractor.extractTimestamp(record)).isEqualTo(Long.MIN_VALUE);
    }

    @Test
    public void testMongodbCdcTimestampExtractor() throws Exception {
        MongoDBCdcTimestampExtractor extractor = new MongoDBCdcTimestampExtractor();
        JsonNode data = (JsonNode)this.objectMapper.readValue("{\"ts_ms\": 1}", JsonNode.class);
        CdcSourceRecord record = new CdcSourceRecord((Object)data.toString());
        Assertions.assertThat((long)extractor.extractTimestamp(record)).isEqualTo(1L);
    }
}

