/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.util.HashMap;
import org.apache.paimon.flink.action.cdc.TableNameConverter;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TableNameConverterTest {
    @Test
    public void testConvertTableName() {
        HashMap<String, String> tableMapping = new HashMap<String, String>(1);
        tableMapping.put("mapped_src", "mapped_TGT");
        TableNameConverter caseConverter = new TableNameConverter(true, true, "pre_", "_pos", tableMapping);
        Assertions.assertEquals((Object)caseConverter.convert("", "mapped_SRC"), (Object)"mapped_TGT");
        Assertions.assertEquals((Object)caseConverter.convert("", "unmapped_src"), (Object)"pre_unmapped_src_pos");
        TableNameConverter noCaseConverter = new TableNameConverter(false, true, "pre_", "_pos", tableMapping);
        Assertions.assertEquals((Object)noCaseConverter.convert("", "mapped_src"), (Object)"mapped_tgt");
        Assertions.assertEquals((Object)noCaseConverter.convert("", "unmapped_src"), (Object)"pre_unmapped_src_pos");
    }

    @Test
    public void testConvertTableNameByDBPrefix_Suffix() {
        HashMap<String, String> dbPrefix = new HashMap<String, String>(2);
        dbPrefix.put("db_with_prefix", "db_pref_");
        dbPrefix.put("db_with_prefix_suffix", "db_pref_");
        HashMap<String, String> dbSuffix = new HashMap<String, String>(2);
        dbSuffix.put("db_with_suffix", "_db_suff");
        dbSuffix.put("db_with_prefix_suffix", "_db_suff");
        TableNameConverter tblNameConverter = new TableNameConverter(false, true, dbPrefix, dbSuffix, "pre_", "_suf", null);
        Assertions.assertEquals((Object)"db_pref_table_name_suf", (Object)tblNameConverter.convert("db_with_prefix", "table_name"));
        Assertions.assertEquals((Object)"pre_table_name_db_suff", (Object)tblNameConverter.convert("db_with_suffix", "table_name"));
        Assertions.assertEquals((Object)"db_pref_table_name_db_suff", (Object)tblNameConverter.convert("db_with_prefix_suffix", "table_name"));
        Assertions.assertEquals((Object)"pre_table_name_suf", (Object)tblNameConverter.convert("db_without_prefix_suffix", "table_name"));
    }
}

