/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.format.debezium;

import java.util.Arrays;
import java.util.List;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.paimon.flink.action.cdc.format.debezium.DebeziumSchemaUtils;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DebeziumSchemaUtilsTest {
    @Test
    public void testFromDebeziumAvroTypeWithGenericUnion() {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
        Schema unionSchema = Schema.createUnion(Arrays.asList(stringSchema, intSchema));
        UnsupportedOperationException exception = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> DebeziumSchemaUtils.avroToPaimonDataType((Schema)unionSchema));
        Assertions.assertEquals((Object)"Generic unions are not supported", (Object)exception.getMessage());
    }

    @Test
    public void testFromDebeziumAvroTypeWithLogicalTypes() {
        Schema dateSchema = Schema.create((Schema.Type)Schema.Type.INT);
        LogicalTypes.date().addToSchema(dateSchema);
        DataType dateType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)dateSchema);
        Assertions.assertEquals((Object)DataTypes.DATE(), (Object)dateType);
        Schema decimalSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.decimal((int)10, (int)2).addToSchema(decimalSchema);
        DataType decimalType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)decimalSchema);
        Assertions.assertEquals((Object)DataTypes.DECIMAL((int)10, (int)2), (Object)decimalType);
        Schema timestampMillisSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        LogicalTypes.timestampMillis().addToSchema(timestampMillisSchema);
        DataType timestampMillisType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)timestampMillisSchema);
        Assertions.assertEquals((Object)DataTypes.TIMESTAMP_MILLIS(), (Object)timestampMillisType);
        Schema timestampMicrosSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        LogicalTypes.timestampMicros().addToSchema(timestampMicrosSchema);
        DataType timestampMicrosType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)timestampMicrosSchema);
        Assertions.assertEquals((Object)DataTypes.TIMESTAMP(), (Object)timestampMicrosType);
    }

    @Test
    public void testFromDebeziumAvroTypeWithPrimitiveTypes() {
        Schema booleanSchema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        DataType booleanType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)booleanSchema);
        Assertions.assertEquals((Object)DataTypes.BOOLEAN(), (Object)booleanType);
        Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
        DataType intType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)intSchema);
        Assertions.assertEquals((Object)DataTypes.INT(), (Object)intType);
        Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        DataType longType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)longSchema);
        Assertions.assertEquals((Object)DataTypes.BIGINT(), (Object)longType);
        Schema floatSchema = Schema.create((Schema.Type)Schema.Type.FLOAT);
        DataType floatType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)floatSchema);
        Assertions.assertEquals((Object)DataTypes.FLOAT(), (Object)floatType);
        Schema doubleSchema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
        DataType doubleType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)doubleSchema);
        Assertions.assertEquals((Object)DataTypes.DOUBLE(), (Object)doubleType);
        Schema enumSchema = Schema.createEnum((String)"TestEnum", null, null, Arrays.asList("VALUE1", "VALUE2"));
        DataType enumType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)enumSchema);
        Assertions.assertEquals((Object)DataTypes.STRING(), (Object)enumType);
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        DataType stringType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)stringSchema);
        Assertions.assertEquals((Object)DataTypes.STRING(), (Object)stringType);
        Schema bytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        DataType bytesType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)bytesSchema);
        Assertions.assertEquals((Object)DataTypes.BYTES(), (Object)bytesType);
    }

    @Test
    public void testFromDebeziumAvroTypeWithComplexTypes() {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema arraySchema = Schema.createArray((Schema)stringSchema);
        DataType arrayType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)arraySchema);
        Assertions.assertEquals((Object)DataTypes.ARRAY((DataType)DataTypes.STRING()), (Object)arrayType);
        Schema mapSchema = Schema.createMap((Schema)stringSchema);
        DataType mapType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)mapSchema);
        Assertions.assertEquals((Object)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()), (Object)mapType);
        Schema recordSchema = Schema.createRecord((String)"TestRecord", null, null, (boolean)false);
        List<Schema.Field> fields = Arrays.asList(new Schema.Field("field1", stringSchema, null, null), new Schema.Field("field2", Schema.create((Schema.Type)Schema.Type.INT), null, null));
        recordSchema.setFields(fields);
        DataType recordType = DebeziumSchemaUtils.avroToPaimonDataType((Schema)recordSchema);
        DataField[] expectedFields = new DataField[]{DataTypes.FIELD((int)0, (String)"field1", (DataType)DataTypes.STRING(), null), DataTypes.FIELD((int)1, (String)"field2", (DataType)DataTypes.INT(), null)};
        Assertions.assertEquals((Object)DataTypes.ROW((DataField[])expectedFields), (Object)recordType);
    }
}

