/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.Arrays;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.sink.cdc.UpdatedDataFieldsProcessFunctionBase;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.VarCharType;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class UpdatedDataFieldsProcessFunctionBaseTest {
    @Test
    public void testCanConvertString() {
        VarCharType oldVarchar = new VarCharType(true, 10);
        VarCharType biggerLengthVarchar = new VarCharType(true, 20);
        VarCharType smallerLengthVarchar = new VarCharType(true, 5);
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = null;
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldVarchar, (DataType)biggerLengthVarchar, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldVarchar, (DataType)smallerLengthVarchar, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.IGNORE, (Object)convertAction);
    }

    @Test
    public void testCanConvertNumber() {
        IntType oldType = new IntType();
        BigIntType bigintType = new BigIntType();
        SmallIntType smallintType = new SmallIntType();
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = null;
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)bigintType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)smallintType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.IGNORE, (Object)convertAction);
    }

    @Test
    public void testCanConvertDecimal() {
        DecimalType oldType = new DecimalType(20, 9);
        DecimalType biggerRangeType = new DecimalType(30, 10);
        DecimalType smallerRangeType = new DecimalType(10, 3);
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = null;
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)biggerRangeType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)smallerRangeType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.IGNORE, (Object)convertAction);
    }

    @Test
    public void testCanConvertTimestamp() {
        TimestampType oldType = new TimestampType(true, 3);
        TimestampType biggerLengthTimestamp = new TimestampType(true, 5);
        TimestampType smallerLengthTimestamp = new TimestampType(true, 2);
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = null;
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)biggerLengthTimestamp, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)smallerLengthTimestamp, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.IGNORE, (Object)convertAction);
    }

    @Test
    public void testArrayNullabilityEvolution() {
        ArrayType oldType = new ArrayType(true, (DataType)DataTypes.INT());
        ArrayType newType = new ArrayType(false, (DataType)DataTypes.INT());
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
        oldType = new ArrayType(false, (DataType)DataTypes.INT());
        newType = new ArrayType(true, (DataType)DataTypes.INT());
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        oldType = new ArrayType(true, (DataType)new IntType(true));
        newType = new ArrayType(true, (DataType)new IntType(false));
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
    }

    @Test
    public void testNestedRowNullabilityEvolution() {
        RowType oldInnerType = new RowType(true, Arrays.asList(new DataField(1, "inner1", (DataType)new IntType(true)), new DataField(2, "inner2", (DataType)DataTypes.STRING())));
        RowType oldRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)oldInnerType)));
        RowType newInnerType = new RowType(false, Arrays.asList(new DataField(1, "inner1", (DataType)new IntType(true)), new DataField(2, "inner2", (DataType)DataTypes.STRING())));
        RowType newRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)newInnerType)));
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldRowType, (DataType)newRowType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
        newInnerType = new RowType(true, Arrays.asList(new DataField(1, "inner1", (DataType)new IntType(false)), new DataField(2, "inner2", (DataType)DataTypes.STRING())));
        newRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)newInnerType)));
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldRowType, (DataType)newRowType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
    }

    @Test
    public void testMultisetNullabilityEvolution() {
        MultisetType oldType = new MultisetType(true, (DataType)DataTypes.INT());
        MultisetType newType = new MultisetType(false, (DataType)DataTypes.INT());
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
        oldType = new MultisetType(false, (DataType)DataTypes.INT());
        newType = new MultisetType(true, (DataType)DataTypes.INT());
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        oldType = new MultisetType(true, (DataType)new IntType(true));
        newType = new MultisetType(true, (DataType)new IntType(false));
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
    }

    @Test
    public void testComplexNestedNullabilityEvolution() {
        RowType oldArrayInnerType = new RowType(true, Arrays.asList(new DataField(1, "x", (DataType)new IntType(true)), new DataField(2, "y", (DataType)DataTypes.STRING())));
        ArrayType oldArrayType = new ArrayType(true, (DataType)oldArrayInnerType);
        RowType oldMapValueType = new RowType(true, Arrays.asList(new DataField(1, "a", (DataType)new IntType(true)), new DataField(2, "b", (DataType)DataTypes.STRING())));
        MapType oldMapType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)oldMapValueType);
        RowType oldRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)oldArrayType), new DataField(2, "f2", (DataType)oldMapType)));
        RowType newArrayInnerType = new RowType(false, Arrays.asList(new DataField(1, "x", (DataType)new IntType(true)), new DataField(2, "y", (DataType)DataTypes.STRING())));
        ArrayType newArrayType = new ArrayType(true, (DataType)newArrayInnerType);
        MapType newMapType = oldMapType;
        RowType newRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)newArrayType), new DataField(2, "f2", (DataType)newMapType)));
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldRowType, (DataType)newRowType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
        newArrayType = oldArrayType;
        RowType newMapValueType = new RowType(true, Arrays.asList(new DataField(1, "a", (DataType)new IntType(false)), new DataField(2, "b", (DataType)DataTypes.STRING())));
        newMapType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)newMapValueType);
        newRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)newArrayType), new DataField(2, "f2", (DataType)newMapType)));
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldRowType, (DataType)newRowType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
    }

    @Test
    public void testNestedRowTypeConversion() {
        RowType oldRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)DataTypes.INT()), new DataField(2, "f2", (DataType)DataTypes.STRING())));
        RowType newRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)DataTypes.BIGINT()), new DataField(2, "f2", (DataType)DataTypes.STRING()), new DataField(3, "f3", (DataType)DataTypes.DOUBLE())));
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldRowType, (DataType)newRowType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
    }

    @Test
    public void testNestedArrayTypeConversion() {
        ArrayType oldArrayType = new ArrayType(true, (DataType)DataTypes.INT());
        ArrayType newArrayType = new ArrayType(true, (DataType)DataTypes.BIGINT());
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldArrayType, (DataType)newArrayType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
    }

    @Test
    public void testNestedMapTypeConversion() {
        MapType oldMapType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)DataTypes.INT());
        MapType newMapType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT());
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldMapType, (DataType)newMapType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
    }

    @Test
    public void testMapWithNullableComplexTypes() {
        RowType oldInnerRowType = new RowType(true, Arrays.asList(new DataField(1, "x", (DataType)DataTypes.INT()), new DataField(2, "y", (DataType)DataTypes.STRING())));
        RowType oldValueType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)new ArrayType(true, (DataType)DataTypes.INT())), new DataField(2, "f2", (DataType)oldInnerRowType)));
        MapType oldType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)oldValueType);
        RowType newInnerRowType = new RowType(true, Arrays.asList(new DataField(1, "x", (DataType)DataTypes.BIGINT()), new DataField(2, "y", (DataType)DataTypes.STRING()), new DataField(3, "z", (DataType)DataTypes.DOUBLE())));
        RowType newValueType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)new ArrayType(true, (DataType)DataTypes.BIGINT())), new DataField(2, "f2", (DataType)newInnerRowType)));
        MapType newType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)newValueType);
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
        RowType incompatibleValueType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)new ArrayType(true, (DataType)DataTypes.STRING())), new DataField(2, "f2", (DataType)newInnerRowType)));
        MapType incompatibleType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)incompatibleValueType);
        convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)incompatibleType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
    }

    @Test
    public void testComplexNestedTypeConversion() {
        RowType oldInnerRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)DataTypes.INT()), new DataField(2, "f2", (DataType)DataTypes.STRING())));
        MapType oldMapType = new MapType(true, (DataType)DataTypes.INT(), (DataType)oldInnerRowType);
        ArrayType oldType = new ArrayType(true, (DataType)oldMapType);
        RowType newInnerRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)DataTypes.BIGINT()), new DataField(2, "f2", (DataType)DataTypes.STRING()), new DataField(3, "f3", (DataType)DataTypes.DOUBLE())));
        MapType newMapType = new MapType(true, (DataType)DataTypes.INT(), (DataType)newInnerRowType);
        ArrayType newType = new ArrayType(true, (DataType)newMapType);
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
    }

    @Test
    public void testRowTypeWithMultipleChanges() {
        RowType oldRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)DataTypes.INT()), new DataField(2, "f2", (DataType)DataTypes.STRING()), new DataField(3, "f3", (DataType)DataTypes.DOUBLE())));
        RowType newRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)DataTypes.BIGINT()), new DataField(2, "f2", (DataType)new VarCharType(true, 100)), new DataField(4, "f4", (DataType)DataTypes.INT())));
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldRowType, (DataType)newRowType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
    }

    @Test
    public void testNonNullableFieldRemoval() {
        RowType oldRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)new IntType(false)), new DataField(2, "f2", (DataType)DataTypes.STRING())));
        RowType newRowType = new RowType(true, Arrays.asList(new DataField(2, "f2", (DataType)DataTypes.STRING())));
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldRowType, (DataType)newRowType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
    }

    @Test
    public void testAddingNonNullableField() {
        RowType oldRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)DataTypes.INT())));
        RowType newRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)DataTypes.INT()), new DataField(2, "f2", (DataType)new VarCharType(false, 100))));
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldRowType, (DataType)newRowType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
    }

    @Test
    public void testNestedRowWithinRowEvolution() {
        RowType oldInnerType = new RowType(true, Arrays.asList(new DataField(1, "inner1", (DataType)DataTypes.INT()), new DataField(2, "inner2", (DataType)DataTypes.STRING())));
        RowType oldRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)oldInnerType)));
        RowType newInnerType = new RowType(true, Arrays.asList(new DataField(1, "inner1", (DataType)DataTypes.BIGINT()), new DataField(2, "inner2", (DataType)DataTypes.STRING()), new DataField(3, "inner3", (DataType)DataTypes.DOUBLE())));
        RowType newRowType = new RowType(true, Arrays.asList(new DataField(1, "f1", (DataType)newInnerType)));
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldRowType, (DataType)newRowType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
    }

    @Test
    public void testArrayOfArraysEvolution() {
        ArrayType oldInnerArray = new ArrayType(true, (DataType)DataTypes.INT());
        ArrayType oldType = new ArrayType(true, (DataType)oldInnerArray);
        ArrayType newInnerArray = new ArrayType(true, (DataType)DataTypes.BIGINT());
        ArrayType newType = new ArrayType(true, (DataType)newInnerArray);
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
    }

    @Test
    public void testArrayWithIncompatibleElementType() {
        ArrayType oldType = new ArrayType(true, (DataType)DataTypes.INT());
        ArrayType newType = new ArrayType(true, (DataType)DataTypes.STRING());
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
    }

    @Test
    public void testMapOfMapsEvolution() {
        MapType oldInnerMap = new MapType(true, (DataType)DataTypes.INT(), (DataType)DataTypes.STRING());
        MapType oldType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)oldInnerMap);
        MapType newInnerMap = new MapType(true, (DataType)DataTypes.INT(), (DataType)new VarCharType(true, 100));
        MapType newType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)newInnerMap);
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.IGNORE, (Object)convertAction);
    }

    @Test
    public void testMapWithIncompatibleValueType() {
        MapType oldType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)DataTypes.INT());
        MapType newType = new MapType(true, (DataType)DataTypes.STRING(), (DataType)DataTypes.BOOLEAN());
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
    }

    @Test
    public void testMultisetTypeEvolution() {
        MultisetType oldType = new MultisetType(true, (DataType)DataTypes.INT());
        MultisetType newType = new MultisetType(true, (DataType)DataTypes.BIGINT());
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.CONVERT, (Object)convertAction);
    }

    @Test
    public void testIncompatibleMultisetTypeEvolution() {
        MultisetType oldType = new MultisetType(true, (DataType)DataTypes.INT());
        MultisetType newType = new MultisetType(true, (DataType)DataTypes.STRING());
        UpdatedDataFieldsProcessFunctionBase.ConvertAction convertAction = UpdatedDataFieldsProcessFunctionBase.canConvert((DataType)oldType, (DataType)newType, (TypeMapping)TypeMapping.defaultMapping());
        Assertions.assertEquals((Object)UpdatedDataFieldsProcessFunctionBase.ConvertAction.EXCEPTION, (Object)convertAction);
    }
}

