/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeJsonParser;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializableSupplier;
import org.apache.paimon.utils.StringUtils;

public interface Expression
extends Serializable {
    public String fieldReference();

    public DataType outputType();

    public String eval(String var1);

    default public String name() {
        return null;
    }

    public static Expression create(Map<String, DataType> typeMapping, boolean caseSensitive, String exprName, String ... args) {
        ExpressionCreator function = ExpressionFunction.creator(exprName.toLowerCase());
        if (function == null) {
            throw new UnsupportedOperationException(String.format("Unsupported expression: %s. Supported expressions are: %s", exprName, String.join((CharSequence)",", ExpressionFunction.EXPRESSION_FUNCTIONS.keySet())));
        }
        return function.create(typeMapping, caseSensitive, args);
    }

    public static Expression substring(String fieldReference, String ... literals) {
        Integer endExclusive;
        int beginInclusive;
        Preconditions.checkArgument((literals.length == 1 || literals.length == 2 ? 1 : 0) != 0, (Object)String.format("'substring' expression supports one or two arguments, but found '%s'.", literals.length));
        try {
            beginInclusive = Integer.parseInt(literals[0]);
            endExclusive = literals.length == 1 ? null : Integer.valueOf(Integer.parseInt(literals[1]));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("The index arguments '%s' contain non integer value.", Arrays.toString(literals)), e);
        }
        Preconditions.checkArgument((beginInclusive >= 0 ? 1 : 0) != 0, (String)"begin index argument (%s) of 'substring' must be >= 0.", (Object[])new Object[]{beginInclusive});
        Preconditions.checkArgument((endExclusive == null || endExclusive > beginInclusive ? 1 : 0) != 0, (String)"end index (%s) must be larger than begin index (%s).", (Object[])new Object[]{endExclusive, beginInclusive});
        return new Substring(fieldReference, beginInclusive, endExclusive);
    }

    public static Expression truncate(String fieldReference, DataType fieldType, String ... literals) {
        Preconditions.checkArgument((literals.length == 1 ? 1 : 0) != 0, (Object)String.format("'truncate' expression supports one argument, but found '%s'.", literals.length));
        return new TruncateComputer(fieldReference, fieldType, literals[0]);
    }

    public static Expression cast(String ... literals) {
        Preconditions.checkArgument((literals.length == 1 || literals.length == 2 ? 1 : 0) != 0, (Object)String.format("'cast' expression supports one or two arguments, but found '%s'.", literals.length));
        VarCharType dataType = DataTypes.STRING();
        if (literals.length == 2) {
            dataType = DataTypeJsonParser.parseAtomicTypeSQLString((String)literals[1]);
        }
        return new CastExpression(literals[0], (DataType)dataType);
    }

    public static abstract class NoLiteralsStringExpressionBase
    implements Expression {
        private final String fieldReference;

        public NoLiteralsStringExpressionBase(String fieldReference, DataType fieldType, String ... literals) {
            this.fieldReference = fieldReference;
            Preconditions.checkArgument((fieldType.getTypeRoot() == DataTypeRoot.VARCHAR ? 1 : 0) != 0, (Object)String.format("'%s' expression only supports type root of '%s', but found '%s'.", this.name(), DataTypeRoot.VARCHAR, fieldType.getTypeRoot()));
            Preconditions.checkArgument((literals.length == 0 ? 1 : 0) != 0, (Object)String.format("'%s' expression only supports 0 argument, but found '%s'.", this.name(), literals.length));
        }

        @Override
        public DataType outputType() {
            return DataTypes.STRING();
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }
    }

    public static final class TrimExpression
    extends NoLiteralsStringExpressionBase {
        public TrimExpression(String fieldReference, DataType fieldType, String ... literals) {
            super(fieldReference, fieldType, literals);
        }

        @Override
        public String eval(String input) {
            return StringUtils.trim((String)input);
        }

        @Override
        public String name() {
            return "trim";
        }
    }

    public static final class LowerExpression
    extends NoLiteralsStringExpressionBase {
        public LowerExpression(String fieldReference, DataType fieldType, String ... literals) {
            super(fieldReference, fieldType, literals);
        }

        @Override
        public String eval(String input) {
            return StringUtils.toLowerCase((String)input);
        }

        @Override
        public String name() {
            return "lower";
        }
    }

    public static final class UpperExpression
    extends NoLiteralsStringExpressionBase {
        public UpperExpression(String fieldReference, DataType fieldType, String ... literals) {
            super(fieldReference, fieldType, literals);
        }

        @Override
        public String eval(String input) {
            return StringUtils.toUpperCase((String)input);
        }

        @Override
        public String name() {
            return "upper";
        }
    }

    public static final class NowExpression
    implements Expression {
        @Override
        public String fieldReference() {
            return null;
        }

        @Override
        public DataType outputType() {
            return DataTypes.TIMESTAMP((int)3);
        }

        @Override
        public String eval(String input) {
            return DateTimeUtils.formatLocalDateTime((LocalDateTime)LocalDateTime.now(), (int)3);
        }
    }

    public static final class CastExpression
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String value;
        private final DataType dataType;

        private CastExpression(String value, DataType dataType) {
            this.value = value;
            this.dataType = dataType;
        }

        @Override
        public String fieldReference() {
            return null;
        }

        @Override
        public DataType outputType() {
            return this.dataType;
        }

        @Override
        public String eval(String input) {
            return this.value;
        }
    }

    public static final class TruncateComputer
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;
        private final DataType fieldType;
        private final int width;

        TruncateComputer(String fieldReference, DataType fieldType, String literal) {
            this.fieldReference = fieldReference;
            this.fieldType = fieldType;
            try {
                this.width = Integer.parseInt(literal);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Invalid width value for truncate function: %s, expected integer.", literal));
            }
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return this.fieldType;
        }

        @Override
        public String eval(String input) {
            switch (this.fieldType.getTypeRoot()) {
                case TINYINT: 
                case SMALLINT: {
                    return String.valueOf(this.truncateShort(this.width, Short.parseShort(input)));
                }
                case INTEGER: {
                    return String.valueOf(this.truncateInt(this.width, Integer.parseInt(input)));
                }
                case BIGINT: {
                    return String.valueOf(this.truncateLong(this.width, Long.parseLong(input)));
                }
                case DECIMAL: {
                    return this.truncateDecimal(BigInteger.valueOf(this.width), new BigDecimal(input)).toString();
                }
                case VARCHAR: 
                case CHAR: {
                    Preconditions.checkArgument((this.width <= input.length() ? 1 : 0) != 0, (String)"Invalid width value for truncate function: %s, expected less than or equal to %s.", (Object[])new Object[]{this.width, input.length()});
                    return input.substring(0, this.width);
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported field type for truncate function: %s.", this.fieldType.getTypeRoot().toString()));
        }

        private short truncateShort(int width, short value) {
            return (short)(value - (value % width + width) % width);
        }

        private int truncateInt(int width, int value) {
            return value - (value % width + width) % width;
        }

        private long truncateLong(int width, long value) {
            return value - (value % (long)width + (long)width) % (long)width;
        }

        private BigDecimal truncateDecimal(BigInteger unscaledWidth, BigDecimal value) {
            BigDecimal remainder = new BigDecimal(value.unscaledValue().remainder(unscaledWidth).add(unscaledWidth).remainder(unscaledWidth), value.scale());
            return value.subtract(remainder);
        }
    }

    public static final class Substring
    implements Expression {
        private static final long serialVersionUID = 1L;
        private final String fieldReference;
        private final int beginInclusive;
        @Nullable
        private final Integer endExclusive;

        private Substring(String fieldReference, int beginInclusive, @Nullable Integer endExclusive) {
            this.fieldReference = fieldReference;
            this.beginInclusive = beginInclusive;
            this.endExclusive = endExclusive;
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return DataTypes.STRING();
        }

        @Override
        public String eval(String input) {
            try {
                if (this.endExclusive == null) {
                    return input.substring(this.beginInclusive);
                }
                return input.substring(this.beginInclusive, this.endExclusive);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new RuntimeException(String.format("Cannot get substring from '%s' because the indexes are out of range. Begin index: %s, end index: %s.", input, this.beginInclusive, this.endExclusive));
            }
        }
    }

    public static final class DateFormat
    extends TemporalExpressionBase<String> {
        private static final long serialVersionUID = 2L;
        private final String pattern;

        private DateFormat(String fieldReference, DataType fieldType, String pattern, @Nullable Integer precision) {
            super(fieldReference, fieldType, precision);
            this.pattern = pattern;
        }

        @Override
        public DataType outputType() {
            return DataTypes.STRING();
        }

        @Override
        protected Function<LocalDateTime, String> createConverter() {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.pattern);
            return localDateTime -> localDateTime.format(formatter);
        }

        private static DateFormat create(String fieldReference, DataType fieldType, String ... literals) {
            Preconditions.checkArgument((literals.length == 1 || literals.length == 2 ? 1 : 0) != 0, (String)"'date_format' supports 1 or 2 arguments, but found '%s'.", (Object[])new Object[]{literals.length});
            return new DateFormat(fieldReference, fieldType, literals[0], literals.length == 1 ? null : Integer.valueOf(literals[1]));
        }
    }

    public static final class TemporalToIntConverter
    extends TemporalExpressionBase<Integer> {
        private static final long serialVersionUID = 1L;
        private final SerializableSupplier<Function<LocalDateTime, Integer>> converterSupplier;

        private TemporalToIntConverter(String fieldReference, DataType fieldType, @Nullable Integer precision, SerializableSupplier<Function<LocalDateTime, Integer>> converterSupplier) {
            super(fieldReference, fieldType, precision);
            this.converterSupplier = converterSupplier;
        }

        @Override
        protected Function<LocalDateTime, Integer> createConverter() {
            return (Function)this.converterSupplier.get();
        }

        private static TemporalToIntConverter create(String fieldReference, DataType fieldType, SerializableSupplier<Function<LocalDateTime, Integer>> converterSupplier, String ... literals) {
            Preconditions.checkArgument((literals.length == 0 || literals.length == 1 ? 1 : 0) != 0, (String)"TemporalToIntConverter supports 0 or 1 argument, but found '%s'.", (Object[])new Object[]{literals.length});
            return new TemporalToIntConverter(fieldReference, fieldType, literals.length == 0 ? null : Integer.valueOf(literals[0]), converterSupplier);
        }
    }

    public static abstract class TemporalExpressionBase<T>
    implements Expression {
        private static final long serialVersionUID = 1L;
        private static final List<Integer> SUPPORTED_PRECISION = Arrays.asList(0, 3, 6, 9);
        private final String fieldReference;
        @Nullable
        private final Integer precision;
        private transient Function<LocalDateTime, T> converter;

        private TemporalExpressionBase(String fieldReference, DataType fieldType, @Nullable Integer precision) {
            this.fieldReference = fieldReference;
            if (fieldType.getTypeRoot().getFamilies().contains(DataTypeFamily.INTEGER_NUMERIC) && precision == null) {
                precision = 0;
            }
            Preconditions.checkArgument((precision == null || SUPPORTED_PRECISION.contains(precision) ? 1 : 0) != 0, (String)"Unsupported precision of temporal function: %d. Supported precisions are: 0 (for epoch seconds), 3 (for epoch milliseconds), 6 (for epoch microseconds) and 9 (for epoch nanoseconds).", (Object[])new Object[]{precision});
            this.precision = precision;
        }

        @Override
        public String fieldReference() {
            return this.fieldReference;
        }

        @Override
        public DataType outputType() {
            return DataTypes.INT();
        }

        @Override
        public String eval(String input) {
            if (this.converter == null) {
                this.converter = this.createConverter();
            }
            T result = this.converter.apply(this.toLocalDateTime(input));
            return String.valueOf(result);
        }

        private LocalDateTime toLocalDateTime(String input) {
            if (this.precision == null) {
                return DateTimeUtils.toLocalDateTime((String)input, (int)9);
            }
            long numericValue = Long.parseLong(input);
            long milliseconds = 0L;
            int nanosOfMillisecond = 0;
            switch (this.precision) {
                case 0: {
                    milliseconds = numericValue * 1000L;
                    break;
                }
                case 3: {
                    milliseconds = numericValue;
                    break;
                }
                case 6: {
                    milliseconds = numericValue / 1000L;
                    nanosOfMillisecond = (int)(numericValue % 1000L * 1000L);
                    break;
                }
                case 9: {
                    milliseconds = numericValue / 1000000L;
                    nanosOfMillisecond = (int)(numericValue % 1000000L);
                }
            }
            return Timestamp.fromEpochMillis((long)milliseconds, (int)nanosOfMillisecond).toLocalDateTime();
        }

        protected abstract Function<LocalDateTime, T> createConverter();
    }

    public static class ReferencedField {
        private final String field;
        private final DataType fieldType;
        private final String[] literals;

        private ReferencedField(String field, DataType fieldType, String[] literals) {
            this.field = field;
            this.fieldType = fieldType;
            this.literals = literals;
        }

        public static ReferencedField checkArgument(Map<String, DataType> typeMapping, boolean caseSensitive, String ... args) {
            String referencedField = args[0].trim();
            String[] literals = (String[])Arrays.stream(args).skip(1L).map(String::trim).toArray(String[]::new);
            String referencedFieldCheckForm = StringUtils.toLowerCaseIfNeed((String)referencedField, (boolean)caseSensitive);
            DataType fieldType = (DataType)Preconditions.checkNotNull((Object)typeMapping.get(referencedFieldCheckForm), (String)String.format("Referenced field '%s' is not in given fields: %s.", referencedFieldCheckForm, typeMapping.keySet()));
            return new ReferencedField(referencedField, fieldType, literals);
        }

        public String field() {
            return this.field;
        }

        public DataType fieldType() {
            return this.fieldType;
        }

        public String[] literals() {
            return this.literals;
        }
    }

    @FunctionalInterface
    public static interface ExpressionCreator {
        public Expression create(Map<String, DataType> var1, boolean var2, String[] var3);
    }

    public static enum ExpressionFunction {
        YEAR((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), (SerializableSupplier<Function<LocalDateTime, Integer>>)(SerializableSupplier & Serializable)() -> LocalDateTime::getYear, referencedField.literals());
        }),
        MONTH((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), (SerializableSupplier<Function<LocalDateTime, Integer>>)(SerializableSupplier & Serializable)() -> LocalDateTime::getMonthValue, referencedField.literals());
        }),
        DAY((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), (SerializableSupplier<Function<LocalDateTime, Integer>>)(SerializableSupplier & Serializable)() -> LocalDateTime::getDayOfMonth, referencedField.literals());
        }),
        HOUR((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), (SerializableSupplier<Function<LocalDateTime, Integer>>)(SerializableSupplier & Serializable)() -> LocalDateTime::getHour, referencedField.literals());
        }),
        MINUTE((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), (SerializableSupplier<Function<LocalDateTime, Integer>>)(SerializableSupplier & Serializable)() -> LocalDateTime::getMinute, referencedField.literals());
        }),
        SECOND((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return TemporalToIntConverter.create(referencedField.field(), referencedField.fieldType(), (SerializableSupplier<Function<LocalDateTime, Integer>>)(SerializableSupplier & Serializable)() -> LocalDateTime::getSecond, referencedField.literals());
        }),
        DATE_FORMAT((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return DateFormat.create(referencedField.field(), referencedField.fieldType(), referencedField.literals());
        }),
        SUBSTRING((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return Expression.substring(referencedField.field(), referencedField.literals());
        }),
        TRUNCATE((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return Expression.truncate(referencedField.field(), referencedField.fieldType(), referencedField.literals());
        }),
        CAST((typeMapping, caseSensitive, args) -> Expression.cast(args)),
        NOW((typeMapping, caseSensitive, args) -> new NowExpression()),
        UPPER((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return new UpperExpression(referencedField.field(), referencedField.fieldType(), referencedField.literals());
        }),
        LOWER((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return new LowerExpression(referencedField.field(), referencedField.fieldType(), referencedField.literals());
        }),
        TRIM((typeMapping, caseSensitive, args) -> {
            ReferencedField referencedField = ReferencedField.checkArgument(typeMapping, caseSensitive, args);
            return new TrimExpression(referencedField.field(), referencedField.fieldType(), referencedField.literals());
        });

        public final ExpressionCreator creator;
        private static final Map<String, ExpressionCreator> EXPRESSION_FUNCTIONS;

        private ExpressionFunction(ExpressionCreator creator) {
            this.creator = creator;
        }

        public ExpressionCreator getCreator() {
            return this.creator;
        }

        public static ExpressionCreator creator(String exprName) {
            return EXPRESSION_FUNCTIONS.get(exprName.toLowerCase());
        }

        static {
            EXPRESSION_FUNCTIONS = Arrays.stream(ExpressionFunction.values()).collect(Collectors.toMap(value -> value.name().toLowerCase(), ExpressionFunction::getCreator));
        }
    }
}

