/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import java.util.Map;
import org.apache.flink.cdc.connectors.mongodb.source.MongoDBSource;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.SyncJobHandler;
import org.apache.paimon.flink.action.cdc.SyncTableActionBase;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBActionUtils;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBSchemaUtils;
import org.apache.paimon.flink.action.cdc.watermark.CdcTimestampExtractor;
import org.apache.paimon.schema.Schema;

public class MongoDBSyncTableAction
extends SyncTableActionBase {
    public MongoDBSyncTableAction(String database, String table, Map<String, String> catalogConfig, Map<String, String> mongodbConfig) {
        super(database, table, catalogConfig, mongodbConfig, SyncJobHandler.SourceType.MONGODB);
    }

    @Override
    protected Schema retrieveSchema() {
        return MongoDBSchemaUtils.getMongodbSchema(this.cdcSourceConfig);
    }

    @Override
    protected CdcTimestampExtractor createCdcTimestampExtractor() {
        return MongoDBActionUtils.createCdcTimestampExtractor();
    }

    protected MongoDBSource<CdcSourceRecord> buildSource() {
        this.validateRuntimeExecutionMode();
        String tableList = (String)this.cdcSourceConfig.get(MongoDBSourceOptions.DATABASE) + "\\." + (String)this.cdcSourceConfig.get(MongoDBSourceOptions.COLLECTION);
        return MongoDBActionUtils.buildMongodbSource(this.cdcSourceConfig, tableList);
    }
}

