/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import com.esri.core.geometry.ogc.OGCGeometry;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.paimon.flink.action.cdc.JdbcToPaimonTypeVisitor;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;

public class MySqlTypeUtils {
    private static final String BIT = "BIT";
    private static final String BOOLEAN = "BOOLEAN";
    private static final String BOOL = "BOOL";
    private static final String TINYINT = "TINYINT";
    private static final String TINYINT_UNSIGNED = "TINYINT UNSIGNED";
    private static final String TINYINT_UNSIGNED_ZEROFILL = "TINYINT UNSIGNED ZEROFILL";
    private static final String SMALLINT = "SMALLINT";
    private static final String SMALLINT_UNSIGNED = "SMALLINT UNSIGNED";
    private static final String SMALLINT_UNSIGNED_ZEROFILL = "SMALLINT UNSIGNED ZEROFILL";
    private static final String MEDIUMINT = "MEDIUMINT";
    private static final String MEDIUMINT_UNSIGNED = "MEDIUMINT UNSIGNED";
    private static final String MEDIUMINT_UNSIGNED_ZEROFILL = "MEDIUMINT UNSIGNED ZEROFILL";
    private static final String INT = "INT";
    private static final String INT_UNSIGNED = "INT UNSIGNED";
    private static final String INT_UNSIGNED_ZEROFILL = "INT UNSIGNED ZEROFILL";
    private static final String INTEGER = "INTEGER";
    private static final String INTEGER_UNSIGNED = "INTEGER UNSIGNED";
    private static final String INTEGER_UNSIGNED_ZEROFILL = "INTEGER UNSIGNED ZEROFILL";
    private static final String BIGINT = "BIGINT";
    private static final String SERIAL = "SERIAL";
    private static final String BIGINT_UNSIGNED = "BIGINT UNSIGNED";
    private static final String BIGINT_UNSIGNED_ZEROFILL = "BIGINT UNSIGNED ZEROFILL";
    private static final String REAL = "REAL";
    private static final String REAL_UNSIGNED = "REAL UNSIGNED";
    private static final String REAL_UNSIGNED_ZEROFILL = "REAL UNSIGNED ZEROFILL";
    private static final String FLOAT = "FLOAT";
    private static final String FLOAT_UNSIGNED = "FLOAT UNSIGNED";
    private static final String FLOAT_UNSIGNED_ZEROFILL = "FLOAT UNSIGNED ZEROFILL";
    private static final String DOUBLE = "DOUBLE";
    private static final String DOUBLE_UNSIGNED = "DOUBLE UNSIGNED";
    private static final String DOUBLE_UNSIGNED_ZEROFILL = "DOUBLE UNSIGNED ZEROFILL";
    private static final String DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String DOUBLE_PRECISION_UNSIGNED = "DOUBLE PRECISION UNSIGNED";
    private static final String DOUBLE_PRECISION_UNSIGNED_ZEROFILL = "DOUBLE PRECISION UNSIGNED ZEROFILL";
    private static final String NUMERIC = "NUMERIC";
    private static final String NUMERIC_UNSIGNED = "NUMERIC UNSIGNED";
    private static final String NUMERIC_UNSIGNED_ZEROFILL = "NUMERIC UNSIGNED ZEROFILL";
    private static final String FIXED = "FIXED";
    private static final String FIXED_UNSIGNED = "FIXED UNSIGNED";
    private static final String FIXED_UNSIGNED_ZEROFILL = "FIXED UNSIGNED ZEROFILL";
    private static final String DECIMAL = "DECIMAL";
    private static final String DECIMAL_UNSIGNED = "DECIMAL UNSIGNED";
    private static final String DECIMAL_UNSIGNED_ZEROFILL = "DECIMAL UNSIGNED ZEROFILL";
    private static final String CHAR = "CHAR";
    private static final String VARCHAR = "VARCHAR";
    private static final String TINYTEXT = "TINYTEXT";
    private static final String MEDIUMTEXT = "MEDIUMTEXT";
    private static final String TEXT = "TEXT";
    private static final String LONGTEXT = "LONGTEXT";
    private static final String DATE = "DATE";
    private static final String TIME = "TIME";
    private static final String DATETIME = "DATETIME";
    private static final String TIMESTAMP = "TIMESTAMP";
    private static final String YEAR = "YEAR";
    private static final String BINARY = "BINARY";
    private static final String VARBINARY = "VARBINARY";
    private static final String TINYBLOB = "TINYBLOB";
    private static final String MEDIUMBLOB = "MEDIUMBLOB";
    private static final String BLOB = "BLOB";
    private static final String LONGBLOB = "LONGBLOB";
    private static final String JSON = "JSON";
    private static final String SET = "SET";
    private static final String ENUM = "ENUM";
    private static final String GEOMETRY = "GEOMETRY";
    private static final String POINT = "POINT";
    private static final String LINESTRING = "LINESTRING";
    private static final String POLYGON = "POLYGON";
    private static final String MULTIPOINT = "MULTIPOINT";
    private static final String MULTILINESTRING = "MULTILINESTRING";
    private static final String MULTIPOLYGON = "MULTIPOLYGON";
    private static final String GEOMETRYCOLLECTION = "GEOMETRYCOLLECTION";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String LONG = "LONG";
    private static final String STRING = "STRING";
    private static final int JDBC_TIMESTAMP_BASE_LENGTH = 19;
    private static final String LEFT_BRACKETS = "(";
    private static final String RIGHT_BRACKETS = ")";
    private static final String COMMA = ",";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static Tuple3<String, Integer, Integer> getTypeInfo(String typeName) {
        String shortType;
        int leftBracketIndex = typeName.indexOf(LEFT_BRACKETS);
        int length = 0;
        int scale = 0;
        if (leftBracketIndex != -1) {
            int rightBracketIndex = typeName.indexOf(RIGHT_BRACKETS);
            shortType = typeName.substring(0, leftBracketIndex).trim().toUpperCase() + typeName.substring(rightBracketIndex + 1).toUpperCase();
            String insideBrackets = typeName.substring(leftBracketIndex + 1, rightBracketIndex).trim();
            int commaIndex = insideBrackets.indexOf(COMMA);
            if (commaIndex != -1 && !MySqlTypeUtils.isEnumType(shortType) && !MySqlTypeUtils.isSetType(shortType)) {
                length = Integer.parseInt(insideBrackets.substring(0, commaIndex).trim());
                scale = Integer.parseInt(insideBrackets.substring(commaIndex + 1).trim());
            } else if (!MySqlTypeUtils.isEnumType(shortType) && !MySqlTypeUtils.isSetType(shortType)) {
                length = Integer.parseInt(insideBrackets);
            }
        } else {
            shortType = typeName.toUpperCase();
            if (MySqlTypeUtils.isDecimalType(shortType)) {
                length = 38;
                scale = 18;
            }
        }
        return Tuple3.of((Object)shortType, (Object)length, (Object)scale);
    }

    public static DataType toDataType(String type, @Nullable Integer length, @Nullable Integer scale, TypeMapping typeMapping) {
        if (typeMapping.containsMode(TypeMapping.TypeMappingMode.TO_STRING)) {
            return DataTypes.STRING();
        }
        switch (type.toUpperCase()) {
            case "BIT": {
                if (length == null || length == 1) {
                    return DataTypes.BOOLEAN();
                }
                return DataTypes.BINARY((int)((length + 7) / 8));
            }
            case "BOOLEAN": 
            case "BOOL": {
                return DataTypes.BOOLEAN();
            }
            case "TINYINT": {
                return length != null && length == 1 && !typeMapping.containsMode(TypeMapping.TypeMappingMode.TINYINT1_NOT_BOOL) ? DataTypes.BOOLEAN() : DataTypes.TINYINT();
            }
            case "TINYINT UNSIGNED": 
            case "TINYINT UNSIGNED ZEROFILL": 
            case "SMALLINT": {
                return DataTypes.SMALLINT();
            }
            case "SMALLINT UNSIGNED": 
            case "SMALLINT UNSIGNED ZEROFILL": 
            case "INT": 
            case "INTEGER": 
            case "MEDIUMINT": 
            case "YEAR": {
                return DataTypes.INT();
            }
            case "INT UNSIGNED": 
            case "INTEGER UNSIGNED": 
            case "INT UNSIGNED ZEROFILL": 
            case "INTEGER UNSIGNED ZEROFILL": 
            case "MEDIUMINT UNSIGNED": 
            case "MEDIUMINT UNSIGNED ZEROFILL": 
            case "BIGINT": 
            case "LONG": {
                return DataTypes.BIGINT();
            }
            case "BIGINT UNSIGNED": 
            case "BIGINT UNSIGNED ZEROFILL": 
            case "SERIAL": {
                return typeMapping.containsMode(TypeMapping.TypeMappingMode.BIGINT_UNSIGNED_TO_BIGINT) ? DataTypes.BIGINT() : DataTypes.DECIMAL((int)20, (int)0);
            }
            case "FLOAT": 
            case "FLOAT UNSIGNED": 
            case "FLOAT UNSIGNED ZEROFILL": {
                return DataTypes.FLOAT();
            }
            case "REAL": 
            case "REAL UNSIGNED": 
            case "REAL UNSIGNED ZEROFILL": 
            case "DOUBLE": 
            case "DOUBLE UNSIGNED": 
            case "DOUBLE UNSIGNED ZEROFILL": 
            case "DOUBLE PRECISION": 
            case "DOUBLE PRECISION UNSIGNED": 
            case "DOUBLE PRECISION UNSIGNED ZEROFILL": {
                return DataTypes.DOUBLE();
            }
            case "NUMERIC": 
            case "NUMERIC UNSIGNED": 
            case "NUMERIC UNSIGNED ZEROFILL": 
            case "FIXED": 
            case "FIXED UNSIGNED": 
            case "FIXED UNSIGNED ZEROFILL": 
            case "DECIMAL": 
            case "DECIMAL UNSIGNED": 
            case "DECIMAL UNSIGNED ZEROFILL": {
                return length != null && length <= 38 ? DataTypes.DECIMAL((int)length, (int)(scale != null && scale >= 0 ? scale : 0)) : DataTypes.STRING();
            }
            case "DATE": {
                return DataTypes.DATE();
            }
            case "TIME": {
                return DataTypes.TIME();
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                if (length == null || length <= 0) {
                    return DataTypes.TIMESTAMP((int)0);
                }
                if (length >= 19) {
                    if (length > 20) {
                        return DataTypes.TIMESTAMP((int)(length - 19 - 1));
                    }
                    return DataTypes.TIMESTAMP((int)0);
                }
                if (length <= 9) {
                    return DataTypes.TIMESTAMP((int)length);
                }
                throw new UnsupportedOperationException("Unsupported length " + length + " for MySQL DATETIME and TIMESTAMP types");
            }
            case "CHAR": {
                return length == null || length == 0 || typeMapping.containsMode(TypeMapping.TypeMappingMode.CHAR_TO_STRING) ? DataTypes.STRING() : DataTypes.CHAR((int)length);
            }
            case "VARCHAR": {
                return length == null || length == 0 || typeMapping.containsMode(TypeMapping.TypeMappingMode.CHAR_TO_STRING) ? DataTypes.STRING() : DataTypes.VARCHAR((int)length);
            }
            case "TINYTEXT": 
            case "TEXT": 
            case "MEDIUMTEXT": 
            case "JSON": 
            case "ENUM": 
            case "GEOMETRY": 
            case "POINT": 
            case "LINESTRING": 
            case "POLYGON": 
            case "MULTIPOINT": 
            case "MULTILINESTRING": 
            case "MULTIPOLYGON": 
            case "GEOMETRYCOLLECTION": 
            case "STRING": {
                return DataTypes.STRING();
            }
            case "BINARY": 
            case "VARBINARY": {
                return length == null || length == 0 ? DataTypes.VARBINARY((int)1) : DataTypes.VARBINARY((int)length);
            }
            case "LONGTEXT": {
                return typeMapping.containsMode(TypeMapping.TypeMappingMode.LONGTEXT_TO_BYTES) ? DataTypes.BYTES() : DataTypes.STRING();
            }
            case "TINYBLOB": 
            case "BLOB": 
            case "MEDIUMBLOB": 
            case "LONGBLOB": {
                return DataTypes.BYTES();
            }
            case "SET": {
                return DataTypes.ARRAY((DataType)DataTypes.STRING());
            }
        }
        throw new UnsupportedOperationException(String.format("Don't support MySQL type '%s' yet.", type));
    }

    public static boolean isGeoType(String type) {
        switch (type.toUpperCase()) {
            case "GEOMETRY": 
            case "POINT": 
            case "LINESTRING": 
            case "POLYGON": 
            case "MULTIPOINT": 
            case "MULTILINESTRING": 
            case "MULTIPOLYGON": 
            case "GEOMETRYCOLLECTION": {
                return true;
            }
        }
        return false;
    }

    public static String convertWkbArray(byte[] wkb) throws JsonProcessingException {
        return MySqlTypeUtils.convertWkbArray(ByteBuffer.wrap(wkb));
    }

    public static String convertWkbArray(ByteBuffer wkbByteBuffer) throws JsonProcessingException {
        String geoJson = OGCGeometry.fromBinary((ByteBuffer)wkbByteBuffer).asGeoJson();
        JsonNode originGeoNode = objectMapper.readTree(geoJson);
        Optional<Object> srid = Optional.ofNullable(originGeoNode.has("srid") ? Integer.valueOf(originGeoNode.get("srid").intValue()) : null);
        HashMap<String, String> geometryInfo = new HashMap<String, String>();
        String geometryType = originGeoNode.get("type").asText();
        geometryInfo.put("type", geometryType);
        if (geometryType.equalsIgnoreCase("GeometryCollection")) {
            geometryInfo.put("geometries", (String)originGeoNode.get("geometries"));
        } else {
            geometryInfo.put("coordinates", (String)originGeoNode.get("coordinates"));
        }
        geometryInfo.put("srid", srid.orElse(0));
        ObjectWriter objectWriter = objectMapper.writer();
        return objectWriter.writeValueAsString(geometryInfo);
    }

    public static boolean isEnumType(String shortType) {
        return shortType.equals(ENUM);
    }

    public static boolean isSetType(String shortType) {
        return shortType.equals(SET);
    }

    private static boolean isDecimalType(String shortType) {
        switch (shortType) {
            case "NUMERIC": 
            case "NUMERIC UNSIGNED": 
            case "NUMERIC UNSIGNED ZEROFILL": 
            case "FIXED": 
            case "FIXED UNSIGNED": 
            case "FIXED UNSIGNED ZEROFILL": 
            case "DECIMAL": 
            case "DECIMAL UNSIGNED": 
            case "DECIMAL UNSIGNED ZEROFILL": {
                return true;
            }
        }
        return false;
    }

    public static JdbcToPaimonTypeVisitor toPaimonTypeVisitor() {
        return MySqlToPaimonTypeVisitor.INSTANCE;
    }

    private static class MySqlToPaimonTypeVisitor
    implements JdbcToPaimonTypeVisitor {
        private static final MySqlToPaimonTypeVisitor INSTANCE = new MySqlToPaimonTypeVisitor();

        private MySqlToPaimonTypeVisitor() {
        }

        @Override
        public DataType visit(String type, @Nullable Integer length, @Nullable Integer scale, TypeMapping typeMapping) {
            return MySqlTypeUtils.toDataType(type, length, scale, typeMapping);
        }
    }
}

