/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.pulsar;

import io.confluent.kafka.serializers.GenericContainerWithVersion;
import java.io.IOException;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.MessageQueueSchemaUtils;
import org.apache.paimon.flink.action.cdc.pulsar.PulsarActionUtils;
import org.apache.paimon.flink.action.cdc.serialization.ConfluentAvroDeserializationSchema;

public class PulsarDebeziumAvroDeserializationSchema
implements DeserializationSchema<CdcSourceRecord> {
    private static final long serialVersionUID = 1L;
    private final String topic;
    private final String schemaRegistryUrl;
    private ConfluentAvroDeserializationSchema avroDeserializer;

    public PulsarDebeziumAvroDeserializationSchema(Configuration cdcSourceConfig) {
        this.topic = PulsarActionUtils.findOneTopic(cdcSourceConfig);
        this.schemaRegistryUrl = (String)cdcSourceConfig.get(MessageQueueSchemaUtils.SCHEMA_REGISTRY_URL);
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.initAvroDeserializer();
    }

    public CdcSourceRecord deserialize(byte[] message) throws IOException {
        if (message == null) {
            return null;
        }
        if (this.avroDeserializer == null) {
            this.initAvroDeserializer();
        }
        GenericContainerWithVersion valueContainerWithVersion = this.avroDeserializer.deserialize(this.topic, false, message);
        GenericRecord value = (GenericRecord)valueContainerWithVersion.container();
        return new CdcSourceRecord(this.topic, null, value);
    }

    public boolean isEndOfStream(CdcSourceRecord nextElement) {
        return false;
    }

    public TypeInformation<CdcSourceRecord> getProducedType() {
        return TypeExtractor.getForClass(CdcSourceRecord.class);
    }

    private void initAvroDeserializer() {
        this.avroDeserializer = ConfluentAvroDeserializationSchema.create(this.schemaRegistryUrl);
    }
}

