/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.kafka;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.NewTopic;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.FlinkCatalogOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.kafka.KafkaLogOptions;
import org.apache.paimon.flink.kafka.KafkaLogStoreFactory;
import org.apache.paimon.flink.log.LogStoreRegister;
import org.apache.paimon.flink.log.LogStoreTableFactory;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.utils.Preconditions;

public class KafkaLogStoreRegister
implements LogStoreRegister {
    private final String bootstrapServers;
    private final String topic;
    private final int partition;
    private final int replicationFactor;
    private final Duration timeout;
    private final Properties properties;
    private final Identifier identifier;

    public KafkaLogStoreRegister(LogStoreTableFactory.RegisterContext context) {
        this.bootstrapServers = (String)context.getOptions().get(KafkaLogOptions.BOOTSTRAP_SERVERS);
        this.identifier = context.getIdentifier();
        this.topic = context.getOptions().getOptional(KafkaLogOptions.TOPIC).isPresent() ? (String)context.getOptions().get(KafkaLogOptions.TOPIC) : String.format("%s_%s_%s", this.identifier.getDatabaseName(), this.identifier.getObjectName(), UUID.randomUUID().toString().replace("-", ""));
        Preconditions.checkNotNull((Object)context.getOptions().get(KafkaLogOptions.BOOTSTRAP_SERVERS));
        Preconditions.checkNotNull((Object)this.topic);
        Preconditions.checkNotNull((Object)this.identifier);
        this.timeout = context.getOptions().get(FlinkCatalogOptions.REGISTER_TIMEOUT.key()) == null ? (Duration)FlinkCatalogOptions.REGISTER_TIMEOUT.defaultValue() : Duration.parse(context.getOptions().get(FlinkCatalogOptions.REGISTER_TIMEOUT.key()));
        int bucketNum = (Integer)context.getOptions().get(CoreOptions.BUCKET) == -1 ? 1 : (Integer)context.getOptions().get(CoreOptions.BUCKET);
        this.partition = context.getOptions().getOptional(FlinkConnectorOptions.LOG_SYSTEM_PARTITIONS).isPresent() ? (Integer)context.getOptions().get(FlinkConnectorOptions.LOG_SYSTEM_PARTITIONS) : bucketNum;
        this.replicationFactor = (Integer)context.getOptions().get(FlinkConnectorOptions.LOG_SYSTEM_REPLICATION);
        this.properties = KafkaLogStoreFactory.toKafkaProperties(context.getOptions());
    }

    public Map<String, String> registerTopic() {
        try (AdminClient admin = AdminClient.create((Properties)this.properties);){
            NewTopic newTopic = new NewTopic(this.topic, this.partition, (short)this.replicationFactor);
            admin.createTopics(Collections.singleton(newTopic)).all().get(this.timeout.getSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(String.format("Register topic for table %s timeout with properties %s", this.identifier.getFullName(), this.properties), e);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Register topic for table %s failed with properties %s", this.identifier.getFullName(), this.properties), e);
        }
        return ImmutableMap.of((Object)KafkaLogOptions.TOPIC.key(), (Object)this.topic, (Object)FlinkConnectorOptions.LOG_SYSTEM_PARTITIONS.key(), (Object)String.valueOf(this.partition), (Object)FlinkConnectorOptions.LOG_SYSTEM_REPLICATION.key(), (Object)String.valueOf(this.replicationFactor));
    }

    public void unRegisterTopic() {
        try (AdminClient admin = AdminClient.create((Properties)this.properties);){
            admin.deleteTopics(Collections.singleton(this.topic)).all().get(this.timeout.getSeconds(), TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UnknownTopicOrPartitionException) {
                return;
            }
            throw new IllegalStateException(String.format("Unregister topic for table %s failed with properties %s", this.identifier.getFullName(), this.properties), e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(String.format("Unregister topic for table %s timeout with properties %s", this.identifier.getFullName(), this.properties), e);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unregister topic for table %s failed with properties %s", this.identifier.getFullName(), this.properties), e);
        }
    }
}

