/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.ChannelComputer;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;

public abstract class CdcFixedBucketChannelComputerBase<T>
implements ChannelComputer<T> {
    protected final TableSchema schema;
    private transient int numChannels;
    private transient KeyAndBucketExtractor<T> extractor;

    public CdcFixedBucketChannelComputerBase(TableSchema schema) {
        this.schema = schema;
    }

    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.extractor = this.createExtractor();
    }

    protected abstract KeyAndBucketExtractor<T> createExtractor();

    public int channel(T record) {
        this.extractor.setRecord(record);
        return this.channel(this.extractor.partition(), this.extractor.bucket());
    }

    @VisibleForTesting
    int channel(BinaryRow partition, int bucket) {
        return ChannelComputer.select((BinaryRow)partition, (int)bucket, (int)this.numChannels);
    }

    public String toString() {
        return "shuffle by bucket";
    }
}

