/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.ReassignFieldId;
import org.apache.paimon.utils.Preconditions;

public class CdcSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<DataField> fields;
    private final List<String> primaryKeys;
    @Nullable
    private final String comment;

    public CdcSchema(List<DataField> fields, List<String> primaryKeys, @Nullable String comment) {
        this.fields = fields;
        this.primaryKeys = primaryKeys;
        this.comment = comment;
    }

    public List<DataField> fields() {
        return this.fields;
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public String comment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdcSchema that = (CdcSchema)o;
        return Objects.equals(this.fields, that.fields) && Objects.equals(this.primaryKeys, that.primaryKeys) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.primaryKeys, this.comment);
    }

    public String toString() {
        return "Schema{fields=" + this.fields + ", primaryKeys=" + this.primaryKeys + ", comment=" + this.comment + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<DataField> columns = new ArrayList<DataField>();
        private List<String> primaryKeys = new ArrayList<String>();
        @Nullable
        private String comment;
        private final AtomicInteger highestFieldId = new AtomicInteger(-1);

        public int getHighestFieldId() {
            return this.highestFieldId.get();
        }

        public Builder column(DataField dataField) {
            Preconditions.checkNotNull((Object)dataField, (String)"Data field must not be null.");
            Preconditions.checkNotNull((Object)dataField.name(), (String)"Column name must not be null.");
            Preconditions.checkNotNull((Object)dataField.type(), (String)"Data type must not be null.");
            this.columns.add(dataField);
            return this;
        }

        public Builder column(String columnName, DataType dataType) {
            return this.column(columnName, dataType, null);
        }

        public Builder column(String columnName, DataType dataType, @Nullable String description) {
            Preconditions.checkNotNull((Object)columnName, (String)"Column name must not be null.");
            Preconditions.checkNotNull((Object)dataType, (String)"Data type must not be null.");
            int id = this.highestFieldId.incrementAndGet();
            DataType reassignDataType = ReassignFieldId.reassign((DataType)dataType, (AtomicInteger)this.highestFieldId);
            this.columns.add(new DataField(id, columnName, reassignDataType, description));
            return this;
        }

        public Builder primaryKey(String ... columnNames) {
            return this.primaryKey(Arrays.asList(columnNames));
        }

        public Builder primaryKey(List<String> columnNames) {
            this.primaryKeys = new ArrayList<String>(columnNames);
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public CdcSchema build() {
            return new CdcSchema(this.columns, this.primaryKeys, this.comment);
        }
    }
}

