/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.ComputedColumnUtils;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComputedColumnUtilsTest {
    @Test
    public void testComputedColumns() {
        List<String> calColArgs = Arrays.asList("A=substring(B, 1)", "B=substring(ExistedColumn,1)", "C=now()", "D=substring(A, 1)", "E=substring(C,1)");
        List<DataField> physicalFields = Arrays.asList(new DataField(1, "ExistedColumn", (DataType)DataTypes.STRING()));
        List columns = ComputedColumnUtils.buildComputedColumns(calColArgs, physicalFields);
        Assertions.assertEquals(Arrays.asList("B", "C", "E", "A", "D"), columns.stream().map(ComputedColumn::columnName).collect(Collectors.toList()));
    }

    @Test
    public void testCycleReference() {
        List<String> calColArgs = Arrays.asList("A=substring(B, 1)", "B=substring(C, 1)", "C=substring(A, 1)");
        Assert.assertThrows(IllegalArgumentException.class, () -> ComputedColumnUtils.buildComputedColumns((List)calColArgs, Collections.emptyList()));
    }
}

