/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.kafka;

import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.kafka.KafkaDebeziumJsonDeserializationSchema;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaDebeziumJsonDeserializationSchemaTest {
    @Test
    public void testDeserializeWithNonJsonKey() throws Exception {
        KafkaDebeziumJsonDeserializationSchema schema = new KafkaDebeziumJsonDeserializationSchema();
        byte[] rawKey = "non-json-key".getBytes(StandardCharsets.UTF_8);
        byte[] jsonValue = "{\"after\":{\"id\":1},\"op\":\"c\"}".getBytes(StandardCharsets.UTF_8);
        CdcSourceRecord record = schema.deserialize(new ConsumerRecord("topic", 0, 0L, (Object)rawKey, (Object)jsonValue));
        Assertions.assertNotNull((Object)record, (String)"Deserialization should succeed and return a record");
        Assertions.assertNull((Object)record.getKey(), (String)"Key should be null when the Kafka key is not JSON");
        JsonNode valueNode = (JsonNode)record.getValue();
        Assertions.assertEquals((int)1, (int)valueNode.get("after").get("id").asInt(), (String)"Value JSON should be parsed correctly");
    }
}

