/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.core.execution.JobClient;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBActionITCaseBase;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBSyncDatabaseAction;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MongoDBSyncDatabaseActionITCase
extends MongoDBActionITCaseBase {
    @Test
    @Timeout(value=60L)
    public void testSchemaEvolution() throws Exception {
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-1", this.database, "database");
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-2", this.database, "database");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", this.database);
        MongoDBSyncDatabaseAction action = (MongoDBSyncDatabaseAction)this.syncDatabaseActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).build();
        this.runActionWithDefaultEnv((ActionBase)action);
        this.testSchemaEvolutionImpl("t1", "t2", this.database);
    }

    private void testSchemaEvolutionImpl(String table1Name, String table2Name, String dbName) throws Exception {
        this.waitingTables(table1Name, table2Name);
        FileStoreTable table1 = this.getFileStoreTable(table1Name);
        FileStoreTable table2 = this.getFileStoreTable(table2Name);
        RowType rowType1 = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "name", "description", "weight"});
        List<String> primaryKeys1 = Collections.singletonList("_id");
        List<String> expected = Arrays.asList("+I[100000000000000000000101, scooter, Small 2-wheel scooter, 3.14]", "+I[100000000000000000000102, car battery, 12V car battery, 8.1]", "+I[100000000000000000000103, 12-pack drill bits, 12-pack of drill bits with sizes ranging from #40 to #3, 0.8]");
        this.waitForResult(expected, table1, rowType1, primaryKeys1);
        RowType rowType2 = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "name", "address", "phone_number"});
        List<String> primaryKeys2 = Collections.singletonList("_id");
        expected = Arrays.asList("+I[100000000000000000000101, user_1, Shanghai, 123563291234]", "+I[100000000000000000000102, user_2, Beijing, 1234347891234]", "+I[100000000000000000000103, user_3, Hangzhou, 1235567891234]");
        this.waitForResult(expected, table2, rowType2, primaryKeys2);
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-3", dbName, "database");
        expected = Arrays.asList("+I[100000000000000000000101, scooter, Small 2-wheel scooter, 350]", "+I[100000000000000000000102, car battery, High-performance car battery, 8.1]", "+I[100000000000000000000103, 12-pack drill bits, Set of 12 professional-grade drill bits, 0.8]");
        this.waitForResult(expected, table1, rowType1, primaryKeys1);
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-4", dbName, "database");
        expected = Arrays.asList("+I[100000000000000000000101, user_1, Guangzhou, 123563291234]", "+I[100000000000000000000102, user_2, Beijing, 1234546591234]", "+I[100000000000000000000103, user_3, Nanjing, 1235567891234]");
        this.waitForResult(expected, table2, rowType2, primaryKeys2);
    }

    @Test
    public void testCatalogAndTableConfig() {
        MongoDBSyncDatabaseAction action = (MongoDBSyncDatabaseAction)this.syncDatabaseActionBuilder(this.getBasicMongoDBConfig()).withCatalogConfig(Collections.singletonMap("catalog-key", "catalog-value")).withTableConfig(Collections.singletonMap("table-key", "table-value")).build();
        Assertions.assertThat((Map)action.catalogConfig()).containsEntry((Object)"catalog-key", (Object)"catalog-value");
        Assertions.assertThat((Map)action.tableConfig()).containsExactlyEntriesOf(Collections.singletonMap("table-key", "table-value"));
    }

    @Test
    @Timeout(value=60L)
    public void testMongoDBNestedDataSynchronizationAndVerification() throws Exception {
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-5", this.database, "database");
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-6", this.database, "database");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", this.database);
        MongoDBSyncDatabaseAction action = (MongoDBSyncDatabaseAction)this.syncDatabaseActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).build();
        this.runActionWithDefaultEnv((ActionBase)action);
        this.waitingTables("t3", "t4");
        FileStoreTable table1 = this.getFileStoreTable("t3");
        FileStoreTable table2 = this.getFileStoreTable("t4");
        RowType rowType1 = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "country", "languages", "religions"});
        List<String> primaryKeys1 = Collections.singletonList("_id");
        List<String> expected1 = Arrays.asList("+I[610000000000000000000101, Switzerland, Italian, {\"f\":\"v\",\"n\":null}]", "+I[610000000000000000000102, Switzerland, Italian, ]", "+I[610000000000000000000103, Switzerland, [\"Italian\"], ]");
        this.waitForResult(expected1, table1, rowType1, primaryKeys1);
        RowType rowType2 = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "kind", "etag", "pageInfo", "items"});
        List<String> primaryKeys2 = Collections.singletonList("_id");
        List<String> expected2 = Arrays.asList("+I[610000000000000000000101, youtube#videoListResponse, \\\"79S54kzisD_9SOTfQLu_0TVQSpY/mYlS4-ghMGhc1wTFCwoQl3IYDZc\\\", {\"totalResults\":1,\"resultsPerPage\":1}, [{\"kind\":\"youtube#video\",\"etag\":\"\\\\\\\"79S54kzisD_9SOTfQLu_0TVQSpY/A4foLs-VO317Po_ulY6b5mSimZA\\\\\\\"\",\"id\":\"wHkPb68dxEw\",\"statistics\":{\"viewCount\":\"9211\",\"likeCount\":\"79\",\"dislikeCount\":\"11\",\"favoriteCount\":\"0\",\"commentCount\":\"29\"},\"topicDetails\":{\"topicIds\":[\"/m/02mjmr\"],\"relevantTopicIds\":[\"/m/0cnfvd\",\"/m/01jdpf\"]}}]]", "+I[610000000000000000000102, youtube#videoListResponse, \\\"79S54kzisD_9SOTfQLu_0TVQSpY/mYlS4-ghMGhc1wTFCwoQl3IYDZc\\\", page, [{\"kind\":\"youtube#video\",\"etag\":\"\\\\\\\"79S54kzisD_9SOTfQLu_0TVQSpY/A4foLs-VO317Po_ulY6b5mSimZA\\\\\\\"\",\"id\":\"wHkPb68dxEw\",\"statistics\":{\"viewCount\":\"9211\",\"likeCount\":\"79\",\"dislikeCount\":\"11\",\"favoriteCount\":\"0\",\"commentCount\":\"29\"},\"topicDetails\":{\"topicIds\":[\"/m/02mjmr\"],\"relevantTopicIds\":[\"/m/0cnfvd\",\"/m/01jdpf\"]}}]]", "+I[610000000000000000000103, youtube#videoListResponse, \\\"79S54kzisD_9SOTfQLu_0TVQSpY/mYlS4-ghMGhc1wTFCwoQl3IYDZc\\\", {\"pagehit\":{\"kind\":\"youtube#video\"},\"totalResults\":1,\"resultsPerPage\":1}, [{\"kind\":\"youtube#video\",\"etag\":\"\\\\\\\"79S54kzisD_9SOTfQLu_0TVQSpY/A4foLs-VO317Po_ulY6b5mSimZA\\\\\\\"\",\"id\":\"wHkPb68dxEw\",\"statistics\":{\"viewCount\":\"9211\",\"likeCount\":\"79\",\"dislikeCount\":\"11\",\"favoriteCount\":\"0\",\"commentCount\":\"29\"},\"topicDetails\":{\"topicIds\":[\"/m/02mjmr\"],\"relevantTopicIds\":[\"/m/0cnfvd\",\"/m/01jdpf\"]}}]]");
        this.waitForResult(expected2, table2, rowType2, primaryKeys2);
    }

    @Test
    @Timeout(value=60L)
    public void testDynamicTableCreationInMongoDB() throws Exception {
        String dbName = this.database + UUID.randomUUID();
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-5", dbName, "database");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", dbName);
        MongoDBSyncDatabaseAction action = (MongoDBSyncDatabaseAction)this.syncDatabaseActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).withCatalogConfig(Collections.singletonMap(CatalogOptions.CASE_SENSITIVE.key(), "false")).build();
        this.runActionWithDefaultEnv((ActionBase)action);
        this.waitingTables("t3");
        FileStoreTable table1 = this.getFileStoreTable("t3");
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-6", dbName, "database");
        this.waitingTables("t4");
        FileStoreTable table2 = this.getFileStoreTable("t4");
        RowType rowType1 = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "country", "languages", "religions"});
        List<String> primaryKeys1 = Collections.singletonList("_id");
        List<String> expected1 = Arrays.asList("+I[610000000000000000000101, Switzerland, Italian, {\"f\":\"v\",\"n\":null}]", "+I[610000000000000000000102, Switzerland, Italian, ]", "+I[610000000000000000000103, Switzerland, [\"Italian\"], ]");
        this.waitForResult(expected1, table1, rowType1, primaryKeys1);
        RowType rowType2 = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "kind", "etag", "pageinfo", "items"});
        List<String> primaryKeys2 = Collections.singletonList("_id");
        List<String> expected2 = Arrays.asList("+I[610000000000000000000101, youtube#videoListResponse, \\\"79S54kzisD_9SOTfQLu_0TVQSpY/mYlS4-ghMGhc1wTFCwoQl3IYDZc\\\", {\"totalResults\":1,\"resultsPerPage\":1}, [{\"kind\":\"youtube#video\",\"etag\":\"\\\\\\\"79S54kzisD_9SOTfQLu_0TVQSpY/A4foLs-VO317Po_ulY6b5mSimZA\\\\\\\"\",\"id\":\"wHkPb68dxEw\",\"statistics\":{\"viewCount\":\"9211\",\"likeCount\":\"79\",\"dislikeCount\":\"11\",\"favoriteCount\":\"0\",\"commentCount\":\"29\"},\"topicDetails\":{\"topicIds\":[\"/m/02mjmr\"],\"relevantTopicIds\":[\"/m/0cnfvd\",\"/m/01jdpf\"]}}]]", "+I[610000000000000000000102, youtube#videoListResponse, \\\"79S54kzisD_9SOTfQLu_0TVQSpY/mYlS4-ghMGhc1wTFCwoQl3IYDZc\\\", page, [{\"kind\":\"youtube#video\",\"etag\":\"\\\\\\\"79S54kzisD_9SOTfQLu_0TVQSpY/A4foLs-VO317Po_ulY6b5mSimZA\\\\\\\"\",\"id\":\"wHkPb68dxEw\",\"statistics\":{\"viewCount\":\"9211\",\"likeCount\":\"79\",\"dislikeCount\":\"11\",\"favoriteCount\":\"0\",\"commentCount\":\"29\"},\"topicDetails\":{\"topicIds\":[\"/m/02mjmr\"],\"relevantTopicIds\":[\"/m/0cnfvd\",\"/m/01jdpf\"]}}]]", "+I[610000000000000000000103, youtube#videoListResponse, \\\"79S54kzisD_9SOTfQLu_0TVQSpY/mYlS4-ghMGhc1wTFCwoQl3IYDZc\\\", {\"pagehit\":{\"kind\":\"youtube#video\"},\"totalResults\":1,\"resultsPerPage\":1}, [{\"kind\":\"youtube#video\",\"etag\":\"\\\\\\\"79S54kzisD_9SOTfQLu_0TVQSpY/A4foLs-VO317Po_ulY6b5mSimZA\\\\\\\"\",\"id\":\"wHkPb68dxEw\",\"statistics\":{\"viewCount\":\"9211\",\"likeCount\":\"79\",\"dislikeCount\":\"11\",\"favoriteCount\":\"0\",\"commentCount\":\"29\"},\"topicDetails\":{\"topicIds\":[\"/m/02mjmr\"],\"relevantTopicIds\":[\"/m/0cnfvd\",\"/m/01jdpf\"]}}]]");
        this.waitForResult(expected2, table2, rowType2, primaryKeys2);
    }

    @Test
    @Timeout(value=60L)
    public void testTableAffix() throws Exception {
        this.createFileStoreTable("test_prefix_t1_test_suffix", RowType.of((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "name", "description", "weight"}), Collections.emptyList(), Collections.singletonList("_id"), Collections.emptyList(), Collections.emptyMap());
        String dbName = this.database + UUID.randomUUID();
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-1", dbName, "database");
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-2", dbName, "database");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", dbName);
        MongoDBSyncDatabaseAction action = (MongoDBSyncDatabaseAction)this.syncDatabaseActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).withTablePrefix("test_prefix_").withTableSuffix("_test_suffix").includingTables(ThreadLocalRandom.current().nextBoolean() ? "t1|t2" : ".*").build();
        this.runActionWithDefaultEnv((ActionBase)action);
        this.testSchemaEvolutionImpl("test_prefix_t1_test_suffix", "test_prefix_t2_test_suffix", dbName);
    }

    @Test
    @Timeout(value=60L)
    public void testNewlyAddedTablesOptionsChange() throws Exception {
        String dbName = this.database + UUID.randomUUID();
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-5", dbName, "database");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", dbName);
        HashMap<String, String> tableConfig = new HashMap<String, String>();
        tableConfig.put("bucket", "1");
        tableConfig.put("sink.parallelism", "1");
        MongoDBSyncDatabaseAction action1 = (MongoDBSyncDatabaseAction)this.syncDatabaseActionBuilder(mongodbConfig).withTableConfig(tableConfig).build();
        JobClient jobClient = this.runActionWithDefaultEnv((ActionBase)action1);
        this.waitingTables("t3");
        jobClient.cancel();
        tableConfig.put("sink.savepoint.auto-tag", "true");
        tableConfig.put("tag.num-retained-max", "5");
        tableConfig.put("tag.automatic-creation", "process-time");
        tableConfig.put("tag.creation-period", "hourly");
        tableConfig.put("tag.creation-delay", "600000");
        tableConfig.put("snapshot.time-retained", "1h");
        tableConfig.put("snapshot.num-retained.min", "5");
        tableConfig.put("snapshot.num-retained.max", "10");
        tableConfig.put("changelog-producer", "input");
        MongoDBSyncDatabaseActionITCase.writeRecordsToMongoDB("test-data-6", dbName, "database");
        MongoDBSyncDatabaseAction action2 = (MongoDBSyncDatabaseAction)this.syncDatabaseActionBuilder(mongodbConfig).withTableConfig(tableConfig).build();
        this.runActionWithDefaultEnv((ActionBase)action2);
        this.waitingTables("t4");
        FileStoreTable table = this.getFileStoreTable("t4");
        Map tableOptions = table.options();
        Assertions.assertThat((Map)tableOptions).containsAllEntriesOf(tableConfig);
    }
}

