/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb.strategy;

import java.util.Collections;
import java.util.Map;
import org.apache.paimon.flink.action.cdc.mongodb.strategy.MongoVersionStrategy;
import org.apache.paimon.flink.sink.cdc.CdcSchema;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MongoVersionStrategyTest {
    MongoVersionStrategyTest() {
    }

    @Test
    void testParseFieldsFromJsonRecordWithDoubleValue() {
        String record = "{\n  \"_id\": {\"$oid\": \"507f1f77bcf86cd799439011\"},\n  \"name\": \"John Doe\",\n  \"age\": 30,\n  \"price\": 19.99,\n  \"active\": true\n}";
        String fieldPaths = "$.name,$.age,$.price,$.active";
        String fieldNames = "name,age,price,active";
        CdcSchema.Builder schemaBuilder = CdcSchema.newBuilder();
        Map result = MongoVersionStrategy.parseFieldsFromJsonRecord((String)record, (String)fieldPaths, (String)fieldNames, Collections.emptyList(), (CdcSchema.Builder)schemaBuilder);
        Assertions.assertThat((Map)result).containsEntry((Object)"name", (Object)"John Doe");
        Assertions.assertThat((Map)result).containsEntry((Object)"age", (Object)"30");
        Assertions.assertThat((Map)result).containsEntry((Object)"price", (Object)"19.99");
        Assertions.assertThat((Map)result).containsEntry((Object)"active", (Object)"true");
    }

    @Test
    void testParseFieldsFromJsonRecordWithStringValues() {
        String record = "{\n  \"_id\": {\"$oid\": \"507f1f77bcf86cd799439011\"},\n  \"name\": \"John Doe\",\n  \"description\": \"A sample record\"\n}";
        String fieldPaths = "$.name,$.description";
        String fieldNames = "name,description";
        CdcSchema.Builder schemaBuilder = CdcSchema.newBuilder();
        Map result = MongoVersionStrategy.parseFieldsFromJsonRecord((String)record, (String)fieldPaths, (String)fieldNames, Collections.emptyList(), (CdcSchema.Builder)schemaBuilder);
        Assertions.assertThat((Map)result).containsEntry((Object)"name", (Object)"John Doe");
        Assertions.assertThat((Map)result).containsEntry((Object)"description", (Object)"A sample record");
    }
}

