/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.flink.FlinkCatalogFactory;
import org.apache.paimon.flink.FlinkCatalogOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.log.LogSinkProvider;
import org.apache.paimon.flink.log.LogSourceProvider;
import org.apache.paimon.flink.log.LogStoreRegister;
import org.apache.paimon.flink.log.LogStoreTableFactory;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class FlinkCatalogTest {
    private static final String TESTING_LOG_STORE = "testing";
    private final ObjectPath path1 = new ObjectPath("db1", "t1");
    private final ObjectPath path3 = new ObjectPath("db1", "t2");
    private final ObjectPath tableInDefaultDb = new ObjectPath("default", "t1");
    private final ObjectPath tableInDefaultDb1 = new ObjectPath("default-db", "t1");
    private final ObjectPath nonExistDbPath = ObjectPath.fromString((String)"non.exist");
    private final ObjectPath nonExistObjectPath = ObjectPath.fromString((String)"db1.nonexist");
    private Catalog catalog;
    @TempDir
    public static java.nio.file.Path temporaryFolder;

    @BeforeEach
    public void beforeEach() throws IOException {
        String path = new File(temporaryFolder.toFile(), UUID.randomUUID().toString()).toString();
        Options conf = new Options();
        conf.setString("warehouse", path);
        conf.set(FlinkCatalogOptions.LOG_SYSTEM_AUTO_REGISTER, (Object)true);
        this.catalog = FlinkCatalogFactory.createCatalog((String)"test-catalog", (CatalogContext)CatalogContext.create((Options)conf), (ClassLoader)FlinkCatalogTest.class.getClassLoader());
    }

    private ResolvedSchema createSchema() {
        return new ResolvedSchema(Arrays.asList(Column.physical((String)"first", (DataType)DataTypes.STRING()), Column.physical((String)"second", (DataType)DataTypes.INT()), Column.physical((String)"third", (DataType)DataTypes.STRING()), Column.physical((String)"four", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()))}))), Collections.emptyList(), null);
    }

    private List<String> createPartitionKeys() {
        return Arrays.asList("second", "third");
    }

    private CatalogTable createAnotherTable(Map<String, String> options) {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), (String)"test comment", Collections.emptyList(), options);
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    private CatalogTable createAnotherPartitionedTable(Map<String, String> options) {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), (String)"test comment", this.createPartitionKeys(), options);
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    private CatalogTable createTable(Map<String, String> options) {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), (String)"test comment", Collections.emptyList(), options);
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    private CatalogTable createPartitionedTable(Map<String, String> options) {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), (String)"test comment", this.createPartitionKeys(), options);
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testAlterTable(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, table, (CatalogTable)this.catalog.getTable(this.path1));
        CatalogTable newTable = this.createAnotherTable(options);
        this.catalog.alterTable(this.path1, (CatalogBaseTable)newTable, false);
        Assertions.assertThat((Object)this.catalog.getTable(this.path1)).isNotEqualTo((Object)table);
        this.checkAlterTable(this.path1, newTable, (CatalogTable)this.catalog.getTable(this.path1));
        this.catalog.dropTable(this.path1, false);
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testListTables(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        this.catalog.createTable(this.path3, (CatalogBaseTable)this.createTable(options), false);
        Assertions.assertThat((int)this.catalog.listTables("db1").size()).isEqualTo(2L);
    }

    @Test
    public void testAlterTable_differentTypedTable() {
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateFlinkTable(Map<String, String> options) {
        CatalogTable table = this.createTable(options);
        HashMap<String, String> newOptions = new HashMap<String, String>(table.getOptions());
        newOptions.put("connector", "filesystem");
        CatalogTable newTable = table.copy(newOptions);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createTable(this.path1, (CatalogBaseTable)newTable, false)).isInstanceOf(CatalogException.class)).hasMessageContaining("Paimon Catalog only supports paimon tables");
    }

    @ParameterizedTest
    @MethodSource(value={"streamingOptionProvider"})
    public void testCreateTable_Streaming(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, table, (CatalogTable)this.catalog.getTable(this.path1));
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testAlterPartitionedTable(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createPartitionedTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, table, (CatalogTable)this.catalog.getTable(this.path1));
        CatalogTable newTable = this.createAnotherPartitionedTable(options);
        this.catalog.alterTable(this.path1, (CatalogBaseTable)newTable, false);
        this.checkAlterTable(this.path1, newTable, (CatalogTable)this.catalog.getTable(this.path1));
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateTable_Batch(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogBaseTable tableCreated = this.catalog.getTable(this.path1);
        this.checkCreateTable(this.path1, table, (CatalogTable)tableCreated);
        Assertions.assertThat((String)((String)tableCreated.getDescription().get())).isEqualTo("test comment");
        List tables = this.catalog.listTables("db1");
        Assertions.assertThat((int)tables.size()).isEqualTo(1L);
        Assertions.assertThat((String)((String)tables.get(0))).isEqualTo(this.path1.getObjectName());
        this.catalog.dropTable(this.path1, false);
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateTable_TableAlreadyExist_ignored(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, table, (CatalogTable)this.catalog.getTable(this.path1));
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createAnotherTable(options), true);
        this.checkCreateTable(this.path1, table, (CatalogTable)this.catalog.getTable(this.path1));
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreatePartitionedTable_Batch(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createPartitionedTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, table, (CatalogTable)this.catalog.getTable(this.path1));
        List tables = this.catalog.listTables("db1");
        Assertions.assertThat((int)tables.size()).isEqualTo(1L);
        Assertions.assertThat((String)((String)tables.get(0))).isEqualTo(this.path1.getObjectName());
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testDropDb_DatabaseNotEmptyException(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.dropDatabase("db1", true, false)).isInstanceOf(DatabaseNotEmptyException.class)).hasMessage("Database db1 in catalog test-catalog is not empty.");
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testTableExists(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        Assertions.assertThat((boolean)this.catalog.tableExists(this.path1)).isFalse();
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        Assertions.assertThat((boolean)this.catalog.tableExists(this.path1)).isTrue();
        Assertions.assertThat((boolean)this.catalog.tableExists(new ObjectPath(this.path1.getDatabaseName(), this.path1.getObjectName() + "$snapshots"))).isTrue();
        Assertions.assertThat((boolean)this.catalog.tableExists(new ObjectPath(this.path1.getDatabaseName(), this.path1.getObjectName() + "$unknown"))).isFalse();
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testAlterTable_TableNotExist_ignored(Map<String, String> options) throws Exception {
        this.catalog.alterTable(this.nonExistObjectPath, (CatalogBaseTable)this.createTable(options), true);
        Assertions.assertThat((boolean)this.catalog.tableExists(this.nonExistObjectPath)).isFalse();
    }

    @Test
    public void testDropTable_TableNotExist_ignored() throws Exception {
        this.catalog.dropTable(this.nonExistObjectPath, true);
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateTable_TableAlreadyExistException(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false)).isInstanceOf(TableAlreadyExistException.class)).hasMessage("Table (or view) db1.t1 already exists in Catalog test-catalog.");
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testDropTable_nonPartitionedTable(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        Assertions.assertThat((boolean)this.catalog.tableExists(this.path1)).isTrue();
        this.catalog.dropTable(this.path1, false);
        Assertions.assertThat((boolean)this.catalog.tableExists(this.path1)).isFalse();
    }

    @Test
    public void testGetTable_TableNotExistException() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.getTable(this.nonExistObjectPath)).isInstanceOf(TableNotExistException.class)).hasMessage("Table (or view) db1.nonexist does not exist in Catalog test-catalog.");
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testDbExists(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        Assertions.assertThat((boolean)this.catalog.databaseExists("db1")).isTrue();
    }

    @Test
    public void testGetDatabase() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogDatabase database = this.catalog.getDatabase(this.path1.getDatabaseName());
        Assertions.assertThat((Map)database.getProperties()).isEmpty();
        Assertions.assertThat((Optional)database.getDescription()).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.getDatabase(this.nonExistDbPath.getDatabaseName())).isInstanceOf(DatabaseNotExistException.class)).hasMessageContaining("Database non does not exist in Catalog test-catalog.");
    }

    @Test
    public void testDropDb_DatabaseNotExist_Ignore() throws Exception {
        this.catalog.dropDatabase("db1", true, false);
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testAlterTable_TableNotExistException(Map<String, String> options) throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.alterTable(this.nonExistDbPath, (CatalogBaseTable)this.createTable(options), false)).isInstanceOf(TableNotExistException.class)).hasMessage("Table (or view) non.exist does not exist in Catalog test-catalog.");
    }

    @Test
    public void testDropTable_TableNotExistException() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.dropTable(this.nonExistDbPath, false)).isInstanceOf(TableNotExistException.class)).hasMessage("Table (or view) non.exist does not exist in Catalog test-catalog.");
    }

    @Test
    public void testCreateDb_Database() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        List dbs = this.catalog.listDatabases();
        Assertions.assertThat((List)dbs).hasSize(2);
        Assertions.assertThat(new HashSet(dbs)).isEqualTo(new HashSet<String>(Arrays.asList(this.path1.getDatabaseName(), this.catalog.getDefaultDatabase())));
    }

    @Test
    public void testCreateDb_DatabaseAlreadyExistException() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createDatabase(this.path1.getDatabaseName(), null, false)).isInstanceOf(DatabaseAlreadyExistException.class)).hasMessage("Database db1 already exists in Catalog test-catalog.");
    }

    @Test
    public void testCreateDb_DatabaseWithPropertiesException() {
        CatalogDatabaseImpl database = new CatalogDatabaseImpl(Collections.singletonMap("haa", "ccc"), null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createDatabase(this.path1.getDatabaseName(), (CatalogDatabase)database, false)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Create database with properties is unsupported.");
    }

    @Test
    public void testCreateDb_DatabaseWithCommentException() {
        CatalogDatabaseImpl database = new CatalogDatabaseImpl(Collections.emptyMap(), "haha");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createDatabase(this.path1.getDatabaseName(), (CatalogDatabase)database, false)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Create database with description is unsupported.");
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateTable_DatabaseNotExistException(Map<String, String> options) {
        Assertions.assertThat((boolean)this.catalog.databaseExists(this.path1.getDatabaseName())).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createTable(this.nonExistObjectPath, (CatalogBaseTable)this.createTable(options), false)).isInstanceOf(DatabaseNotExistException.class)).hasMessage("Database db1 does not exist in Catalog test-catalog.");
    }

    @Test
    public void testDropDb_DatabaseNotExistException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.dropDatabase(this.path1.getDatabaseName(), false, false)).isInstanceOf(DatabaseNotExistException.class)).hasMessage("Database db1 does not exist in Catalog test-catalog.");
    }

    @Test
    public void testCreateTableWithColumnOptions() throws Exception {
        TableSchema schema = TableSchema.builder().field("pk", (DataType)DataTypes.INT().notNull()).field("test", DataTypes.INT()).field("comp", DataTypes.INT(), "test + 1").primaryKey(new String[]{"pk"}).build();
        CatalogTableImpl catalogTable = new CatalogTableImpl(schema, new HashMap(), "");
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)catalogTable, false);
        CatalogTable got = (CatalogTable)this.catalog.getTable(this.path1);
        TableSchema newSchema = got.getSchema();
        Assertions.assertThat((List)schema.getTableColumns()).isEqualTo((Object)newSchema.getTableColumns());
        Assertions.assertThat((List)((UniqueConstraint)schema.getPrimaryKey().get()).getColumns()).isEqualTo((Object)((UniqueConstraint)newSchema.getPrimaryKey().get()).getColumns());
        Map expected = got.getOptions();
        expected.remove("path");
        expected.remove(FlinkCatalogOptions.REGISTER_TIMEOUT.key());
        Assertions.assertThat((Map)catalogTable.getOptions()).isEqualTo((Object)expected);
    }

    @Test
    public void testCreateTableWithLogSystemRegister() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        TableSchema schema = TableSchema.builder().field("pk", (DataType)DataTypes.INT().notNull()).field("test", DataTypes.INT()).field("comp", DataTypes.INT(), "test + 1").primaryKey(new String[]{"pk"}).build();
        HashMap<String, String> options = new HashMap<String, String>();
        CatalogTableImpl catalogTable1 = new CatalogTableImpl(schema, options, "");
        this.catalog.createTable(this.path1, (CatalogBaseTable)catalogTable1, false);
        CatalogBaseTable storedTable1 = this.catalog.getTable(this.path1);
        Assertions.assertThat((boolean)storedTable1.getOptions().containsKey("testing.log.store.topic")).isFalse();
        options.put(FlinkConnectorOptions.LOG_SYSTEM.key(), TESTING_LOG_STORE);
        CatalogTableImpl catalogTable2 = new CatalogTableImpl(schema, options, "");
        this.catalog.createTable(this.path3, (CatalogBaseTable)catalogTable2, false);
        CatalogBaseTable storedTable2 = this.catalog.getTable(this.path3);
        Assertions.assertThat((String)((String)storedTable2.getOptions().get("testing.log.store.topic"))).isEqualTo(String.format("%s-topic", this.path3.getObjectName()));
        Assertions.assertThatThrownBy(() -> this.catalog.dropTable(this.path3, true)).hasMessage("Check unregister log store topic here.");
    }

    @Test
    public void testDisableCreateTableInDefaultDB() throws TableAlreadyExistException, DatabaseNotExistException, DatabaseAlreadyExistException {
        String path = new File(temporaryFolder.toFile(), UUID.randomUUID().toString()).toString();
        Options conf = new Options();
        conf.setString("warehouse", path);
        conf.set(FlinkCatalogOptions.LOG_SYSTEM_AUTO_REGISTER, (Object)true);
        conf.set(FlinkCatalogOptions.DISABLE_CREATE_TABLE_IN_DEFAULT_DB, (Object)true);
        FlinkCatalog catalog = FlinkCatalogFactory.createCatalog((String)"test-ddl-catalog", (CatalogContext)CatalogContext.create((Options)conf), (ClassLoader)FlinkCatalogTest.class.getClassLoader());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testDisableCreateTableInDefaultDB$13((Catalog)catalog)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Creating table in default database is disabled, please specify a database name.");
        catalog.createDatabase("db1", null, false);
        Assertions.assertThatCode(() -> this.lambda$testDisableCreateTableInDefaultDB$14((Catalog)catalog)).doesNotThrowAnyException();
        conf.set(FlinkCatalogOptions.DEFAULT_DATABASE, (Object)"default-db");
        FlinkCatalog catalog1 = FlinkCatalogFactory.createCatalog((String)"test-ddl-catalog1", (CatalogContext)CatalogContext.create((Options)conf), (ClassLoader)FlinkCatalogTest.class.getClassLoader());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testDisableCreateTableInDefaultDB$15((Catalog)catalog1)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Creating table in default database is disabled, please specify a database name.");
    }

    @Test
    void testCreateTableFromTableDescriptor() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        ResolvedSchema resolvedSchema = this.createSchema();
        TableDescriptor tableDescriptor = TableDescriptor.forConnector((String)"paimon").schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).build();
        ResolvedCatalogTable catalogTable = new ResolvedCatalogTable(tableDescriptor.toCatalogTable(), resolvedSchema);
        this.catalog.createTable(this.path1, (CatalogBaseTable)catalogTable, false);
        this.checkCreateTable(this.path1, (CatalogTable)catalogTable, (CatalogTable)this.catalog.getTable(this.path1));
    }

    private void checkCreateTable(ObjectPath path, CatalogTable expected, CatalogTable actual) {
        this.checkEquals(path, expected, actual, Collections.singletonMap(FlinkCatalogOptions.REGISTER_TIMEOUT.key(), ((Duration)FlinkCatalogOptions.REGISTER_TIMEOUT.defaultValue()).toString()), Collections.singleton(FactoryUtil.CONNECTOR.key()));
    }

    private void checkAlterTable(ObjectPath path, CatalogTable expected, CatalogTable actual) {
        this.checkEquals(path, expected, actual, Collections.emptyMap(), Collections.emptySet());
    }

    private void checkEquals(ObjectPath path, CatalogTable t1, CatalogTable t2, Map<String, String> optionsToAdd, Set<String> optionsToRemove) {
        Path tablePath = ((AbstractCatalog)((FlinkCatalog)this.catalog).catalog()).getDataTableLocation(FlinkCatalog.toIdentifier((ObjectPath)path));
        HashMap<String, String> options = new HashMap<String, String>(t1.getOptions());
        options.put("path", tablePath.toString());
        options.putAll(optionsToAdd);
        optionsToRemove.forEach(options::remove);
        t1 = ((ResolvedCatalogTable)t1).copy(options);
        FlinkCatalogTest.checkEquals(t1, t2);
    }

    private static void checkEquals(CatalogTable t1, CatalogTable t2) {
        Assertions.assertThat((Comparable)t2.getTableKind()).isEqualTo((Object)t1.getTableKind());
        Assertions.assertThat((Object)t2.getSchema()).isEqualTo((Object)t1.getSchema());
        Assertions.assertThat((String)t2.getComment()).isEqualTo(t1.getComment());
        Assertions.assertThat((List)t2.getPartitionKeys()).isEqualTo((Object)t1.getPartitionKeys());
        Assertions.assertThat((boolean)t2.isPartitioned()).isEqualTo(t1.isPartitioned());
        Assertions.assertThat((Map)t2.getOptions()).isEqualTo((Object)t1.getOptions());
    }

    static Stream<Map<String, String>> streamingOptionProvider() {
        return FlinkCatalogTest.optionProvider(true);
    }

    static Stream<Map<String, String>> batchOptionProvider() {
        return FlinkCatalogTest.optionProvider(false);
    }

    private static Stream<Map<String, String>> optionProvider(boolean isStreaming) {
        ArrayList allOptions = new ArrayList();
        for (CoreOptions.StartupMode mode : CoreOptions.StartupMode.values()) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("is_streaming", String.valueOf(isStreaming));
            options.put("scan.mode", mode.toString());
            if (mode == CoreOptions.StartupMode.FROM_SNAPSHOT || mode == CoreOptions.StartupMode.FROM_SNAPSHOT_FULL) {
                options.put("scan.snapshot-id", "1");
            } else if (mode == CoreOptions.StartupMode.FROM_TIMESTAMP) {
                options.put("scan.timestamp-millis", System.currentTimeMillis() + "");
            } else if (mode == CoreOptions.StartupMode.INCREMENTAL) {
                options.put("incremental-between", "2,5");
            }
            if (isStreaming && mode == CoreOptions.StartupMode.INCREMENTAL) continue;
            allOptions.add(options);
        }
        return allOptions.stream();
    }

    private /* synthetic */ void lambda$testDisableCreateTableInDefaultDB$15(Catalog catalog1) throws Throwable {
        catalog1.createTable(this.tableInDefaultDb1, (CatalogBaseTable)this.createTable(new HashMap<String, String>(0)), false);
    }

    private /* synthetic */ void lambda$testDisableCreateTableInDefaultDB$14(Catalog catalog) throws Throwable {
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(new HashMap<String, String>(0)), false);
    }

    private /* synthetic */ void lambda$testDisableCreateTableInDefaultDB$13(Catalog catalog) throws Throwable {
        catalog.createTable(this.tableInDefaultDb, (CatalogBaseTable)this.createTable(new HashMap<String, String>(0)), false);
    }

    private static class TestingLogStoreRegister
    implements LogStoreRegister {
        private final Identifier table;

        private TestingLogStoreRegister(Identifier table) {
            this.table = table;
        }

        public Map<String, String> registerTopic() {
            return Collections.singletonMap("testing.log.store.topic", String.format("%s-topic", this.table.getObjectName()));
        }

        public void unRegisterTopic() {
            throw new UnsupportedOperationException("Check unregister log store topic here.");
        }
    }

    public static class TestingLogSoreRegisterFactory
    implements LogStoreTableFactory {
        public String identifier() {
            return FlinkCatalogTest.TESTING_LOG_STORE;
        }

        public LogSourceProvider createSourceProvider(DynamicTableFactory.Context context, DynamicTableSource.Context sourceContext, @Nullable int[][] projectFields) {
            throw new UnsupportedOperationException();
        }

        public LogSinkProvider createSinkProvider(DynamicTableFactory.Context context, DynamicTableSink.Context sinkContext) {
            throw new UnsupportedOperationException();
        }

        public LogStoreRegister createRegister(LogStoreTableFactory.RegisterContext context) {
            return new TestingLogStoreRegister(context.getIdentifier());
        }
    }
}

