/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class LargeDataITCase
extends CatalogITCaseBase {
    @Test
    public void testSpillableWriteBuffer() throws Exception {
        this.setParallelism(1);
        this.sql("CREATE TABLE T1 (a INT PRIMARY KEY NOT ENFORCED, b INT) WITH ('write-buffer-size'='256 kb', 'write-buffer-spillable'='true')", new Object[0]);
        this.sql("CREATE TABLE T2 (a INT PRIMARY KEY NOT ENFORCED, b INT)", new Object[0]);
        this.sql("CREATE TEMPORARY TABLE datagen (a INT, b INT) WITH ('connector'='datagen', 'fields.a.min'='0', 'fields.a.max'='50000', 'fields.b.min'='0', 'fields.b.max'='10', 'number-of-rows'='20000')", new Object[0]);
        this.tEnv.createStatementSet().addInsertSql("INSERT INTO T1 SELECT * FROM datagen").addInsertSql("INSERT INTO T2 SELECT * FROM datagen").execute().await();
        List<Row> result1 = this.sql("SELECT * FROM T1", new Object[0]);
        List<Row> result2 = this.sql("SELECT * FROM T2", new Object[0]);
        Assertions.assertThat(result1).containsExactlyElementsOf(result2);
    }

    @Test
    public void testPartitionedSpillableWriteBuffer() throws Exception {
        this.sql("CREATE TABLE T1 (a INT, b INT, c INT, PRIMARY KEY (a, b) NOT ENFORCED) PARTITIONED BY (b) WITH ('write-buffer-size'='1 mb', 'write-buffer-spillable'='true')", new Object[0]);
        this.sql("CREATE TABLE T2 (a INT, b INT, c INT, PRIMARY KEY (a, b) NOT ENFORCED) PARTITIONED BY (b)", new Object[0]);
        this.sql("CREATE TEMPORARY TABLE datagen (a INT, b INT, c INT) WITH ('connector'='datagen', 'number-of-rows'='10000', 'fields.b.min'='1', 'fields.b.max'='10')", new Object[0]);
        this.tEnv.createStatementSet().addInsertSql("INSERT INTO T1 SELECT * FROM datagen").addInsertSql("INSERT INTO T2 SELECT * FROM datagen").execute().await();
        List<Row> result1 = this.sql("SELECT * FROM T1", new Object[0]);
        List<Row> result2 = this.sql("SELECT * FROM T2", new Object[0]);
        Assertions.assertThat(result1).containsExactlyInAnyOrderElementsOf(result2);
    }
}

