/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.action.CompactAction;
import org.apache.paimon.flink.util.AbstractTestBase;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.utils.FailingFileIO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class PrimaryKeyFileStoreTableITCase
extends AbstractTestBase {
    private String path;
    private Map<String, String> tableDefaultProperties;
    private static final int NUM_PARTS = 4;
    private static final int NUM_KEYS = 64;
    private static final int NUM_VALUES = 1024;
    private static final int LIMIT = 10000;

    @BeforeEach
    public void before() throws IOException {
        this.path = this.getTempDirPath();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.tableDefaultProperties = new HashMap<String, String>();
        if (random.nextBoolean()) {
            this.tableDefaultProperties.put(CoreOptions.LOCAL_MERGE_BUFFER_SIZE.key(), "256 kb");
        }
    }

    private TableEnvironment createBatchTableEnvironment() {
        return TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
    }

    private TableEnvironment createStreamingTableEnvironment(int checkpointIntervalMs) {
        TableEnvironment sEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().inStreamingMode().build());
        sEnv.getConfig().getConfiguration().set(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL, (Object)Duration.ofMillis(checkpointIntervalMs));
        return sEnv;
    }

    private StreamExecutionEnvironment createStreamExecutionEnvironment(int checkpointIntervalMs) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getCheckpointConfig().setCheckpointingMode(CheckpointingMode.EXACTLY_ONCE);
        env.getCheckpointConfig().setCheckpointInterval((long)checkpointIntervalMs);
        return env;
    }

    private String createCatalogSql(String catalogName, String warehouse) {
        String defaultPropertyString = "";
        if (this.tableDefaultProperties.size() > 0) {
            defaultPropertyString = ", ";
            defaultPropertyString = defaultPropertyString + this.tableDefaultProperties.entrySet().stream().map(e -> String.format("'table-default.%s' = '%s'", e.getKey(), e.getValue())).collect(Collectors.joining(", "));
        }
        return String.format("CREATE CATALOG `%s` WITH ( 'type' = 'paimon', 'warehouse' = '%s' %s )", catalogName, warehouse, defaultPropertyString);
    }

    @Test
    @Timeout(value=1200L)
    public void testFullCompactionTriggerInterval() throws Exception {
        this.innerTestChangelogProducing(Arrays.asList("'changelog-producer' = 'full-compaction'", "'full-compaction.delta-commits' = '3'"));
    }

    @Test
    @Timeout(value=1200L)
    public void testFullCompactionWithLongCheckpointInterval() throws Exception {
        TableEnvironment bEnv = this.createBatchTableEnvironment();
        bEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)1);
        bEnv.executeSql(this.createCatalogSql("testCatalog", this.path));
        bEnv.executeSql("USE CATALOG testCatalog");
        bEnv.executeSql("CREATE TABLE T (  k INT,  v INT,  PRIMARY KEY (k) NOT ENFORCED) WITH (  'bucket' = '1',  'changelog-producer' = 'full-compaction',  'write-only' = 'true')");
        TableEnvironment sEnv = this.createStreamingTableEnvironment(100);
        sEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)1);
        sEnv.executeSql(this.createCatalogSql("testCatalog", this.path));
        sEnv.executeSql("USE CATALOG testCatalog");
        CloseableIterator it = sEnv.executeSql("SELECT * FROM T").collect();
        StreamExecutionEnvironment env = this.createStreamExecutionEnvironment(2000);
        env.setParallelism(1);
        env.setRestartStrategy(RestartStrategies.noRestart());
        new CompactAction(this.path, "default", "T").withStreamExecutionEnvironment(env).build();
        JobClient client = env.executeAsync();
        long startMs = System.currentTimeMillis();
        int currentKey = 0;
        while (System.currentTimeMillis() - startMs <= 10000L) {
            bEnv.executeSql(String.format("INSERT INTO T VALUES (%d, %d)", ++currentKey, currentKey * 100)).await();
        }
        Assertions.assertThat((Comparable)((Comparable)client.getJobStatus().get())).isEqualTo((Object)JobStatus.RUNNING);
        for (int i = 1; i <= currentKey; ++i) {
            Assertions.assertThat((boolean)it.hasNext()).isTrue();
            Assertions.assertThat((String)((Row)it.next()).toString()).isEqualTo(String.format("+I[%d, %d]", i, i * 100));
        }
        it.close();
    }

    @Test
    @Timeout(value=1200L)
    public void testLookupChangelog() throws Exception {
        this.innerTestChangelogProducing(Collections.singletonList("'changelog-producer' = 'lookup'"));
    }

    private void innerTestChangelogProducing(List<String> options) throws Exception {
        int i;
        TableEnvironment sEnv = this.createStreamingTableEnvironment(ThreadLocalRandom.current().nextInt(900) + 100);
        sEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)1);
        sEnv.executeSql(this.createCatalogSql("testCatalog", this.path + "/warehouse"));
        sEnv.executeSql("USE CATALOG testCatalog");
        sEnv.executeSql("CREATE TABLE T ( k INT, v STRING, PRIMARY KEY (k) NOT ENFORCED ) WITH ( 'bucket' = '2', " + String.join((CharSequence)",", options) + ")");
        Path inputPath = new Path(this.path, "input");
        LocalFileIO.create().mkdirs(inputPath);
        sEnv.executeSql("CREATE TABLE `default_catalog`.`default_database`.`S` ( i INT, g STRING ) WITH ( 'connector' = 'filesystem', 'format' = 'testcsv', 'path' = '" + inputPath + "', 'source.monitor-interval' = '500ms' )");
        sEnv.executeSql("INSERT INTO T SELECT SUM(i) AS k, g AS v FROM `default_catalog`.`default_database`.`S` GROUP BY g");
        CloseableIterator it = sEnv.executeSql("SELECT * FROM T").collect();
        sEnv.executeSql("INSERT INTO `default_catalog`.`default_database`.`S` VALUES (1, 'A'), (2, 'B'), (3, 'C'), (4, 'D')").await();
        ArrayList<String> actual = new ArrayList<String>();
        for (i = 0; i < 4; ++i) {
            actual.add(((Row)it.next()).toString());
        }
        Assertions.assertThat(actual).containsExactlyInAnyOrder((Object[])new String[]{"+I[1, A]", "+I[2, B]", "+I[3, C]", "+I[4, D]"});
        sEnv.executeSql("INSERT INTO `default_catalog`.`default_database`.`S` VALUES (1, 'A'), (1, 'B'), (1, 'C'), (1, 'D')").await();
        actual.clear();
        for (i = 0; i < 8; ++i) {
            actual.add(((Row)it.next()).toString());
        }
        Assertions.assertThat(actual).containsExactlyInAnyOrder((Object[])new String[]{"-D[1, A]", "-U[2, B]", "+U[2, A]", "-U[3, C]", "+U[3, B]", "-U[4, D]", "+U[4, C]", "+I[5, D]"});
        it.close();
    }

    @Test
    @Timeout(value=1200L)
    public void testNoChangelogProducerBatchRandom() throws Exception {
        TableEnvironment bEnv = this.createBatchTableEnvironment();
        this.testNoChangelogProducerRandom(bEnv, 1, false);
    }

    @Test
    @Timeout(value=1200L)
    public void testNoChangelogProducerStreamingRandom() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        TableEnvironment sEnv = this.createStreamingTableEnvironment(random.nextInt(900) + 100);
        this.testNoChangelogProducerRandom(sEnv, random.nextInt(1, 3), random.nextBoolean());
    }

    @Test
    @Timeout(value=1200L)
    public void testFullCompactionChangelogProducerBatchRandom() throws Exception {
        TableEnvironment bEnv = this.createBatchTableEnvironment();
        this.testFullCompactionChangelogProducerRandom(bEnv, 1, false);
    }

    @Test
    @Timeout(value=1200L)
    public void testFullCompactionChangelogProducerStreamingRandom() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        TableEnvironment sEnv = this.createStreamingTableEnvironment(random.nextInt(900) + 100);
        this.testFullCompactionChangelogProducerRandom(sEnv, random.nextInt(1, 3), random.nextBoolean());
    }

    @Test
    @Timeout(value=1200L)
    public void testStandAloneFullCompactJobRandom() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        TableEnvironment sEnv = this.createStreamingTableEnvironment(random.nextInt(900) + 100);
        this.testStandAloneFullCompactJobRandom(sEnv, random.nextInt(1, 3), random.nextBoolean());
    }

    @Test
    @Timeout(value=1200L)
    public void testLookupChangelogProducerBatchRandom() throws Exception {
        TableEnvironment bEnv = this.createBatchTableEnvironment();
        this.testLookupChangelogProducerRandom(bEnv, 1, false);
    }

    @Test
    @Timeout(value=1200L)
    public void testLookupChangelogProducerStreamingRandom() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        TableEnvironment sEnv = this.createStreamingTableEnvironment(random.nextInt(900) + 100);
        this.testLookupChangelogProducerRandom(sEnv, random.nextInt(1, 3), random.nextBoolean());
    }

    @Test
    @Timeout(value=1200L)
    public void testStandAloneLookupJobRandom() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        TableEnvironment sEnv = this.createStreamingTableEnvironment(random.nextInt(900) + 100);
        this.testStandAloneLookupJobRandom(sEnv, random.nextInt(1, 3), random.nextBoolean());
    }

    private void testNoChangelogProducerRandom(TableEnvironment tEnv, int numProducers, boolean enableFailure) throws Exception {
        List<TableResult> results = this.testRandom(tEnv, numProducers, enableFailure, "'bucket' = '4'");
        for (TableResult result : results) {
            result.await();
        }
        this.checkBatchResult(numProducers);
    }

    private void testFullCompactionChangelogProducerRandom(TableEnvironment tEnv, int numProducers, boolean enableFailure) throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.testRandom(tEnv, numProducers, enableFailure, "'bucket' = '4'," + String.format("'write-buffer-size' = '%s',", random.nextBoolean() ? "512kb" : "1mb") + "'changelog-producer' = 'full-compaction','full-compaction.delta-commits' = '3'");
        Thread.sleep(random.nextInt(5000));
        this.checkChangelogTestResult(numProducers);
    }

    private void testLookupChangelogProducerRandom(TableEnvironment tEnv, int numProducers, boolean enableFailure) throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.testRandom(tEnv, numProducers, enableFailure, "'bucket' = '4'," + String.format("'write-buffer-size' = '%s',", random.nextBoolean() ? "512kb" : "1mb") + "'changelog-producer' = 'lookup'");
        Thread.sleep(random.nextInt(5000));
        this.checkChangelogTestResult(numProducers);
    }

    private void testStandAloneFullCompactJobRandom(TableEnvironment tEnv, int numProducers, boolean enableConflicts) throws Exception {
        int i;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.testRandom(tEnv, numProducers, false, "'bucket' = '4'," + String.format("'write-buffer-size' = '%s',", random.nextBoolean() ? "512kb" : "1mb") + "'changelog-producer' = 'full-compaction','full-compaction.delta-commits' = '3','write-only' = 'true'");
        Thread.sleep(random.nextInt(2500));
        int n = i = enableConflicts ? 2 : 1;
        while (i > 0) {
            StreamExecutionEnvironment env = this.createStreamExecutionEnvironment(random.nextInt(1900) + 100);
            env.setParallelism(2);
            new CompactAction(this.path, "default", "T").withStreamExecutionEnvironment(env).build();
            env.executeAsync();
            --i;
        }
        Thread.sleep(random.nextInt(2500));
        this.checkChangelogTestResult(numProducers);
    }

    private void testStandAloneLookupJobRandom(TableEnvironment tEnv, int numProducers, boolean enableConflicts) throws Exception {
        int i;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.testRandom(tEnv, numProducers, false, "'bucket' = '4'," + String.format("'write-buffer-size' = '%s',", random.nextBoolean() ? "512kb" : "1mb") + "'changelog-producer' = 'lookup','write-only' = 'true'");
        Thread.sleep(random.nextInt(2500));
        int n = i = enableConflicts ? 2 : 1;
        while (i > 0) {
            StreamExecutionEnvironment env = this.createStreamExecutionEnvironment(random.nextInt(1900) + 100);
            env.setParallelism(2);
            new CompactAction(this.path, "default", "T").withStreamExecutionEnvironment(env).build();
            env.executeAsync();
            --i;
        }
        Thread.sleep(random.nextInt(2500));
        this.checkChangelogTestResult(numProducers);
    }

    private void checkChangelogTestResult(int numProducers) throws Exception {
        TableEnvironment sEnv = this.createStreamingTableEnvironment(100);
        sEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)1);
        sEnv.executeSql(this.createCatalogSql("testCatalog", this.path));
        sEnv.executeSql("USE CATALOG testCatalog");
        ResultChecker checker = new ResultChecker();
        int endCnt = 0;
        try (CloseableIterator it = sEnv.executeSql("SELECT * FROM T").collect();){
            while (it.hasNext()) {
                Row row = (Row)it.next();
                checker.addChangelog(row);
                if ((Long)row.getField(2) < 10000L || ++endCnt != numProducers * 4 * 64) continue;
                break;
            }
        }
        checker.assertResult(numProducers);
        this.checkBatchResult(numProducers);
    }

    private List<TableResult> testRandom(TableEnvironment tEnv, int numProducers, boolean enableFailure, String tableProperties) throws Exception {
        String failingName = UUID.randomUUID().toString();
        String failingPath = FailingFileIO.getFailingPath((String)failingName, (String)this.path);
        FailingFileIO.reset((String)failingName, (int)0, (int)1);
        tEnv.executeSql(this.createCatalogSql("testCatalog", failingPath));
        tEnv.executeSql("USE CATALOG testCatalog");
        tEnv.executeSql("CREATE TABLE T(  pt STRING,  k INT,  v1 BIGINT,  v2 STRING,  PRIMARY KEY (pt, k) NOT ENFORCED) PARTITIONED BY (pt) WITH (" + tableProperties + ")");
        tEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)1);
        tEnv.executeSql("CREATE TABLE `default_catalog`.`default_database`.`S` (  i INT) WITH (  'connector' = 'datagen',  'fields.i.kind' = 'sequence',  'fields.i.start' = '0',  'fields.i.end' = '10255',  'number-of-rows' = '10256',  'rows-per-second' = '" + (500 + ThreadLocalRandom.current().nextInt(500)) + "')").await();
        ArrayList<TableResult> results = new ArrayList<TableResult>();
        if (enableFailure) {
            FailingFileIO.reset((String)failingName, (int)2, (int)10000);
        }
        int i = 0;
        while (i < numProducers) {
            String ptSql = String.format("IF(i >= %d, CAST((i - %d) / %d AS STRING), CAST(CAST(FLOOR(RAND() * %d) AS INT) AS STRING)) AS pt", 10000, 10000, 64, 4);
            String kSql = String.format("IF(i >= %d, MOD(i - %d, %d), CAST(FLOOR(RAND() * %d) AS INT)) + %d AS k", 10000, 10000, 64, 64, i * 64);
            String v1Sql = String.format("IF(i >= %d, i, CAST(FLOOR(RAND() * %d) AS BIGINT)) AS v1", 10000, 1024);
            String v2Sql = "CAST(i AS STRING) || '.str' AS v2";
            tEnv.executeSql(String.format("CREATE TEMPORARY VIEW myView%d AS SELECT %s, %s, %s, %s FROM `default_catalog`.`default_database`.`S`", i, ptSql, kSql, v1Sql, v2Sql));
            int idx = i++;
            TableResult result = (TableResult)FailingFileIO.retryArtificialException(() -> tEnv.executeSql("INSERT INTO T /*+ OPTIONS('sink.parallelism' = '2') */ SELECT * FROM myView" + idx));
            results.add(result);
        }
        return results;
    }

    private void checkBatchResult(int numProducers) throws Exception {
        TableEnvironment bEnv = this.createBatchTableEnvironment();
        bEnv.executeSql(this.createCatalogSql("testCatalog", this.path));
        bEnv.executeSql("USE CATALOG testCatalog");
        ResultChecker checker = new ResultChecker();
        try (CloseableIterator it = bEnv.executeSql("SELECT * FROM T").collect();){
            while (it.hasNext()) {
                checker.addChangelog((Row)it.next());
            }
        }
        checker.assertResult(numProducers);
    }

    private static class ResultChecker {
        private final Map<String, String> valueMap = new HashMap<String, String>();
        private final Map<String, RowKind> kindMap = new HashMap<String, RowKind>();

        private ResultChecker() {
        }

        private void addChangelog(Row row) {
            String key = row.getField(0) + "|" + row.getField(1);
            String value = row.getField(2) + "|" + row.getField(3);
            switch (row.getKind()) {
                case INSERT: {
                    Assertions.assertThat((boolean)this.valueMap.containsKey(key)).isFalse();
                    Assertions.assertThat((!this.kindMap.containsKey(key) || this.kindMap.get(key) == RowKind.DELETE ? 1 : 0) != 0).isTrue();
                    this.valueMap.put(key, value);
                    break;
                }
                case UPDATE_AFTER: {
                    Assertions.assertThat((boolean)this.valueMap.containsKey(key)).isFalse();
                    Assertions.assertThat((Comparable)((Comparable)this.kindMap.get(key))).isEqualTo((Object)RowKind.UPDATE_BEFORE);
                    this.valueMap.put(key, value);
                    break;
                }
                case UPDATE_BEFORE: 
                case DELETE: {
                    Assertions.assertThat((String)this.valueMap.get(key)).isEqualTo(value);
                    Assertions.assertThat((this.kindMap.get(key) == RowKind.INSERT || this.kindMap.get(key) == RowKind.UPDATE_AFTER ? 1 : 0) != 0).isTrue();
                    this.valueMap.remove(key);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown row kind " + row.getKind());
                }
            }
            this.kindMap.put(key, row.getKind());
        }

        private void assertResult(int numProducers) {
            Assertions.assertThat((int)this.valueMap.size()).isEqualTo(256 * numProducers);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 64 * numProducers; ++j) {
                    String key = i + "|" + j;
                    int x = 10000 + i * 64 + j % 64;
                    String expectedValue = x + "|" + x + ".str";
                    Assertions.assertThat((String)this.valueMap.get(key)).isEqualTo(expectedValue);
                }
            }
        }
    }
}

