/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.types.Row;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.testutils.assertj.AssertionUtils;
import org.apache.paimon.utils.DateTimeUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class SchemaChangeITCase
extends CatalogITCaseBase {
    @Test
    public void testAddColumn() {
        this.sql("CREATE TABLE T (a STRING, b DOUBLE, c FLOAT)", new Object[0]);
        this.sql("INSERT INTO T VALUES('aaa', 1.2, 3.4)", new Object[0]);
        this.sql("ALTER TABLE T ADD d INT", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647),\n  `b` DOUBLE,\n  `c` FLOAT,\n  `d` INT\n)"});
        this.sql("INSERT INTO T VALUES('bbb', 4.5, 5.6, 5)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, 1.2, 3.4, null], +I[bbb, 4.5, 5.6, 5]]");
        this.sql("ALTER TABLE T ADD e INT AFTER b", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647),\n  `b` DOUBLE,\n  `e` INT,\n  `c` FLOAT,\n  `d` INT"});
        this.sql("INSERT INTO T VALUES('ccc', 2.3, 6, 5.6, 5)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, 1.2, null, 3.4, null], +I[bbb, 4.5, null, 5.6, 5], +I[ccc, 2.3, 6, 5.6, 5]]");
        this.sql("ALTER TABLE T ADD f STRING FIRST", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `f` VARCHAR(2147483647),\n  `a` VARCHAR(2147483647),\n  `b` DOUBLE,\n  `e` INT,\n  `c` FLOAT,\n  `d` INT"});
        this.sql("INSERT INTO T VALUES('flink', 'fff', 45.34, 4, 2.45, 12)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[null, aaa, 1.2, null, 3.4, null], +I[null, bbb, 4.5, null, 5.6, 5], +I[null, ccc, 2.3, 6, 5.6, 5], +I[flink, fff, 45.34, 4, 2.45, 12]]");
        this.sql("ALTER TABLE T ADD ( g INT, h BOOLEAN ) ", new Object[0]);
        this.sql("INSERT INTO T VALUES('ggg', 'hhh', 23.43, 6, 2.34, 34, 23, true)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[null, aaa, 1.2, null, 3.4, null, null, null], +I[null, bbb, 4.5, null, 5.6, 5, null, null], +I[null, ccc, 2.3, 6, 5.6, 5, null, null], +I[flink, fff, 45.34, 4, 2.45, 12, null, null], +I[ggg, hhh, 23.43, 6, 2.34, 34, 23, true]]");
    }

    @Test
    public void testDropColumn() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING, d INT, e FLOAT)", new Object[0]);
        this.sql("INSERT INTO T VALUES('aaa', 'bbb', 'ccc', 10, 3.4)", new Object[0]);
        this.sql("ALTER TABLE T DROP e", new Object[0]);
        this.sql("INSERT INTO T VALUES('ddd', 'eee', 'fff', 20)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647),\n  `d` INT,"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, bbb, ccc, 10], +I[ddd, eee, fff, 20]]");
        this.sql("ALTER TABLE T DROP (c, d)", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),"});
        this.sql("INSERT INTO T VALUES('ggg', 'hhh')", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, bbb], +I[ddd, eee], +I[ggg, hhh]]");
    }

    @Test
    public void testRenameColumn() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING)", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', 'bbb', 'ccc')", new Object[0]);
        this.sql("ALTER TABLE T RENAME c TO c1", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c1` VARCHAR(2147483647)"});
        result = this.sql("SELECT a, b, c1 FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[paimon, bbb, ccc]]");
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T RENAME d TO d1", new Object[0])).hasMessageContaining("The column `d` does not exist in the base table.");
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T RENAME a TO b", new Object[0])).hasMessageContaining("The column `b` already existed in table schema.");
    }

    @Test
    public void testDropPrimaryKey() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING)", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T DROP a", new Object[0])).hasMessageContaining("Failed to execute ALTER TABLE statement.\nThe column `a` is used as the primary key.");
    }

    @Test
    public void testDropPartitionKey() {
        this.sql("CREATE TABLE MyTable (\n    user_id BIGINT,\n    item_id BIGINT,\n    behavior STRING,\n    dt STRING,\n    hh STRING,\n    PRIMARY KEY (dt, hh, user_id) NOT ENFORCED\n) PARTITIONED BY (dt, hh)", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE MyTable DROP dt", new Object[0])).hasMessageContaining("Failed to execute ALTER TABLE statement.\nThe column `dt` is used as the partition keys.");
    }

    @Test
    public void testModifyColumnTypeFromNumericToNumericPrimitive() {
        this.sql("CREATE TABLE T (a TINYINT COMMENT 'a field', b INT COMMENT 'b field', c FLOAT COMMENT 'c field', d DOUBLE, e DECIMAL(10, 4), f DECIMAL(10, 4), g DOUBLE)", new Object[0]);
        this.sql("INSERT INTO T VALUES(cast(1 as TINYINT), 123, 1.23, 3.141592, 3.14156, 3.14159, 1.23)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a INT, b SMALLINT, c DOUBLE, d FLOAT, e BIGINT, f DOUBLE, g TINYINT)", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, INT, true, null, null, null, a field]", "+I[b, SMALLINT, true, null, null, null, b field]", "+I[c, DOUBLE, true, null, null, null, c field]", "+I[d, FLOAT, true, null, null, null, null]", "+I[e, BIGINT, true, null, null, null, null]", "+I[f, DOUBLE, true, null, null, null, null]", "+I[g, TINYINT, true, null, null, null, null]"});
        this.sql("INSERT INTO T VALUES(2, cast(456 as SMALLINT), 4.56, 3.14, 456, 4.56, cast(2 as TINYINT))", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[1, 123, 1.2300000190734863, 3.141592, 3, 3.1416, 1]", "+I[2, 456, 4.56, 3.14, 456, 4.56, 2]"});
    }

    @Test
    public void testModifyColumnTypeFromNumericToDecimal() {
        this.sql("CREATE TABLE T (a DECIMAL(10, 4), b DECIMAL(10, 2), c INT, d FLOAT)", new Object[0]);
        this.sql("INSERT INTO T VALUES(1.23456, 1.23, 123, 3.14156)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a DECIMAL(10, 2), b DECIMAL(10, 4), c DECIMAL(10, 4), d DECIMAL(10, 4))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` DECIMAL(10, 2),\n  `b` DECIMAL(10, 4),\n  `c` DECIMAL(10, 4),\n  `d` DECIMAL(10, 4)"});
        this.sql("INSERT INTO T VALUES(1.2, 1.2345, 456, 4.13)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[1.20, 1.2345, 456.0000, 4.1300]", "+I[1.23, 1.2300, 123.0000, 3.1416]"});
    }

    @Test
    public void testModifyColumnTypeBooleanAndNumeric() {
        this.sql("CREATE TABLE T (a BOOLEAN, b BOOLEAN, c TINYINT, d INT, e BIGINT, f DOUBLE)", new Object[0]);
        this.sql("INSERT INTO T VALUES(true, false, cast(0 as TINYINT), 1 , 123, 3.14)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a TINYINT, b INT, c BOOLEAN, d BOOLEAN, e BOOLEAN)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` TINYINT,\n  `b` INT,\n  `c` BOOLEAN,\n  `d` BOOLEAN,\n  `e` BOOLEAN,"});
        this.sql("INSERT INTO T VALUES(cast(1 as TINYINT), 123, true, true, false, 4.13)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[1, 123, true, true, false, 4.13]", "+I[1, 0, false, true, true, 3.14]"});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY (f BOOLEAN)", new Object[0])).hasRootCauseInstanceOf(IllegalStateException.class).hasRootCauseMessage("Column type f[DOUBLE] cannot be converted to BOOLEAN without loosing information.");
    }

    @Test
    public void testModifyColumnTypeFromNumericToString() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b INT, c DECIMAL(10, 3), d FLOAT, e DOUBLE)", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', 123, 300.123, 400.123, 400.1234)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (b STRING, c VARCHAR(6), d CHAR(3), e CHAR(10))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(6),\n  `d` CHAR(3),\n  `e` CHAR(10),"});
        this.sql("INSERT INTO T VALUES('apache', '345', '200', '0.12', '1000.12345')", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[apache, 345, 200, 0.1, 1000.12345]", "+I[paimon, 123, 300.12, 400, 400.1234  ]"});
    }

    @Test
    public void testModifyColumnTypeFromBooleanToString() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b BOOLEAN, c BOOLEAN)", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', true, false)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (b CHAR(4), c VARCHAR(6))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` CHAR(4),\n  `c` VARCHAR(6),"});
        this.sql("INSERT INTO T VALUES('apache', '345', '200')", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[apache, 345, 200]", "+I[paimon, true, false]"});
    }

    @Test
    public void testModifyColumnTypeFromTimestampToString() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b TIMESTAMP(3), c TIMESTAMP(6), d DATE, f TIME, g TIMESTAMP(3) WITH LOCAL TIME ZONE)", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', TIMESTAMP '2023-06-06 12:00:00', TIMESTAMP '2023-06-06 08:00:00.123456', DATE '2023-05-31', TIME '14:30:00', TO_TIMESTAMP_LTZ(4001, 3))", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (b STRING, c STRING, d STRING, f STRING, g STRING)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647),\n  `d` VARCHAR(2147483647),\n  `f` VARCHAR(2147483647),\n  `g` VARCHAR(2147483647),"});
        this.sql("INSERT INTO T VALUES('apache', '2023-06-07 12:00:00', '2023-06-07 08:00:00.123456', '2023-06-07', '08:00:00', '2023-06-07 00:00:00.123456')", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[apache, 2023-06-07 12:00:00, 2023-06-07 08:00:00.123456, 2023-06-07, 08:00:00, 2023-06-07 00:00:00.123456]", "+I[paimon, 2023-06-06 12:00:00.000, 2023-06-06 08:00:00.123456, 2023-05-31, 14:30:00, " + BinaryString.fromString((String)DateTimeUtils.formatTimestamp((Timestamp)DateTimeUtils.parseTimestampData((String)"1970-01-01 00:00:04.001", (int)3), (TimeZone)DateTimeUtils.LOCAL_TZ, (int)3)) + "]"});
    }

    @Test
    public void testModifyColumnTypeFromStringToString() {
        this.sql("CREATE TABLE T (b VARCHAR(10), c VARCHAR(10), d CHAR(5), e CHAR(5))", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', '1234567890', '12345', '12345')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (b VARCHAR(5), c CHAR(5), d VARCHAR(5), e CHAR(6))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `b` VARCHAR(5),\n  `c` CHAR(5),\n  `d` VARCHAR(5),\n  `e` CHAR(6)"});
        this.sql("INSERT INTO T VALUES('apache', '1234567890', '123456', '1234567')", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[apach, 12345, 12345, 123456]", "+I[paimo, 12345, 12345, 12345 ]"});
    }

    @Test
    public void testModifyColumnTypeFromStringToBoolean() {
        this.sql("CREATE TABLE T (b VARCHAR(10), c VARCHAR(10), d STRING, e CHAR(1))", new Object[0]);
        this.sql("INSERT INTO T VALUES('true', '1', 'yes', 'y')", new Object[0]);
        this.sql("INSERT INTO T VALUES('false', '0', 'no', 'n')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (b BOOLEAN, c BOOLEAN, d BOOLEAN, e BOOLEAN)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `b` BOOLEAN,\n  `c` BOOLEAN,\n  `d` BOOLEAN,\n  `e` BOOLEAN"});
        this.sql("INSERT INTO T VALUES(false, true, false, true)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[true, true, true, true]", "+I[false, false, false, false]", "+I[false, true, false, true]"});
    }

    @Test
    public void testModifyColumnTypeFromStringToNumeric() {
        this.sql("CREATE TABLE T (a VARCHAR(10), b CHAR(1), c VARCHAR(10), d STRING, e STRING)", new Object[0]);
        this.sql("INSERT INTO T VALUES('3.14', '1', '123', '3.14', '3.14')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a DECIMAL(5, 4), b TINYINT, c INT, d DOUBLE, e BIGINT)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` DECIMAL(5, 4),\n  `b` TINYINT,\n  `c` INT,\n  `d` DOUBLE,\n  `e` BIGINT"});
        this.sql("INSERT INTO T VALUES(4.13, cast(2 as TINYINT), 456, 3.14, 4)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[3.1400, 1, 123, 3.14, 3]", "+I[4.1300, 2, 456, 3.14, 4]"});
        this.sql("CREATE TABLE T1 (a STRING, b STRING)", new Object[0]);
        this.sql("INSERT INTO T1 VALUES('test', '3.14')", new Object[0]);
        this.sql("ALTER TABLE T1 MODIFY (a INT, b TINYINT)", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM T1", new Object[0])).hasRootCauseInstanceOf(NumberFormatException.class).hasRootCauseMessage("For input string: 'test'. Invalid character found.");
    }

    @Test
    public void testModifyColumnTypeFromStringToTimestamp() {
        this.sql("CREATE TABLE T (a VARCHAR(30), b CHAR(20), c VARCHAR(20), d STRING, e STRING)", new Object[0]);
        this.sql("INSERT INTO T VALUES('2022-12-12 09:30:10', '2022-12-12', '09:30:00', '2022-12-12 09:30:00.123456', '2022-12-12 00:30:00.123456')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a TIMESTAMP, b DATE, c TIME, d TIMESTAMP(3), e TIMESTAMP(3) WITH LOCAL TIME ZONE)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` TIMESTAMP(6),\n  `b` DATE,\n  `c` TIME(0),\n  `d` TIMESTAMP(3),\n  `e` TIMESTAMP(3) WITH LOCAL TIME ZONE"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[2022-12-12T09:30:10, 2022-12-12, 09:30, 2022-12-12T09:30:00.123, " + DateTimeUtils.timestampToTimestampWithLocalZone((Timestamp)DateTimeUtils.parseTimestampData((String)"2022-12-12 00:30:00.123456", (int)3), (TimeZone)DateTimeUtils.LOCAL_TZ).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "Z]"});
    }

    @Test
    public void testModifyColumnTypeStringToBinary() {
        this.sql("CREATE TABLE T (a VARCHAR(5), b VARCHAR(10), c VARCHAR(10), d VARCHAR(10))", new Object[0]);
        this.sql("INSERT INTO T VALUES('Apache Paimon', 'Apache Paimon','Apache Paimon','Apache Paimon')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a BINARY(10), b BINARY(5), c VARBINARY(5), d VARBINARY(20))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` BINARY(10),\n  `b` BINARY(5),\n  `c` VARBINARY(5),\n  `d` VARBINARY(20)"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[[65, 112, 97, 99, 104, 0, 0, 0, 0, 0], [65, 112, 97, 99, 104], [65, 112, 97, 99, 104], [65, 112, 97, 99, 104, 101, 32, 80, 97, 105]]"});
    }

    @Test
    public void testModifyColumnTypeFromTimestampToTimestamp() {
        this.sql("CREATE TABLE T (a TIMESTAMP(6), b TIMESTAMP(6), c TIMESTAMP(6) WITH LOCAL TIME ZONE, d TIMESTAMP(6) WITH LOCAL TIME ZONE)", new Object[0]);
        this.sql("INSERT INTO T VALUES(TIMESTAMP '2022-12-01 09:00:00.123456', TIMESTAMP '2022-12-02 09:00:00.123456', TO_TIMESTAMP_LTZ(4001, 3), TO_TIMESTAMP_LTZ(4001, 3))", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a TIMESTAMP(3), b TIMESTAMP(6) WITH LOCAL TIME ZONE, c TIMESTAMP(3) WITH LOCAL TIME ZONE, d TIMESTAMP(3))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` TIMESTAMP(3),\n  `b` TIMESTAMP(6) WITH LOCAL TIME ZONE,\n  `c` TIMESTAMP(3) WITH LOCAL TIME ZONE,\n  `d` TIMESTAMP(3)"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[2022-12-01T09:00:00.123, " + DateTimeUtils.timestampToTimestampWithLocalZone((Timestamp)DateTimeUtils.parseTimestampData((String)"2022-12-02 09:00:00.123456", (int)6), (TimeZone)DateTimeUtils.LOCAL_TZ).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "Z, 1970-01-01T00:00:04.001Z, " + DateTimeUtils.timestampWithLocalZoneToTimestamp((Timestamp)DateTimeUtils.parseTimestampData((String)"1970-01-01 00:00:04.001", (int)3), (TimeZone)DateTimeUtils.LOCAL_TZ).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "]"});
    }

    @Test
    public void testModifyColumnTypeFromDateToTimestamp() {
        this.sql("CREATE TABLE T (a DATE, b DATE)", new Object[0]);
        this.sql("INSERT INTO T VALUES(DATE '2022-12-12', DATE '2022-12-11')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a TIMESTAMP(6), b TIMESTAMP(6) WITH LOCAL TIME ZONE)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` TIMESTAMP(6),\n  `b` TIMESTAMP(6) WITH LOCAL TIME ZONE"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[2022-12-12T00:00, " + DateTimeUtils.timestampToTimestampWithLocalZone((Timestamp)DateTimeUtils.parseTimestampData((String)"2022-12-11", (int)6), (TimeZone)DateTimeUtils.LOCAL_TZ).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "Z]"});
    }

    @Test
    public void testModifyColumnTypeFromTimeToTimestamp() {
        this.sql("CREATE TABLE T (a TIME, b TIME(2), c TIME(3))", new Object[0]);
        this.sql("INSERT INTO T VALUES(TIME '09:30:10', TIME '09:30:10.24', TIME '09:30:10.123')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a TIMESTAMP(3), b TIMESTAMP(6), c TIMESTAMP(6) WITH LOCAL TIME ZONE)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` TIMESTAMP(3),\n  `b` TIMESTAMP(6),\n  `c` TIMESTAMP(6) WITH LOCAL TIME ZONE"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[1970-01-01T09:30:10, 1970-01-01T09:30:10.240, 1970-01-01T09:30:10.123Z]"});
    }

    @Test
    public void testModifyColumnTypeBinaryToBinary() {
        this.sql("CREATE TABLE T (a BINARY(5), b BINARY(10), c BINARY(10), d BINARY(10), e VARBINARY(5), f VARBINARY(10), g VARBINARY(10), h VARBINARY(10))", new Object[0]);
        this.sql("INSERT INTO T VALUES(X'0123456789', X'0123456789',X'0123456789',X'0123456789',X'0123456789',X'0123456789',X'0123456789',X'0123456789')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a BINARY(10), b BINARY(5), c VARBINARY(5), d VARBINARY(20), e VARBINARY(10), f VARBINARY(5), g BINARY(5), h BINARY(20))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` BINARY(10),\n  `b` BINARY(5),\n  `c` VARBINARY(5),\n  `d` VARBINARY(20),\n  `e` VARBINARY(10),\n  `f` VARBINARY(5),\n  `g` BINARY(5),\n  `h` BINARY(20)"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[[1, 35, 69, 103, -119, 0, 0, 0, 0, 0], [1, 35, 69, 103, -119], [1, 35, 69, 103, -119], [1, 35, 69, 103, -119, 0, 0, 0, 0, 0], [1, 35, 69, 103, -119], [1, 35, 69, 103, -119], [1, 35, 69, 103, -119], [1, 35, 69, 103, -119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]]"});
    }

    @Test
    public void testModifyColumnPosition() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING, d INT, e DOUBLE)", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', 'bbb', 'ccc', 1, 3.4)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY b STRING FIRST", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `b` VARCHAR(2147483647),\n  `a` VARCHAR(2147483647) NOT NULL,\n  `c` VARCHAR(2147483647),\n  `d` INT,\n  `e` DOUBLE,"});
        this.sql("INSERT INTO T VALUES('aaa', 'flink', 'ddd', 2, 5.7)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, flink, ddd, 2, 5.7], +I[bbb, paimon, ccc, 1, 3.4]]");
        this.sql("ALTER TABLE T MODIFY e DOUBLE AFTER c", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `b` VARCHAR(2147483647),\n  `a` VARCHAR(2147483647) NOT NULL,\n  `c` VARCHAR(2147483647),\n  `e` DOUBLE,\n  `d` INT,"});
        this.sql("INSERT INTO T VALUES('sss', 'ggg', 'eee', 4.7, 10)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, flink, ddd, 5.7, 2], +I[sss, ggg, eee, 4.7, 10], +I[bbb, paimon, ccc, 3.4, 1]]");
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY b STRING FIRST", new Object[0])).satisfies(new ThrowingConsumer[]{AssertionUtils.anyCauseMatches(UnsupportedOperationException.class, (String)"Cannot move itself for column b")});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY b STRING AFTER b", new Object[0])).satisfies(new ThrowingConsumer[]{AssertionUtils.anyCauseMatches(UnsupportedOperationException.class, (String)"Cannot move itself for column b")});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY h STRING FIRST", new Object[0])).hasMessageContaining("Try to modify a column `h` which does not exist in the table");
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY h STRING AFTER d", new Object[0])).hasMessageContaining("Try to modify a column `h` which does not exist in the table");
    }

    @Test
    public void testModifyNullability() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING, d INT, e FLOAT NOT NULL)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647),\n  `d` INT,\n  `e` FLOAT NOT NULL,"});
        Assertions.assertThatThrownBy(() -> this.sql("INSERT INTO T VALUES('aaa', 'bbb', 'ccc', 1, CAST(NULL AS FLOAT))", new Object[0])).satisfies(new ThrowingConsumer[]{AssertionUtils.anyCauseMatches(TableException.class, (String)"Column 'e' is NOT NULL, however, a null value is being written into it.")});
        this.sql("ALTER TABLE T MODIFY e FLOAT", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647),\n  `d` INT,\n  `e` FLOAT"});
        this.sql("ALTER TABLE T MODIFY c STRING NOT NULL", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647) NOT NULL,\n  `d` INT,\n  `e` FLOAT"});
        Assertions.assertThatThrownBy(() -> this.sql("INSERT INTO T VALUES('aaa', 'bbb', CAST(NULL AS STRING), 1, CAST(NULL AS FLOAT))", new Object[0])).satisfies(new ThrowingConsumer[]{AssertionUtils.anyCauseMatches(TableException.class, (String)"Column 'c' is NOT NULL, however, a null value is being written into it.")});
        this.sql("INSERT INTO T VALUES('aaa', 'bbb', 'ccc', 1, CAST(NULL AS FLOAT))", new Object[0]);
        result = this.sql("select * from T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, bbb, ccc, 1, null]]");
        this.tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_NOT_NULL_ENFORCER, (Object)ExecutionConfigOptions.NotNullEnforcer.DROP);
        this.sql("ALTER TABLE T MODIFY e FLOAT NOT NULL;\n", new Object[0]);
        this.sql("INSERT INTO T VALUES('aa2', 'bb2', 'cc2', 2, 2.5)", new Object[0]);
        result = this.sql("select * from T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aa2, bb2, cc2, 2, 2.5]]");
    }

    @Test
    public void testModifyColumnComment() {
        this.sql("CREATE TABLE T (a STRING, b STRING COMMENT 'from column b')", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]"});
        this.sql("ALTER TABLE T MODIFY a STRING COMMENT 'from column a'", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, from column a]", "+I[b, STRING, true, null, null, null, from column b]"});
        this.sql("ALTER TABLE T MODIFY b STRING COMMENT 'from column b updated'", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, from column a]", "+I[b, STRING, true, null, null, null, from column b updated]"});
    }

    @Test
    public void testAddWatermark() {
        this.sql("CREATE TABLE T (a STRING, ts TIMESTAMP(3))", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null]", "+I[ts, TIMESTAMP(3), true, null, null, null]"});
        this.sql("ALTER TABLE T ADD WATERMARK FOR ts AS ts - INTERVAL '1' HOUR", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null]", "+I[ts, TIMESTAMP(3), true, null, null, `ts` - INTERVAL '1' HOUR]"});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T ADD WATERMARK FOR ts AS ts - INTERVAL '2' HOUR", new Object[0])).hasMessageContaining("The base table has already defined the watermark strategy");
    }

    @Test
    public void testDropWatermark() {
        this.sql("CREATE TABLE T (a STRING, ts TIMESTAMP(3), WATERMARK FOR ts AS ts - INTERVAL '1' HOUR)", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null]", "+I[ts, TIMESTAMP(3), true, null, null, `ts` - INTERVAL '1' HOUR]"});
        this.sql("ALTER TABLE T DROP WATERMARK", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null]", "+I[ts, TIMESTAMP(3), true, null, null, null]"});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T DROP WATERMARK", new Object[0])).hasMessageContaining("The base table does not define any watermark strategy");
    }

    @Test
    public void testModifyWatermark() {
        this.sql("CREATE TABLE T (a STRING, ts TIMESTAMP(3))", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY WATERMARK FOR ts AS ts - INTERVAL '1' HOUR", new Object[0])).hasMessageContaining("The base table does not define any watermark");
        this.sql("ALTER TABLE T ADD WATERMARK FOR ts AS ts - INTERVAL '1' HOUR", new Object[0]);
        this.sql("ALTER TABLE T MODIFY WATERMARK FOR ts AS ts - INTERVAL '2' HOUR", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null]", "+I[ts, TIMESTAMP(3), true, null, null, `ts` - INTERVAL '2' HOUR]"});
    }

    @Test
    public void testSetAndRemoveOption() throws Exception {
        this.sql("CREATE TABLE T (a STRING, b STRING, c STRING)", new Object[0]);
        this.sql("ALTER TABLE T SET ('xyc'='unknown1', 'abc'='unknown2')", new Object[0]);
        Map options = this.table("T").getOptions();
        Assertions.assertThat((Map)options).containsEntry((Object)"xyc", (Object)"unknown1");
        Assertions.assertThat((Map)options).containsEntry((Object)"abc", (Object)"unknown2");
        this.sql("ALTER TABLE T RESET ('xyc', 'abc')", new Object[0]);
        options = this.table("T").getOptions();
        Assertions.assertThat((Map)options).doesNotContainKey((Object)"xyc");
        Assertions.assertThat((Map)options).doesNotContainKey((Object)"abc");
    }

    @Test
    public void testSetAndResetImmutableOptions() throws Exception {
        this.sql("CREATE TABLE T1 (a STRING, b STRING, c STRING)", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T1 SET ('bucket-key' = 'c')", new Object[0])).getRootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessage("Change 'bucket-key' is not supported yet.");
        this.sql("CREATE TABLE T2 (a STRING, b STRING, c STRING) WITH ('bucket-key' = 'c')", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T2 RESET ('bucket-key')", new Object[0])).getRootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessage("Change 'bucket-key' is not supported yet.");
        this.sql("CREATE TABLE T4 (a STRING, b STRING, c STRING) WITH ('merge-engine' = 'partial-update')", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T4 RESET ('merge-engine')", new Object[0])).getRootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessage("Change 'merge-engine' is not supported yet.");
        this.sql("CREATE TABLE T5 (a STRING, b STRING, c STRING) WITH ('sequence.field' = 'b')", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T5 SET ('sequence.field' = 'c')", new Object[0])).getRootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessage("Change 'sequence.field' is not supported yet.");
    }

    @Test
    public void testAlterTableSchema() {
        this.sql("CREATE TABLE T (a STRING, b STRING COMMENT 'from column b')", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]"});
        this.sql("ALTER TABLE T ADD (c INT AFTER b)", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, INT, true, null, null, null, null]"});
        this.sql("ALTER TABLE T ADD (d INT FIRST)", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[d, INT, true, null, null, null, null]", "+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, INT, true, null, null, null, null]"});
        this.sql("ALTER TABLE T DROP d", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, INT, true, null, null, null, null]"});
        this.sql("ALTER TABLE T MODIFY (c BIGINT)", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, BIGINT, true, null, null, null, null]"});
        this.sql("ALTER TABLE T MODIFY (c INT)", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, INT, true, null, null, null, null]"});
        this.sql("ALTER TABLE T MODIFY (c STRING)", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, STRING, true, null, null, null, null]"});
    }
}

