/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SchemaChangeSerializationTest {
    @Test
    public void testSerialization() throws Exception {
        this.runTest(SchemaChange.setOption((String)"key", (String)"value"));
        this.runTest(SchemaChange.removeOption((String)"key"));
        this.runTest(SchemaChange.addColumn((String)"col", (DataType)DataTypes.INT(), (String)"comment", (SchemaChange.Move)SchemaChange.Move.first((String)"col")));
        this.runTest(SchemaChange.renameColumn((String)"col", (String)"new_col"));
        this.runTest(SchemaChange.dropColumn((String)"col"));
        this.runTest(SchemaChange.updateColumnType((String)"col", (DataType)DataTypes.INT()));
        this.runTest(SchemaChange.updateColumnNullability((String[])new String[]{"col1", "col2"}, (boolean)true));
        this.runTest(SchemaChange.updateColumnComment((String[])new String[]{"col1", "col2"}, (String)"comment"));
        this.runTest(SchemaChange.updateColumnPosition((SchemaChange.Move)SchemaChange.Move.after((String)"col", (String)"ref")));
    }

    private void runTest(SchemaChange schemaChange) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(schemaChange);
        oos.close();
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object actual = ois.readObject();
        Assertions.assertThat((Object)actual).isEqualTo((Object)schemaChange);
    }
}

