/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.time.LocalDateTime;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.utils.BlockingIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class WatermarkITCase
extends CatalogITCaseBase {
    @Override
    protected int defaultParallelism() {
        return 1;
    }

    @Test
    public void testWatermark() throws Exception {
        this.innerTestWatermark(new String[0]);
    }

    @Disabled
    @Test
    public void testWatermarkAlignment() throws Exception {
        this.innerTestWatermark("'scan.watermark.idle-timeout'='1s'", "'scan.watermark.alignment.group'='group'", "'scan.watermark.alignment.update-interval'='2s'", "'scan.watermark.alignment.max-drift'='1s'");
    }

    private void innerTestWatermark(String ... options) throws Exception {
        this.sql("CREATE TABLE T (f0 INT, ts TIMESTAMP(3), WATERMARK FOR ts AS ts) WITH (" + String.join((CharSequence)",", options) + ")", new Object[0]);
        BlockingIterator select = BlockingIterator.of(this.streamSqlIter("SELECT window_start, window_end, SUM(f0) FROM TABLE(TUMBLE(TABLE T, DESCRIPTOR(ts), INTERVAL '10' MINUTES))\n  GROUP BY window_start, window_end;", new Object[0]));
        this.sql("INSERT INTO T VALUES (1, TIMESTAMP '2023-02-02 12:00:00')", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, TIMESTAMP '2023-02-02 12:10:01')", new Object[0]);
        Assertions.assertThat((List)select.collect(1)).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{LocalDateTime.parse("2023-02-02T12:00"), LocalDateTime.parse("2023-02-02T12:10"), 1})});
        select.close();
    }
}

