/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.SortCompactAction;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.PrimaryKeyFileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.DynamicBucketRow;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SortCompactActionForDynamicBucketITCase
extends ActionITCaseBase {
    private static final Random RANDOM = new Random();

    @Test
    public void testDynamicBucketSort() throws Exception {
        this.createTable();
        this.commit(this.writeData(100));
        PredicateBuilder predicateBuilder = new PredicateBuilder(this.getTable().rowType());
        Predicate predicate = predicateBuilder.between(1, (Object)100L, (Object)200L);
        List files = ((FileStoreTable)this.getTable()).store().newScan().plan().files();
        List filesFilter = ((PrimaryKeyFileStoreTable)this.getTable()).store().newScan().withValueFilter(predicate).plan().files();
        this.zorder(Arrays.asList("f2", "f1"));
        List filesZorder = ((FileStoreTable)this.getTable()).store().newScan().plan().files();
        List filesFilterZorder = ((PrimaryKeyFileStoreTable)this.getTable()).store().newScan().withValueFilter(predicate).plan().files();
        Assertions.assertThat((double)((double)filesFilterZorder.size() / (double)filesZorder.size())).isLessThan((double)filesFilter.size() / (double)files.size());
    }

    @Test
    public void testDynamicBucketSortWithOrderAndZorder() throws Exception {
        this.createTable();
        this.commit(this.writeData(100));
        PredicateBuilder predicateBuilder = new PredicateBuilder(this.getTable().rowType());
        Predicate predicate = predicateBuilder.between(1, (Object)100L, (Object)200L);
        this.order(Arrays.asList("f2", "f1"));
        List files = ((FileStoreTable)this.getTable()).store().newScan().plan().files();
        List filesFilter = ((PrimaryKeyFileStoreTable)this.getTable()).store().newScan().withValueFilter(predicate).plan().files();
        this.zorder(Arrays.asList("f2", "f1"));
        List filesZorder = ((FileStoreTable)this.getTable()).store().newScan().plan().files();
        List filesFilterZorder = ((PrimaryKeyFileStoreTable)this.getTable()).store().newScan().withValueFilter(predicate).plan().files();
        Assertions.assertThat((double)((double)filesFilterZorder.size() / (double)filesZorder.size())).isLessThan((double)filesFilter.size() / (double)files.size());
    }

    @Test
    public void testDynamicBucketSortWithStringType() throws Exception {
        this.createTable();
        this.commit(this.writeData(100));
        PredicateBuilder predicateBuilder = new PredicateBuilder(this.getTable().rowType());
        Predicate predicate = predicateBuilder.between(4, (Object)BinaryString.fromString((String)"000000000100"), (Object)BinaryString.fromString((String)"000000000200"));
        List files = ((FileStoreTable)this.getTable()).store().newScan().plan().files();
        List filesFilter = ((PrimaryKeyFileStoreTable)this.getTable()).store().newScan().withValueFilter(predicate).plan().files();
        this.zorder(Arrays.asList("f4"));
        List filesZorder = ((FileStoreTable)this.getTable()).store().newScan().plan().files();
        List filesFilterZorder = ((PrimaryKeyFileStoreTable)this.getTable()).store().newScan().withValueFilter(predicate).plan().files();
        Assertions.assertThat((double)((double)filesFilterZorder.size() / (double)filesZorder.size())).isLessThan((double)filesFilter.size() / (double)files.size());
    }

    private void zorder(List<String> columns) throws Exception {
        if (RANDOM.nextBoolean()) {
            this.createAction("zorder", columns).run();
        } else {
            this.callProcedure("zorder", columns);
        }
    }

    private void order(List<String> columns) throws Exception {
        if (RANDOM.nextBoolean()) {
            this.createAction("order", columns).run();
        } else {
            this.callProcedure("order", columns);
        }
    }

    private SortCompactAction createAction(String orderStrategy, List<String> columns) {
        return this.createAction(SortCompactAction.class, "compact", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--order_strategy", orderStrategy, "--order_by", String.join((CharSequence)",", columns));
    }

    private void callProcedure(String orderStrategy, List<String> orderByColumns) {
        this.callProcedure(String.format("CALL sys.compact('%s.%s', 'ALL', '%s', '%s')", this.database, this.tableName, orderStrategy, String.join((CharSequence)",", orderByColumns)), false, true);
    }

    private static Schema schema() {
        Schema.Builder schemaBuilder = Schema.newBuilder();
        schemaBuilder.column("f0", (DataType)DataTypes.BIGINT());
        schemaBuilder.column("f1", (DataType)DataTypes.BIGINT());
        schemaBuilder.column("f2", (DataType)DataTypes.BIGINT());
        schemaBuilder.column("f3", (DataType)DataTypes.BIGINT());
        schemaBuilder.column("f4", (DataType)DataTypes.STRING());
        schemaBuilder.option("bucket", "-1");
        schemaBuilder.option("scan.parallelism", "6");
        schemaBuilder.option("sink.parallelism", "3");
        schemaBuilder.option("dynamic-bucket.target-row-num", "100");
        schemaBuilder.option(CoreOptions.ZORDER_VAR_LENGTH_CONTRIBUTION.key(), "14");
        schemaBuilder.primaryKey(new String[]{"f0"});
        return schemaBuilder.build();
    }

    private List<CommitMessage> writeData(int size) throws Exception {
        List messages;
        Table table = this.getTable();
        BatchWriteBuilder builder = table.newBatchWriteBuilder();
        try (BatchTableWrite batchTableWrite = builder.newWrite();){
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < 100; ++j) {
                    batchTableWrite.write(SortCompactActionForDynamicBucketITCase.data(i));
                }
            }
            messages = batchTableWrite.prepareCommit();
        }
        return messages;
    }

    private void commit(List<CommitMessage> messages) throws Exception {
        BatchTableCommit commit = this.getTable().newBatchWriteBuilder().newCommit();
        commit.commit(messages);
        commit.close();
    }

    private void createTable() throws Exception {
        this.catalog.createDatabase(this.database, true);
        this.catalog.createTable(this.identifier(), SortCompactActionForDynamicBucketITCase.schema(), true);
    }

    private Table getTable() throws Exception {
        return this.catalog.getTable(this.identifier());
    }

    private Identifier identifier() {
        return Identifier.create((String)this.database, (String)this.tableName);
    }

    private static InternalRow data(int bucket) {
        String in = String.valueOf(Math.abs(RANDOM.nextInt(10000)));
        int count = 4 - in.length();
        for (int i = 0; i < count; ++i) {
            in = "0" + in;
        }
        assert (in.length() == 4);
        GenericRow row = GenericRow.of((Object[])new Object[]{RANDOM.nextLong(), (long)RANDOM.nextInt(10000), (long)RANDOM.nextInt(10000), (long)RANDOM.nextInt(10000), BinaryString.fromString((String)("00000000" + in))});
        return new DynamicBucketRow((InternalRow)row, bucket);
    }
}

