/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.types.Row;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.CreateTagAction;
import org.apache.paimon.flink.action.DeleteTagAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.TagManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TagActionITCase
extends ActionITCaseBase {
    @Test
    public void testCreateAndDeleteTag() throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        TagManager tagManager = new TagManager(table.fileIO(), table.location());
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.createAction(CreateTagAction.class, "create_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag_name", "tag2", "--snapshot", "2").run();
        } else {
            this.callProcedure(String.format("CALL sys.create_tag('%s.%s', 'tag2', 2)", this.database, this.tableName));
        }
        Assertions.assertThat((boolean)tagManager.tagExists("tag2")).isTrue();
        ReadWriteTableTestUtil.testBatchRead("SELECT * FROM `" + this.tableName + "` /*+ OPTIONS('scan.tag-name'='tag2') */", Arrays.asList(Row.of((Object[])new Object[]{1L, "Hi"}), Row.of((Object[])new Object[]{2L, "Hello"})));
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.createAction(DeleteTagAction.class, "delete_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag_name", "tag2").run();
        } else {
            this.callProcedure(String.format("CALL sys.delete_tag('%s.%s', 'tag2')", this.database, this.tableName));
        }
        Assertions.assertThat((boolean)tagManager.tagExists("tag2")).isFalse();
    }
}

