/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.lookup.LookupTable;
import org.apache.paimon.lookup.RocksDBStateFactory;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class LookupTableTest {
    @TempDir
    Path tempDir;
    private RocksDBStateFactory stateFactory;
    private RowType rowType;

    @BeforeEach
    public void before() throws IOException {
        this.stateFactory = new RocksDBStateFactory(this.tempDir.toString(), new Options(), null);
        this.rowType = RowType.of((DataType[])new DataType[]{new IntType(), new IntType(), new IntType()});
    }

    @AfterEach
    public void after() throws IOException {
        if (this.stateFactory != null) {
            this.stateFactory.close();
        }
    }

    @Test
    public void testPkTable() throws IOException {
        LookupTable table = LookupTable.create((RocksDBStateFactory)this.stateFactory, (RowType)this.rowType, Collections.singletonList("f0"), Collections.singletonList("f0"), r -> r.getInt(0) < 3, (long)(ThreadLocalRandom.current().nextInt(2) * 10));
        table.refresh(Collections.singletonList(LookupTableTest.row(1, 11, 111)).iterator());
        List result = table.get(LookupTableTest.row(1));
        Assertions.assertThat((List)result).hasSize(1);
        LookupTableTest.assertRow((InternalRow)result.get(0), 1, 11, 111);
        table.refresh(Collections.singletonList(LookupTableTest.row(1, 22, 222)).iterator());
        result = table.get(LookupTableTest.row(1));
        Assertions.assertThat((List)result).hasSize(1);
        LookupTableTest.assertRow((InternalRow)result.get(0), 1, 22, 222);
        table.refresh(Collections.singletonList(LookupTableTest.row(RowKind.DELETE, new Object[]{1, 11, 111})).iterator());
        Assertions.assertThat((List)table.get(LookupTableTest.row(1))).hasSize(0);
        table.refresh(Collections.singletonList(LookupTableTest.row(3, 33, 333)).iterator());
        Assertions.assertThat((List)table.get(LookupTableTest.row(3))).hasSize(0);
    }

    @Test
    public void testPkTableFilter() throws IOException {
        LookupTable table = LookupTable.create((RocksDBStateFactory)this.stateFactory, (RowType)this.rowType, Collections.singletonList("f0"), Collections.singletonList("f0"), r -> r.getInt(1) < 22, (long)(ThreadLocalRandom.current().nextInt(2) * 10));
        table.refresh(Collections.singletonList(LookupTableTest.row(1, 11, 111)).iterator());
        List result = table.get(LookupTableTest.row(1));
        Assertions.assertThat((List)result).hasSize(1);
        LookupTableTest.assertRow((InternalRow)result.get(0), 1, 11, 111);
        table.refresh(Collections.singletonList(LookupTableTest.row(1, 22, 222)).iterator());
        result = table.get(LookupTableTest.row(1));
        Assertions.assertThat((List)result).hasSize(0);
    }

    @Test
    public void testSecKeyTable() throws IOException {
        LookupTable table = LookupTable.create((RocksDBStateFactory)this.stateFactory, (RowType)this.rowType, Collections.singletonList("f0"), Collections.singletonList("f1"), r -> r.getInt(0) < 3, (long)(ThreadLocalRandom.current().nextInt(2) * 10));
        table.refresh(Collections.singletonList(LookupTableTest.row(1, 11, 111)).iterator());
        List result = table.get(LookupTableTest.row(11));
        Assertions.assertThat((List)result).hasSize(1);
        LookupTableTest.assertRow((InternalRow)result.get(0), 1, 11, 111);
        table.refresh(Collections.singletonList(LookupTableTest.row(1, 22, 222)).iterator());
        Assertions.assertThat((List)table.get(LookupTableTest.row(11))).hasSize(0);
        result = table.get(LookupTableTest.row(22));
        Assertions.assertThat((List)result).hasSize(1);
        LookupTableTest.assertRow((InternalRow)result.get(0), 1, 22, 222);
        table.refresh(Collections.singletonList(LookupTableTest.row(2, 22, 222)).iterator());
        result = table.get(LookupTableTest.row(22));
        Assertions.assertThat((List)result).hasSize(2);
        LookupTableTest.assertRow((InternalRow)result.get(0), 1, 22, 222);
        LookupTableTest.assertRow((InternalRow)result.get(1), 2, 22, 222);
        table.refresh(Collections.singletonList(LookupTableTest.row(RowKind.DELETE, new Object[]{2, 22, 222})).iterator());
        result = table.get(LookupTableTest.row(22));
        Assertions.assertThat((List)result).hasSize(1);
        LookupTableTest.assertRow((InternalRow)result.get(0), 1, 22, 222);
        table.refresh(Collections.singletonList(LookupTableTest.row(3, 33, 333)).iterator());
        Assertions.assertThat((List)table.get(LookupTableTest.row(33))).hasSize(0);
    }

    @Test
    public void testNoPrimaryKeyTable() throws IOException {
        LookupTable table = LookupTable.create((RocksDBStateFactory)this.stateFactory, (RowType)this.rowType, Collections.emptyList(), Collections.singletonList("f1"), r -> r.getInt(2) < 222, (long)(ThreadLocalRandom.current().nextInt(2) * 10));
        table.refresh(Collections.singletonList(LookupTableTest.row(1, 11, 333)).iterator());
        List result = table.get(LookupTableTest.row(11));
        Assertions.assertThat((List)result).hasSize(0);
        table.refresh(Collections.singletonList(LookupTableTest.row(1, 11, 111)).iterator());
        result = table.get(LookupTableTest.row(11));
        Assertions.assertThat((List)result).hasSize(1);
        LookupTableTest.assertRow((InternalRow)result.get(0), 1, 11, 111);
        table.refresh(Collections.singletonList(LookupTableTest.row(1, 11, 111)).iterator());
        result = table.get(LookupTableTest.row(11));
        Assertions.assertThat((List)result).hasSize(2);
        LookupTableTest.assertRow((InternalRow)result.get(0), 1, 11, 111);
        LookupTableTest.assertRow((InternalRow)result.get(1), 1, 11, 111);
    }

    private static InternalRow row(Object ... values) {
        return LookupTableTest.row(RowKind.INSERT, values);
    }

    private static InternalRow row(RowKind kind, Object ... values) {
        GenericRow row = new GenericRow(kind, values.length);
        for (int i = 0; i < values.length; ++i) {
            row.setField(i, values[i]);
        }
        return row;
    }

    private static void assertRow(InternalRow resultRow, int ... expected) {
        int[] results = new int[expected.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = resultRow.getInt(i);
        }
        Assertions.assertThat((int[])results).containsExactly(expected);
    }
}

