/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.CommittableSerializer;
import org.apache.paimon.flink.sink.LogOffsetCommittable;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.NewFilesIncrement;
import org.apache.paimon.manifest.ManifestCommittableSerializerTest;
import org.apache.paimon.mergetree.compact.MergeTreeCompactManagerTest;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommittableSerializerTest {
    private final CommitMessageSerializer fileSerializer = new CommitMessageSerializer();
    private final CommittableSerializer serializer = new CommittableSerializer(this.fileSerializer);

    @Test
    public void testFile() throws IOException {
        NewFilesIncrement newFilesIncrement = ManifestCommittableSerializerTest.randomNewFilesIncrement();
        CompactIncrement compactIncrement = ManifestCommittableSerializerTest.randomCompactIncrement();
        CommitMessageImpl committable = new CommitMessageImpl(MergeTreeCompactManagerTest.row((int)0), 1, newFilesIncrement, compactIncrement);
        CommitMessage newCommittable = (CommitMessage)this.serializer.deserialize(2, this.serializer.serialize(new Committable(9L, Committable.Kind.FILE, (Object)committable))).wrappedCommittable();
        Assertions.assertThat((Object)newCommittable).isEqualTo((Object)committable);
    }

    @Test
    public void testLogOffset() throws IOException {
        LogOffsetCommittable committable = new LogOffsetCommittable(2, 3L);
        LogOffsetCommittable newCommittable = (LogOffsetCommittable)this.serializer.deserialize(2, this.serializer.serialize(new Committable(8L, Committable.Kind.LOG_OFFSET, (Object)committable))).wrappedCommittable();
        Assertions.assertThat((Object)newCommittable).isEqualTo((Object)committable);
    }
}

