/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.MultiTableCommittable;
import org.apache.paimon.flink.sink.MultiTableCommittableSerializer;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.NewFilesIncrement;
import org.apache.paimon.manifest.ManifestCommittableSerializerTest;
import org.apache.paimon.mergetree.compact.MergeTreeCompactManagerTest;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MultiTableCommittableSerializerTest {
    private final CommitMessageSerializer fileSerializer = new CommitMessageSerializer();
    private final MultiTableCommittableSerializer serializer = new MultiTableCommittableSerializer(this.fileSerializer);

    MultiTableCommittableSerializerTest() {
    }

    @Test
    public void testFileMetadata() throws IOException {
        NewFilesIncrement newFilesIncrement = ManifestCommittableSerializerTest.randomNewFilesIncrement();
        CompactIncrement compactIncrement = ManifestCommittableSerializerTest.randomCompactIncrement();
        CommitMessageImpl commitMessage = new CommitMessageImpl(MergeTreeCompactManagerTest.row((int)0), 1, newFilesIncrement, compactIncrement);
        Committable committable = new Committable(9L, Committable.Kind.FILE, (Object)commitMessage);
        String database = "database";
        String table = "table";
        MultiTableCommittable multiTableCommittable = MultiTableCommittable.fromCommittable((Identifier)Identifier.create((String)database, (String)table), (Committable)committable);
        MultiTableCommittable deserializeCommittable = this.serializer.deserialize(2, this.serializer.serialize(multiTableCommittable));
        Assertions.assertThat((Object)deserializeCommittable).isInstanceOf(MultiTableCommittable.class);
        Assertions.assertThat((String)deserializeCommittable.getDatabase()).isEqualTo(database);
        Assertions.assertThat((String)deserializeCommittable.getTable()).isEqualTo(table);
    }
}

