/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.Collections;
import java.util.Optional;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.PaimonDataStreamScanProvider;
import org.apache.paimon.flink.source.DataTableSource;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class DataTableSourceTest {
    DataTableSourceTest() {
    }

    @Test
    void testInferScanParallelism(@TempDir java.nio.file.Path path) throws Exception {
        LocalFileIO fileIO = LocalFileIO.create();
        Path tablePath = new Path(path.toString());
        SchemaManager schemaManager = new SchemaManager((FileIO)fileIO, tablePath);
        TableSchema tableSchema = schemaManager.createTable(Schema.newBuilder().column("a", (DataType)DataTypes.INT()).column("b", (DataType)DataTypes.BIGINT()).build());
        FileStoreTable fileStoreTable = FileStoreTableFactory.create((FileIO)fileIO, (Path)tablePath, (TableSchema)tableSchema);
        TableWriteImpl writer = fileStoreTable.newWrite("test");
        TableCommitImpl commit = fileStoreTable.newCommit("test");
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{1, 2L}));
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{3, 4L}));
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{5, 6L}));
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{7, 8L}));
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{9, 10L}));
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{11, 12L}));
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{13, 14L}));
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{15, 16L}));
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{17, 18L}));
        commit.commit(writer.prepareCommit());
        commit.close();
        writer.close();
        DataTableSource tableSource = new DataTableSource(ObjectIdentifier.of((String)"cat", (String)"db", (String)"table"), (Table)fileStoreTable, true, null, null);
        PaimonDataStreamScanProvider runtimeProvider = (PaimonDataStreamScanProvider)tableSource.getScanRuntimeProvider(new ScanTableSource.ScanContext(){

            public <T> TypeInformation<T> createTypeInformation(org.apache.flink.table.types.DataType dataType) {
                throw new UnsupportedOperationException();
            }

            public <T> TypeInformation<T> createTypeInformation(LogicalType logicalType) {
                throw new UnsupportedOperationException();
            }

            public DynamicTableSource.DataStructureConverter createDataStructureConverter(org.apache.flink.table.types.DataType dataType) {
                throw new UnsupportedOperationException();
            }
        });
        LocalStreamEnvironment sEnv1 = StreamExecutionEnvironment.createLocalEnvironment();
        DataStream sourceStream1 = runtimeProvider.produceDataStream(s -> Optional.empty(), (StreamExecutionEnvironment)sEnv1);
        AssertionsForClassTypes.assertThat((int)sourceStream1.getParallelism()).isEqualTo(1);
        LocalStreamEnvironment sEnv2 = StreamExecutionEnvironment.createLocalEnvironment((Configuration)Configuration.fromMap(Collections.singletonMap(String.format("%s%s", "paimon.", FlinkConnectorOptions.INFER_SCAN_PARALLELISM.key()), "false")));
        DataStream sourceStream2 = runtimeProvider.produceDataStream(s -> Optional.empty(), (StreamExecutionEnvironment)sEnv2);
        AssertionsForClassTypes.assertThat((int)sourceStream2.getParallelism()).isNotEqualTo(1);
        AssertionsForClassTypes.assertThat((int)sourceStream2.getParallelism()).isEqualTo(sEnv2.getParallelism());
    }
}

