/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FileStoreSourceSplitSerializer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFileTestUtils;
import org.apache.paimon.stats.StatsTestUtils;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileStoreSourceSplitSerializerTest {
    @Test
    public void serializeSplit() throws Exception {
        FileStoreSourceSplit split = FileStoreSourceSplitSerializerTest.newSourceSplit("id", DataFileTestUtils.row((int)1), 2, Arrays.asList(FileStoreSourceSplitSerializerTest.newFile(0), FileStoreSourceSplitSerializerTest.newFile(1)));
        FileStoreSourceSplit deSerialized = FileStoreSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileStoreSourceSplitSerializerTest.assertSplitsEqual(split, deSerialized);
    }

    @Test
    public void serializeSplitWithReaderPosition() throws Exception {
        FileStoreSourceSplit split = FileStoreSourceSplitSerializerTest.newSourceSplit("id", DataFileTestUtils.row((int)1), 2, Arrays.asList(FileStoreSourceSplitSerializerTest.newFile(0), FileStoreSourceSplitSerializerTest.newFile(1)), 29L);
        FileStoreSourceSplit deSerialized = FileStoreSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileStoreSourceSplitSerializerTest.assertSplitsEqual(split, deSerialized);
    }

    @Test
    public void repeatedSerialization() throws Exception {
        FileStoreSourceSplit split = FileStoreSourceSplitSerializerTest.newSourceSplit("id", DataFileTestUtils.row((int)1), 2, Arrays.asList(FileStoreSourceSplitSerializerTest.newFile(0), FileStoreSourceSplitSerializerTest.newFile(1)), 29L);
        FileStoreSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileStoreSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileStoreSourceSplit deSerialized = FileStoreSourceSplitSerializerTest.serializeAndDeserialize(split);
        FileStoreSourceSplitSerializerTest.assertSplitsEqual(split, deSerialized);
    }

    public static DataFileMeta newFile(int level) {
        return new DataFileMeta("", 0L, 1L, DataFileTestUtils.row((int)0), DataFileTestUtils.row((int)0), StatsTestUtils.newEmptyTableStats(), StatsTestUtils.newEmptyTableStats(), 0L, 1L, 0L, level);
    }

    public static FileStoreSourceSplit newSourceSplit(String id, BinaryRow partition, int bucket, List<DataFileMeta> files) {
        return FileStoreSourceSplitSerializerTest.newSourceSplit(id, partition, bucket, files, false, 0L);
    }

    public static FileStoreSourceSplit newSourceSplit(String id, BinaryRow partition, int bucket, List<DataFileMeta> files, boolean isIncremental) {
        return FileStoreSourceSplitSerializerTest.newSourceSplit(id, partition, bucket, files, isIncremental, 0L);
    }

    public static FileStoreSourceSplit newSourceSplit(String id, BinaryRow partition, int bucket, List<DataFileMeta> files, long recordsToSkip) {
        return FileStoreSourceSplitSerializerTest.newSourceSplit(id, partition, bucket, files, false, recordsToSkip);
    }

    public static FileStoreSourceSplit newSourceSplit(String id, BinaryRow partition, int bucket, List<DataFileMeta> files, boolean isIncremental, long recordsToSkip) {
        DataSplit split = DataSplit.builder().withSnapshot(1L).withPartition(partition).withBucket(bucket).withDataFiles(files).isStreaming(isIncremental).build();
        return new FileStoreSourceSplit(id, (Split)split, recordsToSkip);
    }

    private static FileStoreSourceSplit serializeAndDeserialize(FileStoreSourceSplit split) throws IOException {
        FileStoreSourceSplitSerializer serializer = new FileStoreSourceSplitSerializer();
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)serializer, (Object)split);
        return (FileStoreSourceSplit)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)serializer, (byte[])bytes);
    }

    static void assertSplitsEqual(FileStoreSourceSplit expected, FileStoreSourceSplit actual) {
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }
}

