/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FileStoreSourceSplitSerializer;
import org.apache.paimon.flink.source.FileStoreSourceSplitSerializerTest;
import org.apache.paimon.flink.source.PendingSplitsCheckpoint;
import org.apache.paimon.flink.source.PendingSplitsCheckpointSerializer;
import org.apache.paimon.mergetree.compact.MergeTreeCompactManagerTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PendingSplitsCheckpointSerializerTest {
    @Test
    public void serializeEmptyCheckpoint() throws Exception {
        PendingSplitsCheckpoint checkpoint = new PendingSplitsCheckpoint(Collections.emptyList(), Long.valueOf(5L));
        PendingSplitsCheckpoint deSerialized = PendingSplitsCheckpointSerializerTest.serializeAndDeserialize(checkpoint);
        PendingSplitsCheckpointSerializerTest.assertCheckpointsEqual(checkpoint, deSerialized);
    }

    @Test
    public void serializeSomeSplits() throws Exception {
        PendingSplitsCheckpoint checkpoint = new PendingSplitsCheckpoint(Arrays.asList(PendingSplitsCheckpointSerializerTest.testSplit1(), PendingSplitsCheckpointSerializerTest.testSplit2(), PendingSplitsCheckpointSerializerTest.testSplit3()), Long.valueOf(3L));
        PendingSplitsCheckpoint deSerialized = PendingSplitsCheckpointSerializerTest.serializeAndDeserialize(checkpoint);
        PendingSplitsCheckpointSerializerTest.assertCheckpointsEqual(checkpoint, deSerialized);
    }

    @Test
    public void serializeSplitsAndContinuous() throws Exception {
        PendingSplitsCheckpoint checkpoint = new PendingSplitsCheckpoint(Arrays.asList(PendingSplitsCheckpointSerializerTest.testSplit1(), PendingSplitsCheckpointSerializerTest.testSplit2(), PendingSplitsCheckpointSerializerTest.testSplit3()), Long.valueOf(20L));
        PendingSplitsCheckpoint deSerialized = PendingSplitsCheckpointSerializerTest.serializeAndDeserialize(checkpoint);
        PendingSplitsCheckpointSerializerTest.assertCheckpointsEqual(checkpoint, deSerialized);
    }

    @Test
    public void repeatedSerialization() throws Exception {
        PendingSplitsCheckpoint checkpoint = new PendingSplitsCheckpoint(Arrays.asList(PendingSplitsCheckpointSerializerTest.testSplit3(), PendingSplitsCheckpointSerializerTest.testSplit1()), Long.valueOf(5L));
        PendingSplitsCheckpointSerializerTest.serializeAndDeserialize(checkpoint);
        PendingSplitsCheckpointSerializerTest.serializeAndDeserialize(checkpoint);
        PendingSplitsCheckpoint deSerialized = PendingSplitsCheckpointSerializerTest.serializeAndDeserialize(checkpoint);
        PendingSplitsCheckpointSerializerTest.assertCheckpointsEqual(checkpoint, deSerialized);
    }

    private static FileStoreSourceSplit testSplit1() {
        return FileStoreSourceSplitSerializerTest.newSourceSplit("id1", MergeTreeCompactManagerTest.row((int)1), 2, Arrays.asList(FileStoreSourceSplitSerializerTest.newFile(0), FileStoreSourceSplitSerializerTest.newFile(1)));
    }

    private static FileStoreSourceSplit testSplit2() {
        return FileStoreSourceSplitSerializerTest.newSourceSplit("id2", MergeTreeCompactManagerTest.row((int)2), 3, Arrays.asList(FileStoreSourceSplitSerializerTest.newFile(2), FileStoreSourceSplitSerializerTest.newFile(3)));
    }

    private static FileStoreSourceSplit testSplit3() {
        return FileStoreSourceSplitSerializerTest.newSourceSplit("id3", MergeTreeCompactManagerTest.row((int)3), 4, Arrays.asList(FileStoreSourceSplitSerializerTest.newFile(5), FileStoreSourceSplitSerializerTest.newFile(6)));
    }

    private static PendingSplitsCheckpoint serializeAndDeserialize(PendingSplitsCheckpoint split) throws IOException {
        PendingSplitsCheckpointSerializer serializer = new PendingSplitsCheckpointSerializer(new FileStoreSourceSplitSerializer());
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)serializer, (Object)split);
        return (PendingSplitsCheckpoint)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)serializer, (byte[])bytes);
    }

    private static void assertCheckpointsEqual(PendingSplitsCheckpoint expected, PendingSplitsCheckpoint actual) {
        Assertions.assertThat((Collection)actual.splits()).isEqualTo((Object)expected.splits());
        Assertions.assertThat((Long)actual.currentSnapshotId()).isEqualTo((Object)expected.currentSnapshotId());
    }
}

