/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.memory.HeapMemorySegmentPool;
import org.apache.paimon.memory.MemoryOwner;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.mergetree.compact.DeduplicateMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.operation.KeyValueFileStoreRead;
import org.apache.paimon.operation.KeyValueFileStoreWrite;
import org.apache.paimon.options.Options;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.ValueContentRowDataRecordIterator;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.RecordWriter;
import org.apache.paimon.utils.SnapshotManager;

public class TestChangelogDataReadWrite {
    private static final RowType KEY_TYPE = new RowType(Collections.singletonList(new DataField(0, "k", (DataType)new BigIntType())));
    private static final RowType VALUE_TYPE = new RowType(Collections.singletonList(new DataField(0, "v", (DataType)new BigIntType())));
    private static final Comparator<InternalRow> COMPARATOR = Comparator.comparingLong(o -> o.getLong(0));
    private static final RecordEqualiser EQUALISER = (RecordEqualiser & Serializable)(row1, row2) -> row1.getLong(0) == row2.getLong(0);
    private static final KeyValueFieldsExtractor EXTRACTOR = new KeyValueFieldsExtractor(){

        public List<DataField> keyFields(TableSchema schema) {
            return Collections.singletonList(new DataField(0, "k", (DataType)new BigIntType(false)));
        }

        public List<DataField> valueFields(TableSchema schema) {
            return Collections.singletonList(new DataField(0, "v", (DataType)new BigIntType(false)));
        }
    };
    private final FileFormat avro = FileFormat.fromIdentifier((String)"avro", (Options)new Options());
    private final Path tablePath;
    private final FileStorePathFactory pathFactory;
    private final SnapshotManager snapshotManager;
    private final String commitUser;

    public TestChangelogDataReadWrite(String root) {
        this.tablePath = new Path(root);
        this.pathFactory = new FileStorePathFactory(this.tablePath, RowType.of((DataType[])new DataType[]{new IntType()}), "default", ((CoreOptions.FileFormatType)CoreOptions.FILE_FORMAT.defaultValue()).toString());
        this.snapshotManager = new SnapshotManager((FileIO)LocalFileIO.create(), new Path(root));
        this.commitUser = UUID.randomUUID().toString();
    }

    public TableRead createReadWithKey() {
        return this.createRead(ValueContentRowDataRecordIterator::new);
    }

    private TableRead createRead(final Function<RecordReader.RecordIterator<KeyValue>, RecordReader.RecordIterator<InternalRow>> rowDataIteratorCreator) {
        KeyValueFileStoreRead read = new KeyValueFileStoreRead((FileIO)LocalFileIO.create(), new SchemaManager((FileIO)LocalFileIO.create(), this.tablePath), 0L, KEY_TYPE, VALUE_TYPE, COMPARATOR, DeduplicateMergeFunction.factory(), ignore -> this.avro, this.pathFactory, EXTRACTOR, new CoreOptions(new HashMap()));
        return new KeyValueTableRead(read, null){

            public void projection(int[][] projection) {
                throw new UnsupportedOperationException();
            }

            protected RecordReader.RecordIterator<InternalRow> rowDataRecordIteratorFromKv(RecordReader.RecordIterator<KeyValue> kvRecordIterator) {
                return (RecordReader.RecordIterator)rowDataIteratorCreator.apply(kvRecordIterator);
            }
        };
    }

    public List<DataFileMeta> writeFiles(BinaryRow partition, int bucket, List<Tuple2<Long, Long>> kvs) throws Exception {
        RecordWriter<KeyValue> writer = this.createMergeTreeWriter(partition, bucket);
        for (Tuple2<Long, Long> tuple2 : kvs) {
            writer.write((Object)new KeyValue().replace((InternalRow)GenericRow.of((Object[])new Object[]{tuple2.f0}), RowKind.INSERT, (InternalRow)GenericRow.of((Object[])new Object[]{tuple2.f1})));
        }
        List files = writer.prepareCommit(true).newFilesIncrement().newFiles();
        writer.close();
        return new ArrayList<DataFileMeta>(files);
    }

    public RecordWriter<KeyValue> createMergeTreeWriter(BinaryRow partition, int bucket) {
        CoreOptions options = new CoreOptions(Collections.singletonMap(CoreOptions.FILE_FORMAT.key(), "avro"));
        HashMap<String, FileStorePathFactory> pathFactoryMap = new HashMap<String, FileStorePathFactory>();
        pathFactoryMap.put("avro", this.pathFactory);
        RecordWriter writer = new KeyValueFileStoreWrite((FileIO)LocalFileIO.create(), (SchemaManager)new SchemaManager((FileIO)LocalFileIO.create(), (Path)this.tablePath), (long)0L, (String)this.commitUser, (RowType)TestChangelogDataReadWrite.KEY_TYPE, (RowType)TestChangelogDataReadWrite.VALUE_TYPE, (Supplier<Comparator>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$createMergeTreeWriter$2(), ()Ljava/util/Comparator;)(), (Supplier<RecordEqualiser>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$createMergeTreeWriter$3(), ()Lorg/apache/paimon/codegen/RecordEqualiser;)(), (MergeFunctionFactory)DeduplicateMergeFunction.factory(), (FileStorePathFactory)this.pathFactory, pathFactoryMap, (SnapshotManager)this.snapshotManager, null, null, (CoreOptions)options, (KeyValueFieldsExtractor)TestChangelogDataReadWrite.EXTRACTOR, (String)this.tablePath.getName()).createWriterContainer((BinaryRow)partition, (int)bucket, (boolean)true).writer;
        ((MemoryOwner)writer).setMemoryPool((MemorySegmentPool)new HeapMemorySegmentPool(options.writeBufferSize(), options.pageSize()));
        return writer;
    }

    private static /* synthetic */ RecordEqualiser lambda$createMergeTreeWriter$3() {
        return EQUALISER;
    }

    private static /* synthetic */ Comparator lambda$createMergeTreeWriter$2() {
        return COMPARATOR;
    }
}

