/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.align;

import java.util.Arrays;
import java.util.Optional;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.connector.testutils.source.reader.TestingReaderContext;
import org.apache.flink.connector.testutils.source.reader.TestingReaderOutput;
import org.apache.paimon.flink.source.FileStoreSourceReader;
import org.apache.paimon.flink.source.FileStoreSourceReaderTest;
import org.apache.paimon.flink.source.TestChangelogDataReadWrite;
import org.apache.paimon.flink.source.align.AlignedSourceReader;
import org.apache.paimon.flink.source.align.CheckpointEvent;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.jupiter.api.Test;

public class AlignedSourceReaderTest
extends FileStoreSourceReaderTest {
    @Override
    @Test
    public void testAddMultipleSplits() throws Exception {
        TestingReaderContext context = new TestingReaderContext();
        AlignedSourceReader reader = (AlignedSourceReader)this.createReader(context);
        reader.start();
        Assertions.assertThat((int)context.getNumSplitRequests()).isEqualTo(1);
        reader.addSplits(Arrays.asList(AlignedSourceReaderTest.createTestFileSplit("id1"), AlignedSourceReaderTest.createTestFileSplit("id2")));
        TestingReaderOutput output = new TestingReaderOutput();
        while (reader.getNumberOfCurrentlyAssignedSplits() > 0) {
            reader.pollNext((ReaderOutput)output);
            Thread.sleep(10L);
        }
        Assertions.assertThat((int)context.getNumSplitRequests()).isEqualTo(1);
        reader.handleSourceEvents((SourceEvent)new CheckpointEvent(1L));
        Assertions.assertThat((Optional)reader.shouldTriggerCheckpoint()).isEqualTo(Optional.of(1L));
        Assertions.assertThat((int)context.getNumSplitRequests()).isEqualTo(2);
    }

    @Override
    @Ignore
    public void testReaderOnSplitFinished() throws Exception {
    }

    @Override
    protected FileStoreSourceReader createReader(TestingReaderContext context) {
        return new AlignedSourceReader((SourceReaderContext)context, new TestChangelogDataReadWrite(this.tempDir.toString()).createReadWithKey(), null, null, new FutureCompletingBlockingQueue(2), null);
    }
}

