/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.statistics;

import java.util.Arrays;
import java.util.UUID;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.source.DataTableSource;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.VarCharType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class FileStoreTableStatisticsTestBase {
    protected final ObjectIdentifier identifier = ObjectIdentifier.of((String)"c", (String)"d", (String)"t");
    @TempDir
    java.nio.file.Path tempDir;
    protected Path tablePath;
    protected String commitUser;

    @BeforeEach
    public void before() {
        this.tablePath = new Path(this.tempDir.toString() + "/" + UUID.randomUUID());
        this.commitUser = UUID.randomUUID().toString();
    }

    @Test
    public void testTableScanStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        DataTableSource scanSource = new DataTableSource(this.identifier, (Table)table, false, null, null);
        Assertions.assertThat((long)scanSource.reportStatistics().getRowCount()).isEqualTo(9L);
    }

    @Test
    public void testTableStreamingStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        DataTableSource streamSource = new DataTableSource(this.identifier, (Table)table, true, null, null);
        Assertions.assertThat((Object)streamSource.reportStatistics()).isEqualTo((Object)TableStats.UNKNOWN);
    }

    @Test
    public void testTableFilterPartitionStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        PredicateBuilder builder = new PredicateBuilder(table.schema().logicalRowType());
        DataTableSource partitionFilterSource = new DataTableSource(this.identifier, (Table)table, false, null, null, builder.equal(0, (Object)1), (int[][])null, null, null, null);
        Assertions.assertThat((long)partitionFilterSource.reportStatistics().getRowCount()).isEqualTo(5L);
    }

    @Test
    public void testTableFilterKeyStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        PredicateBuilder builder = new PredicateBuilder(table.schema().logicalRowType());
        DataTableSource keyFilterSource = new DataTableSource(this.identifier, (Table)table, false, null, null, builder.equal(1, (Object)50), (int[][])null, null, null, null);
        Assertions.assertThat((long)keyFilterSource.reportStatistics().getRowCount()).isEqualTo(2L);
    }

    @Test
    public void testTableFilterValueStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        PredicateBuilder builder = new PredicateBuilder(table.schema().logicalRowType());
        DataTableSource keyFilterSource = new DataTableSource(this.identifier, (Table)table, false, null, null, builder.greaterThan(2, (Object)500L), (int[][])null, null, null, null);
        Assertions.assertThat((long)keyFilterSource.reportStatistics().getRowCount()).isEqualTo(4L);
    }

    protected FileStoreTable writeData() throws Exception {
        FileStoreTable table = this.createStoreTable();
        TableWriteImpl write = table.newWrite(this.commitUser);
        TableCommitImpl commit = table.newCommit(this.commitUser);
        write.write(this.rowData(1, 10, 100L, "S1"));
        write.write(this.rowData(1, 20, 200L, null));
        write.write(this.rowData(2, 30, 300L, "S3"));
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.write(this.rowData(1, 40, 400L, "S4"));
        write.write(this.rowData(2, 50, null, "S5"));
        write.write(this.rowData(2, 60, 600L, "S6"));
        commit.commit(1L, write.prepareCommit(true, 1L));
        write.write(this.rowData(1, 70, 700L, "S7"));
        write.write(this.rowData(2, 80, null, "S8"));
        write.write(this.rowData(1, 90, 900L, null));
        commit.commit(2L, write.prepareCommit(true, 2L));
        write.close();
        commit.close();
        return table;
    }

    abstract FileStoreTable createStoreTable() throws Exception;

    protected InternalRow rowData(Object ... values) {
        return GenericRow.of((Object[])Arrays.stream(values).map(v -> {
            if (v instanceof String) {
                return BinaryString.fromString((String)((String)v));
            }
            return v;
        }).toArray());
    }

    protected Schema.Builder schemaBuilder() {
        return Schema.newBuilder().column("pt", (DataType)new IntType()).column("a", (DataType)new IntType()).column("b", (DataType)new BigIntType(true)).column("c", (DataType)new VarCharType(100));
    }
}

