/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.UUID;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.paimon.flink.util.MiniClusterWithClientExtension;
import org.apache.paimon.utils.FileIOUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

public class AbstractTestBase {
    private static final int DEFAULT_PARALLELISM = 8;
    @RegisterExtension
    protected static final MiniClusterWithClientExtension MINI_CLUSTER_EXTENSION = new MiniClusterWithClientExtension(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(8).build());
    @TempDir
    protected static Path temporaryFolder;

    @AfterEach
    public final void cleanupRunningJobs() throws Exception {
        RestClusterClient<MiniClusterClient.MiniClusterId> clusterClient = MINI_CLUSTER_EXTENSION.createRestClusterClient();
        for (JobStatusMessage path : (Collection)clusterClient.listJobs().get()) {
            if (path.getJobState().isTerminalState()) continue;
            try {
                clusterClient.cancel(path.getJobId()).get();
            }
            catch (Exception exception) {}
        }
    }

    protected String getTempDirPath() {
        return this.getTempDirPath("");
    }

    protected String getTempDirPath(String dirName) {
        return this.createAndRegisterTempFile(dirName).toString();
    }

    protected String getTempFilePath(String fileName) {
        return this.createAndRegisterTempFile(fileName).toString();
    }

    protected String createTempFile(String fileName, String contents) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        f.createNewFile();
        FileIOUtils.writeFileUtf8((File)f, (String)contents);
        return f.toString();
    }

    protected File createAndRegisterTempFile(String fileName) {
        return new File(temporaryFolder.toFile(), String.format("%s/%s", UUID.randomUUID(), fileName));
    }
}

