/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryMap;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinarySection;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.BinaryWriter;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.serializer.InternalArraySerializer;
import org.apache.paimon.data.serializer.InternalMapSerializer;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;

abstract class AbstractBinaryWriter
implements BinaryWriter {
    protected MemorySegment segment;
    protected int cursor;

    AbstractBinaryWriter() {
    }

    protected abstract void setOffsetAndSize(int var1, int var2, long var3);

    protected abstract int getFieldOffset(int var1);

    protected abstract void afterGrow();

    protected abstract void setNullBit(int var1);

    @Override
    public void writeString(int pos, BinaryString input) {
        if (input.getSegments() == null) {
            String javaObject = input.toString();
            this.writeBytes(pos, javaObject.getBytes(StandardCharsets.UTF_8));
        } else {
            int len = input.getSizeInBytes();
            if (len <= 7) {
                byte[] bytes = MemorySegmentUtils.allocateReuseBytes(len);
                MemorySegmentUtils.copyToBytes(input.getSegments(), input.getOffset(), bytes, 0, len);
                AbstractBinaryWriter.writeBytesToFixLenPart(this.segment, this.getFieldOffset(pos), bytes, len);
            } else {
                this.writeSegmentsToVarLenPart(pos, input.getSegments(), input.getOffset(), len);
            }
        }
    }

    private void writeBytes(int pos, byte[] bytes) {
        int len = bytes.length;
        if (len <= 7) {
            AbstractBinaryWriter.writeBytesToFixLenPart(this.segment, this.getFieldOffset(pos), bytes, len);
        } else {
            this.writeBytesToVarLenPart(pos, bytes, len);
        }
    }

    @Override
    public void writeArray(int pos, InternalArray input, InternalArraySerializer serializer) {
        BinaryArray binary = serializer.toBinaryArray(input);
        this.writeSegmentsToVarLenPart(pos, binary.getSegments(), binary.getOffset(), binary.getSizeInBytes());
    }

    @Override
    public void writeMap(int pos, InternalMap input, InternalMapSerializer serializer) {
        BinaryMap binary = serializer.toBinaryMap(input);
        this.writeSegmentsToVarLenPart(pos, binary.getSegments(), binary.getOffset(), binary.getSizeInBytes());
    }

    @Override
    public void writeRow(int pos, InternalRow input, InternalRowSerializer serializer) {
        if (input instanceof BinarySection) {
            BinarySection row = (BinarySection)((Object)input);
            this.writeSegmentsToVarLenPart(pos, row.getSegments(), row.getOffset(), row.getSizeInBytes());
        } else {
            BinaryRow row = serializer.toBinaryRow(input);
            this.writeSegmentsToVarLenPart(pos, row.getSegments(), row.getOffset(), row.getSizeInBytes());
        }
    }

    @Override
    public void writeBinary(int pos, byte[] bytes) {
        int len = bytes.length;
        if (len <= 7) {
            AbstractBinaryWriter.writeBytesToFixLenPart(this.segment, this.getFieldOffset(pos), bytes, len);
        } else {
            this.writeBytesToVarLenPart(pos, bytes, len);
        }
    }

    @Override
    public void writeDecimal(int pos, Decimal value, int precision) {
        assert (value == null || value.precision() == precision);
        if (Decimal.isCompact(precision)) {
            assert (value != null);
            this.writeLong(pos, value.toUnscaledLong());
        } else {
            this.ensureCapacity(16);
            this.segment.putLong(this.cursor, 0L);
            this.segment.putLong(this.cursor + 8, 0L);
            if (value == null) {
                this.setNullBit(pos);
                this.setOffsetAndSize(pos, this.cursor, 0L);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                this.segment.put(this.cursor, bytes, 0, bytes.length);
                this.setOffsetAndSize(pos, this.cursor, bytes.length);
            }
            this.cursor += 16;
        }
    }

    @Override
    public void writeTimestamp(int pos, Timestamp value, int precision) {
        if (Timestamp.isCompact(precision)) {
            this.writeLong(pos, value.getMillisecond());
        } else {
            this.ensureCapacity(8);
            if (value == null) {
                this.setNullBit(pos);
                this.segment.putLong(this.cursor, 0L);
                this.setOffsetAndSize(pos, this.cursor, 0L);
            } else {
                this.segment.putLong(this.cursor, value.getMillisecond());
                this.setOffsetAndSize(pos, this.cursor, value.getNanoOfMillisecond());
            }
            this.cursor += 8;
        }
    }

    private void zeroBytes(int offset, int size) {
        for (int i = offset; i < offset + size; ++i) {
            this.segment.put(i, (byte)0);
        }
    }

    protected void zeroOutPaddingBytes(int numBytes) {
        if ((numBytes & 7) > 0) {
            this.segment.putLong(this.cursor + (numBytes >> 3 << 3), 0L);
        }
    }

    protected void ensureCapacity(int neededSize) {
        int length = this.cursor + neededSize;
        if (this.segment.size() < length) {
            this.grow(length);
        }
    }

    private void writeSegmentsToVarLenPart(int pos, MemorySegment[] segments, int offset, int size) {
        int roundedSize = AbstractBinaryWriter.roundNumberOfBytesToNearestWord(size);
        this.ensureCapacity(roundedSize);
        this.zeroOutPaddingBytes(size);
        if (segments.length == 1) {
            segments[0].copyTo(offset, this.segment, this.cursor, size);
        } else {
            this.writeMultiSegmentsToVarLenPart(segments, offset, size);
        }
        this.setOffsetAndSize(pos, this.cursor, size);
        this.cursor += roundedSize;
    }

    private void writeMultiSegmentsToVarLenPart(MemorySegment[] segments, int offset, int size) {
        int needCopy = size;
        int fromOffset = offset;
        int toOffset = this.cursor;
        for (MemorySegment sourceSegment : segments) {
            int remain = sourceSegment.size() - fromOffset;
            if (remain > 0) {
                int copySize = Math.min(remain, needCopy);
                sourceSegment.copyTo(fromOffset, this.segment, toOffset, copySize);
                needCopy -= copySize;
                toOffset += copySize;
                fromOffset = 0;
                continue;
            }
            fromOffset -= sourceSegment.size();
        }
    }

    private void writeBytesToVarLenPart(int pos, byte[] bytes, int len) {
        int roundedSize = AbstractBinaryWriter.roundNumberOfBytesToNearestWord(len);
        this.ensureCapacity(roundedSize);
        this.zeroOutPaddingBytes(len);
        this.segment.put(this.cursor, bytes, 0, len);
        this.setOffsetAndSize(pos, this.cursor, len);
        this.cursor += roundedSize;
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.segment.size();
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.segment = MemorySegment.wrap(Arrays.copyOf(this.segment.getArray(), newCapacity));
        this.afterGrow();
    }

    protected static int roundNumberOfBytesToNearestWord(int numBytes) {
        int remainder = numBytes & 7;
        if (remainder == 0) {
            return numBytes;
        }
        return numBytes + (8 - remainder);
    }

    private static void writeBytesToFixLenPart(MemorySegment segment, int fieldOffset, byte[] bytes, int len) {
        int i;
        long firstByte = len | 0x80;
        long sevenBytes = 0L;
        if (BinaryRow.LITTLE_ENDIAN) {
            for (i = 0; i < len; ++i) {
                sevenBytes |= (0xFFL & (long)bytes[i]) << (int)((long)i * 8L);
            }
        } else {
            for (i = 0; i < len; ++i) {
                sevenBytes |= (0xFFL & (long)bytes[i]) << (int)((long)(6 - i) * 8L);
            }
        }
        long offsetAndSize = firstByte << 56 | sevenBytes;
        segment.putLong(fieldOffset, offsetAndSize);
    }

    public MemorySegment getSegments() {
        return this.segment;
    }
}

