/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.List;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.mergetree.LookupLevels;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ChangelogMergeTreeRewriter;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.LookupChangelogMergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;

public class LookupMergeTreeCompactRewriter
extends ChangelogMergeTreeRewriter {
    private final LookupLevels lookupLevels;

    public LookupMergeTreeCompactRewriter(LookupLevels lookupLevels, KeyValueFileReaderFactory readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<InternalRow> keyComparator, MergeFunctionFactory<KeyValue> mfFactory, MergeSorter mergeSorter, RecordEqualiser valueEqualiser, boolean changelogRowDeduplicate) {
        super(readerFactory, writerFactory, keyComparator, mfFactory, mergeSorter, valueEqualiser, changelogRowDeduplicate);
        this.lookupLevels = lookupLevels;
    }

    @Override
    protected boolean rewriteChangelog(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) {
        return this.rewriteLookupChangelog(outputLevel, sections);
    }

    @Override
    protected boolean upgradeChangelog(int outputLevel, DataFileMeta file) {
        return file.level() == 0;
    }

    @Override
    protected MergeFunctionWrapper<ChangelogResult> createMergeWrapper(int outputLevel) {
        return new LookupChangelogMergeFunctionWrapper(this.mfFactory, key -> {
            try {
                return this.lookupLevels.lookup((InternalRow)key, outputLevel + 1);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, this.valueEqualiser, this.changelogRowDeduplicate);
    }

    @Override
    public void close() throws IOException {
        this.lookupLevels.close();
    }
}

