/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import org.apache.paimon.metrics.Counter;
import org.apache.paimon.metrics.Histogram;
import org.apache.paimon.metrics.MetricGroup;
import org.apache.paimon.metrics.MetricRegistry;

public class WriterMetrics {
    private static final String GROUP_NAME = "writer";
    private static final int WINDOW_SAMPLE_SIZE = 100;
    private static final String WRITE_RECORD_NUM = "writeRecordCount";
    private static final String FLUSH_COST_MILLIS = "flushCostMillis";
    public static final String PREPARE_COMMIT_COST_MILLIS = "prepareCommitCostMillis";
    private final Counter writeRecordNumCounter;
    private final Histogram bufferFlushCostMillis;
    private final Histogram prepareCommitCostMillis;
    private MetricGroup metricGroup;

    public WriterMetrics(MetricRegistry registry, String tableName, String parition, int bucket) {
        this.metricGroup = registry.bucketMetricGroup(GROUP_NAME, tableName, parition, bucket);
        this.writeRecordNumCounter = this.metricGroup.counter(WRITE_RECORD_NUM);
        this.bufferFlushCostMillis = this.metricGroup.histogram(FLUSH_COST_MILLIS, 100);
        this.prepareCommitCostMillis = this.metricGroup.histogram(PREPARE_COMMIT_COST_MILLIS, 100);
    }

    public void incWriteRecordNum() {
        this.writeRecordNumCounter.inc();
    }

    public void updateBufferFlushCostMillis(long bufferFlushCost) {
        this.bufferFlushCostMillis.update(bufferFlushCost);
    }

    public void updatePrepareCommitCostMillis(long cost) {
        this.prepareCommitCostMillis.update(cost);
    }

    public void close() {
        this.metricGroup.close();
    }
}

