/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.types.DataType;

@Public
public interface SchemaChange
extends Serializable {
    public static SchemaChange setOption(String key, String value) {
        return new SetOption(key, value);
    }

    public static SchemaChange removeOption(String key) {
        return new RemoveOption(key);
    }

    public static SchemaChange addColumn(String fieldName, DataType dataType) {
        return SchemaChange.addColumn(fieldName, dataType, null, null);
    }

    public static SchemaChange addColumn(String fieldName, DataType dataType, String comment) {
        return new AddColumn(fieldName, dataType, comment, null);
    }

    public static SchemaChange addColumn(String fieldName, DataType dataType, String comment, Move move) {
        return new AddColumn(fieldName, dataType, comment, move);
    }

    public static SchemaChange renameColumn(String fieldName, String newName) {
        return new RenameColumn(fieldName, newName);
    }

    public static SchemaChange dropColumn(String fieldName) {
        return new DropColumn(fieldName);
    }

    public static SchemaChange updateColumnType(String fieldName, DataType newDataType) {
        return new UpdateColumnType(fieldName, newDataType);
    }

    public static SchemaChange updateColumnNullability(String fieldName, boolean newNullability) {
        return new UpdateColumnNullability(new String[]{fieldName}, newNullability);
    }

    public static SchemaChange updateColumnNullability(String[] fieldNames, boolean newNullability) {
        return new UpdateColumnNullability(fieldNames, newNullability);
    }

    public static SchemaChange updateColumnComment(String fieldName, String comment) {
        return new UpdateColumnComment(new String[]{fieldName}, comment);
    }

    public static SchemaChange updateColumnComment(String[] fieldNames, String comment) {
        return new UpdateColumnComment(fieldNames, comment);
    }

    public static SchemaChange updateColumnPosition(Move move) {
        return new UpdateColumnPosition(move);
    }

    public static final class UpdateColumnComment
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private final String[] fieldNames;
        private final String newDescription;

        public UpdateColumnComment(String[] fieldNames, String newDescription) {
            this.fieldNames = fieldNames;
            this.newDescription = newDescription;
        }

        public String[] fieldNames() {
            return this.fieldNames;
        }

        public String newDescription() {
            return this.newDescription;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UpdateColumnComment)) {
                return false;
            }
            UpdateColumnComment that = (UpdateColumnComment)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newDescription.equals(that.newDescription);
        }

        public int hashCode() {
            int result = Objects.hash(this.newDescription);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class UpdateColumnNullability
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private final String[] fieldNames;
        private final boolean newNullability;

        public UpdateColumnNullability(String[] fieldNames, boolean newNullability) {
            this.fieldNames = fieldNames;
            this.newNullability = newNullability;
        }

        public String[] fieldNames() {
            return this.fieldNames;
        }

        public boolean newNullability() {
            return this.newNullability;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UpdateColumnNullability)) {
                return false;
            }
            UpdateColumnNullability that = (UpdateColumnNullability)o;
            return this.newNullability == that.newNullability && Arrays.equals(this.fieldNames, that.fieldNames);
        }

        public int hashCode() {
            int result = Objects.hash(this.newNullability);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static class Move
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String fieldName;
        private final String referenceFieldName;
        private final MoveType type;

        public static Move first(String fieldName) {
            return new Move(fieldName, null, MoveType.FIRST);
        }

        public static Move after(String fieldName, String referenceFieldName) {
            return new Move(fieldName, referenceFieldName, MoveType.AFTER);
        }

        public Move(String fieldName, String referenceFieldName, MoveType type) {
            this.fieldName = fieldName;
            this.referenceFieldName = referenceFieldName;
            this.type = type;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public String referenceFieldName() {
            return this.referenceFieldName;
        }

        public MoveType type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Move move = (Move)o;
            return Objects.equals(this.fieldName, move.fieldName) && Objects.equals(this.referenceFieldName, move.referenceFieldName) && Objects.equals((Object)this.type, (Object)move.type);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.fieldName, this.referenceFieldName, this.type});
        }

        public static enum MoveType {
            FIRST,
            AFTER;

        }
    }

    public static final class UpdateColumnPosition
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private final Move move;

        private UpdateColumnPosition(Move move) {
            this.move = move;
        }

        public Move move() {
            return this.move;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnPosition updateColumnPosition = (UpdateColumnPosition)o;
            return Objects.equals(this.move, updateColumnPosition.move);
        }

        public int hashCode() {
            return Objects.hash(this.move);
        }
    }

    public static final class UpdateColumnType
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private final String fieldName;
        private final DataType newDataType;

        private UpdateColumnType(String fieldName, DataType newDataType) {
            this.fieldName = fieldName;
            this.newDataType = newDataType;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public DataType newDataType() {
            return this.newDataType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnType that = (UpdateColumnType)o;
            return Objects.equals(this.fieldName, that.fieldName) && this.newDataType.equals(that.newDataType);
        }

        public int hashCode() {
            int result = Objects.hash(this.newDataType);
            result = 31 * result + Objects.hashCode(this.fieldName);
            return result;
        }
    }

    public static final class DropColumn
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private final String fieldName;

        private DropColumn(String fieldName) {
            this.fieldName = fieldName;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DropColumn that = (DropColumn)o;
            return Objects.equals(this.fieldName, that.fieldName);
        }

        public int hashCode() {
            return Objects.hashCode(this.fieldName);
        }
    }

    public static final class RenameColumn
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private final String fieldName;
        private final String newName;

        private RenameColumn(String fieldName, String newName) {
            this.fieldName = fieldName;
            this.newName = newName;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public String newName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameColumn that = (RenameColumn)o;
            return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.newName, that.newName);
        }

        public int hashCode() {
            int result = Objects.hash(this.newName);
            result = 31 * result + Objects.hashCode(this.fieldName);
            return result;
        }
    }

    public static final class AddColumn
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private final String fieldName;
        private final DataType dataType;
        private final String description;
        private final Move move;

        private AddColumn(String fieldName, DataType dataType, String description, Move move) {
            this.fieldName = fieldName;
            this.dataType = dataType;
            this.description = description;
            this.move = move;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public DataType dataType() {
            return this.dataType;
        }

        @Nullable
        public String description() {
            return this.description;
        }

        @Nullable
        public Move move() {
            return this.move;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddColumn addColumn = (AddColumn)o;
            return Objects.equals(this.fieldName, addColumn.fieldName) && this.dataType.equals(addColumn.dataType) && Objects.equals(this.description, addColumn.description) && this.move.equals(addColumn.move);
        }

        public int hashCode() {
            int result = Objects.hash(this.dataType, this.description);
            result = 31 * result + Objects.hashCode(this.fieldName);
            result = 31 * result + Objects.hashCode(this.move);
            return result;
        }
    }

    public static final class RemoveOption
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private final String key;

        private RemoveOption(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveOption that = (RemoveOption)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    public static final class SetOption
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private final String key;
        private final String value;

        private SetOption(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetOption that = (SetOption)o;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }
}

