/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;

public class CastRulePredicate {
    private final Set<DataType> targetTypes;
    private final Set<DataTypeRoot> inputTypeRoots;
    private final Set<DataTypeRoot> targetTypeRoots;
    private final Set<DataTypeFamily> inputTypeFamilies;
    private final Set<DataTypeFamily> targetTypeFamilies;
    private final BiPredicate<DataType, DataType> customPredicate;

    private CastRulePredicate(Set<DataType> targetTypes, Set<DataTypeRoot> inputTypeRoots, Set<DataTypeRoot> targetTypeRoots, Set<DataTypeFamily> inputTypeFamilies, Set<DataTypeFamily> targetTypeFamilies, BiPredicate<DataType, DataType> customPredicate) {
        this.targetTypes = targetTypes;
        this.inputTypeRoots = inputTypeRoots;
        this.targetTypeRoots = targetTypeRoots;
        this.inputTypeFamilies = inputTypeFamilies;
        this.targetTypeFamilies = targetTypeFamilies;
        this.customPredicate = customPredicate;
    }

    public Set<DataType> getTargetTypes() {
        return this.targetTypes;
    }

    public Set<DataTypeRoot> getInputTypeRoots() {
        return this.inputTypeRoots;
    }

    public Set<DataTypeRoot> getTargetTypeRoots() {
        return this.targetTypeRoots;
    }

    public Set<DataTypeFamily> getInputTypeFamilies() {
        return this.inputTypeFamilies;
    }

    public Set<DataTypeFamily> getTargetTypeFamilies() {
        return this.targetTypeFamilies;
    }

    public Optional<BiPredicate<DataType, DataType>> getCustomPredicate() {
        return Optional.ofNullable(this.customPredicate);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<DataTypeRoot> inputTypeRoots = new HashSet<DataTypeRoot>();
        private final Set<DataTypeRoot> targetTypeRoots = new HashSet<DataTypeRoot>();
        private final Set<DataType> targetTypes = new HashSet<DataType>();
        private final Set<DataTypeFamily> inputTypeFamilies = new HashSet<DataTypeFamily>();
        private final Set<DataTypeFamily> targetTypeFamilies = new HashSet<DataTypeFamily>();
        private BiPredicate<DataType, DataType> customPredicate;

        public Builder input(DataTypeRoot inputTypeRoot) {
            this.inputTypeRoots.add(inputTypeRoot);
            return this;
        }

        public Builder target(DataTypeRoot outputTypeRoot) {
            this.targetTypeRoots.add(outputTypeRoot);
            return this;
        }

        public Builder target(DataType outputType) {
            this.targetTypes.add(outputType);
            return this;
        }

        public Builder input(DataTypeFamily inputTypeFamily) {
            this.inputTypeFamilies.add(inputTypeFamily);
            return this;
        }

        public Builder target(DataTypeFamily outputTypeFamily) {
            this.targetTypeFamilies.add(outputTypeFamily);
            return this;
        }

        public Builder predicate(BiPredicate<DataType, DataType> customPredicate) {
            this.customPredicate = customPredicate;
            return this;
        }

        public CastRulePredicate build() {
            return new CastRulePredicate(Collections.unmodifiableSet(this.targetTypes), Collections.unmodifiableSet(this.inputTypeRoots), Collections.unmodifiableSet(this.targetTypeRoots), Collections.unmodifiableSet(this.inputTypeFamilies), Collections.unmodifiableSet(this.targetTypeFamilies), this.customPredicate);
        }
    }
}

