/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.operation.OrphanFilesClean;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;

public class RemoveOrphanFilesAction
extends TableActionBase {
    private final OrphanFilesClean orphanFilesClean;

    public RemoveOrphanFilesAction(String warehouse, String databaseName, String tableName, Map<String, String> catalogConfig) {
        super(warehouse, databaseName, tableName, catalogConfig);
        Preconditions.checkArgument(this.table instanceof FileStoreTable, "Only FileStoreTable supports remove-orphan-files action. The table type is '%s'.", this.table.getClass().getName());
        this.orphanFilesClean = new OrphanFilesClean((FileStoreTable)this.table);
    }

    public RemoveOrphanFilesAction olderThan(String timestamp) {
        this.orphanFilesClean.olderThan(timestamp);
        return this;
    }

    @Override
    public void run() throws Exception {
        this.orphanFilesClean.clean();
    }
}

