/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.types.Row;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.DeleteAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BlockingIterator;
import org.apache.paimon.utils.SnapshotManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DeleteActionITCase
extends ActionITCaseBase {
    private static final DataType[] FIELD_TYPES = new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()};
    private static final RowType ROW_TYPE = RowType.of((DataType[])FIELD_TYPES, (String[])new String[]{"k", "v"});

    @BeforeEach
    public void setUp() {
        ReadWriteTableTestUtil.init(this.warehouse);
    }

    @Test
    public void testDeleteAction() throws Exception {
        List<Row> initialRecords = Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{1L, "World"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{2L, "Store"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{3L, "Developer"}));
        List<Row> expected = Collections.singletonList(TestValuesTableFactory.changelogRow((String)"-D", (Object[])new Object[]{1L, "World"}));
        this.prepareTable();
        DeleteAction action = this.createAction(DeleteAction.class, "delete", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--where", "k=1");
        BlockingIterator<Row, Row> iterator = ReadWriteTableTestUtil.testStreamingRead(ReadWriteTableTestUtil.buildSimpleQuery(this.tableName), initialRecords);
        action.run();
        SnapshotManager snapshotManager = this.getFileStoreTable(this.tableName).snapshotManager();
        Snapshot snapshot = snapshotManager.snapshot(snapshotManager.latestSnapshotId().longValue());
        Assertions.assertThat((long)snapshot.id()).isEqualTo(2L);
        Assertions.assertThat((Comparable)snapshot.commitKind()).isEqualTo((Object)Snapshot.CommitKind.APPEND);
        ReadWriteTableTestUtil.validateStreamingReadResult(iterator, expected);
        iterator.close();
    }

    private void prepareTable() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        FileStoreTable table = this.createFileStoreTable(ROW_TYPE, Collections.emptyList(), Collections.singletonList("k"), options);
        SnapshotManager snapshotManager = table.snapshotManager();
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = streamWriteBuilder.newWrite();
        this.commit = streamWriteBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")), this.rowData(1L, BinaryString.fromString((String)"Hello")), this.rowData(1L, BinaryString.fromString((String)"World")), this.rowData(2L, BinaryString.fromString((String)"Flink")), this.rowData(2L, BinaryString.fromString((String)"Table")), this.rowData(2L, BinaryString.fromString((String)"Store")), this.rowData(3L, BinaryString.fromString((String)"Developer")));
        Snapshot snapshot = snapshotManager.snapshot(snapshotManager.latestSnapshotId().longValue());
        Assertions.assertThat((long)snapshot.id()).isEqualTo(1L);
        Assertions.assertThat((Comparable)snapshot.commitKind()).isEqualTo((Object)Snapshot.CommitKind.APPEND);
    }
}

