/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.DropPartitionAction;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class DropPartitionActionITCase
extends ActionITCaseBase {
    private static final DataType[] FIELD_TYPES = new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.STRING(), DataTypes.INT()};
    private static final RowType ROW_TYPE = RowType.of((DataType[])FIELD_TYPES, (String[])new String[]{"partKey0", "partKey1", "dt", "value"});

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDropPartitionWithSinglePartitionKey(boolean hasPk) throws Exception {
        FileStoreTable table = this.prepareTable(hasPk);
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.createAction(DropPartitionAction.class, "drop_partition", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--partition", "partKey0=0").run();
        } else {
            this.callProcedure(String.format("CALL sys.drop_partition('%s.%s', 'partKey0 = 0')", this.database, this.tableName));
        }
        SnapshotManager snapshotManager = this.getFileStoreTable(this.tableName).snapshotManager();
        Snapshot snapshot = snapshotManager.snapshot(snapshotManager.latestSnapshotId().longValue());
        Assertions.assertThat((long)snapshot.id()).isEqualTo(5L);
        Assertions.assertThat((Comparable)snapshot.commitKind()).isEqualTo((Object)Snapshot.CommitKind.OVERWRITE);
        TableScan.Plan plan = table.newReadBuilder().newScan().plan();
        Assertions.assertThat((int)plan.splits().size()).isEqualTo(2);
        List<String> actual = this.getResult(table.newReadBuilder().newRead(), plan.splits(), ROW_TYPE);
        List<String> expected = hasPk ? Arrays.asList("+I[1, 0, 2023-01-17, 5]", "+I[1, 1, 2023-01-18, 82]", "+I[1, 1, 2023-01-19, 90]", "+I[1, 1, 2023-01-20, 97]") : Arrays.asList("+I[1, 0, 2023-01-17, 2]", "+I[1, 0, 2023-01-17, 3]", "+I[1, 0, 2023-01-17, 5]", "+I[1, 1, 2023-01-18, 82]", "+I[1, 1, 2023-01-19, 90]", "+I[1, 1, 2023-01-20, 97]");
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDropPartitionWithMultiplePartitionKey(boolean hasPk) throws Exception {
        FileStoreTable table = this.prepareTable(hasPk);
        HashMap<String, String> partitions0 = new HashMap<String, String>();
        partitions0.put("partKey0", "0");
        partitions0.put("partKey1", "1");
        HashMap<String, String> partitions1 = new HashMap<String, String>();
        partitions1.put("partKey0", "1");
        partitions1.put("partKey1", "0");
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.createAction(DropPartitionAction.class, "drop_partition", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--partition", "partKey0=0,partKey1=1", "--partition", "partKey0=1,partKey1=0").run();
        } else {
            this.callProcedure(String.format("CALL sys.drop_partition('%s.%s', 'partKey0=0,partKey1=1', 'partKey0=1,partKey1=0')", this.database, this.tableName));
        }
        SnapshotManager snapshotManager = this.getFileStoreTable(this.tableName).snapshotManager();
        Snapshot snapshot = snapshotManager.snapshot(snapshotManager.latestSnapshotId().longValue());
        Assertions.assertThat((long)snapshot.id()).isEqualTo(5L);
        Assertions.assertThat((Comparable)snapshot.commitKind()).isEqualTo((Object)Snapshot.CommitKind.OVERWRITE);
        ReadBuilder readBuilder = table.newReadBuilder();
        TableScan.Plan plan = readBuilder.newScan().plan();
        Assertions.assertThat((int)plan.splits().size()).isEqualTo(2);
        List<String> actual = this.getResult(readBuilder.newRead(), plan.splits(), ROW_TYPE);
        List<String> expected = hasPk ? Arrays.asList("+I[0, 0, 2023-01-12, 102]", "+I[0, 0, 2023-01-13, 103]", "+I[1, 1, 2023-01-18, 82]", "+I[1, 1, 2023-01-19, 90]", "+I[1, 1, 2023-01-20, 97]") : Arrays.asList("+I[0, 0, 2023-01-12, 101]", "+I[0, 0, 2023-01-12, 102]", "+I[0, 0, 2023-01-13, 103]", "+I[1, 1, 2023-01-18, 82]", "+I[1, 1, 2023-01-19, 90]", "+I[1, 1, 2023-01-20, 97]");
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    private FileStoreTable prepareTable(boolean hasPk) throws Exception {
        FileStoreTable table = this.createFileStoreTable(ROW_TYPE, Arrays.asList("partKey0", "partKey1"), hasPk ? Arrays.asList("partKey0", "partKey1", "dt") : Collections.emptyList(), new HashMap<String, String>());
        SnapshotManager snapshotManager = table.snapshotManager();
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = streamWriteBuilder.newWrite();
        this.commit = streamWriteBuilder.newCommit();
        this.writeData(this.rowData(0, 0, BinaryString.fromString((String)"2023-01-12"), 101), this.rowData(0, 0, BinaryString.fromString((String)"2023-01-12"), 102), this.rowData(0, 0, BinaryString.fromString((String)"2023-01-13"), 103));
        this.writeData(this.rowData(0, 1, BinaryString.fromString((String)"2023-01-14"), 110), this.rowData(0, 1, BinaryString.fromString((String)"2023-01-15"), 120), this.rowData(0, 1, BinaryString.fromString((String)"2023-01-16"), 130));
        this.writeData(this.rowData(1, 0, BinaryString.fromString((String)"2023-01-17"), 2), this.rowData(1, 0, BinaryString.fromString((String)"2023-01-17"), 3), this.rowData(1, 0, BinaryString.fromString((String)"2023-01-17"), 5));
        this.writeData(this.rowData(1, 1, BinaryString.fromString((String)"2023-01-18"), 82), this.rowData(1, 1, BinaryString.fromString((String)"2023-01-19"), 90), this.rowData(1, 1, BinaryString.fromString((String)"2023-01-20"), 97));
        Snapshot snapshot = snapshotManager.snapshot(snapshotManager.latestSnapshotId().longValue());
        Assertions.assertThat((long)snapshot.id()).isEqualTo(4L);
        Assertions.assertThat((Comparable)snapshot.commitKind()).isEqualTo((Object)Snapshot.CommitKind.APPEND);
        return table;
    }
}

