/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.types.Row;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.RollbackToAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RollbackToActionITCase
extends ActionITCaseBase {
    private static final DataType[] FIELD_TYPES = new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()};
    private static final RowType ROW_TYPE = RowType.of((DataType[])FIELD_TYPES, (String[])new String[]{"k", "v"});

    @BeforeEach
    public void setUp() {
        ReadWriteTableTestUtil.init(this.warehouse);
    }

    @Test
    public void rollbackToSnapshotTest() throws Exception {
        FileStoreTable table = this.createFileStoreTable(ROW_TYPE, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"World")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Flink")));
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.createAction(RollbackToAction.class, "rollback_to", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--version", "2").run();
        } else {
            this.callProcedure(String.format("CALL sys.rollback_to('%s.%s', 2)", this.database, this.tableName));
        }
        ReadWriteTableTestUtil.testBatchRead("SELECT * FROM `" + this.tableName + "`", Arrays.asList(Row.of((Object[])new Object[]{1L, "Hi"}), Row.of((Object[])new Object[]{2L, "Hello"})));
    }

    @Test
    public void rollbackToTagTest() throws Exception {
        FileStoreTable table = this.createFileStoreTable(ROW_TYPE, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Apache")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Paimon")));
        table.createTag("tag1", 1L);
        table.createTag("tag2", 2L);
        table.createTag("tag3", 3L);
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.createAction(RollbackToAction.class, "rollback_to", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--version", "tag2").run();
        } else {
            this.callProcedure(String.format("CALL sys.rollback_to('%s.%s', 'tag2')", this.database, this.tableName));
        }
        ReadWriteTableTestUtil.testBatchRead("SELECT * FROM `" + this.tableName + "`", Arrays.asList(Row.of((Object[])new Object[]{1L, "Hi"}), Row.of((Object[])new Object[]{2L, "Apache"})));
    }
}

