/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.sink.WrappedManifestCommittableSerializer;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileTestUtils;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestCommittableSerializerTest;
import org.apache.paimon.manifest.WrappedManifestCommittable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WrappedManifestCommittableSerializerTest {
    private static final AtomicInteger ID = new AtomicInteger();
    private static final int VERSION = 1;

    WrappedManifestCommittableSerializerTest() {
    }

    @Test
    public void testCommittableSerDe() throws IOException {
        WrappedManifestCommittableSerializer serializer = WrappedManifestCommittableSerializerTest.serializer();
        ManifestCommittable committable1 = WrappedManifestCommittableSerializerTest.createManifestCommittable();
        ManifestCommittable committable2 = WrappedManifestCommittableSerializerTest.createManifestCommittable();
        WrappedManifestCommittable wrappedManifestCommittable = new WrappedManifestCommittable(-1L, -1L);
        wrappedManifestCommittable.putManifestCommittable(Identifier.create((String)"db", (String)"table1"), committable1);
        wrappedManifestCommittable.putManifestCommittable(Identifier.create((String)"db", (String)"table2"), committable2);
        byte[] serialized = serializer.serialize(wrappedManifestCommittable);
        WrappedManifestCommittable deserialize = serializer.deserialize(1, serialized);
        Map manifestCommittables = deserialize.manifestCommittables();
        Assertions.assertThat((int)manifestCommittables.size()).isEqualTo(2);
        Assertions.assertThat((Object)deserialize).isEqualTo((Object)wrappedManifestCommittable);
    }

    public static WrappedManifestCommittableSerializer serializer() {
        return new WrappedManifestCommittableSerializer();
    }

    public static ManifestCommittable createManifestCommittable() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        ManifestCommittable committable = rnd.nextBoolean() ? new ManifestCommittable(rnd.nextLong(), Long.valueOf(rnd.nextLong())) : new ManifestCommittable(rnd.nextLong(), null);
        WrappedManifestCommittableSerializerTest.addFileCommittables(committable, DataFileTestUtils.row((int)0), 0);
        WrappedManifestCommittableSerializerTest.addFileCommittables(committable, DataFileTestUtils.row((int)0), 1);
        WrappedManifestCommittableSerializerTest.addFileCommittables(committable, DataFileTestUtils.row((int)1), 0);
        WrappedManifestCommittableSerializerTest.addFileCommittables(committable, DataFileTestUtils.row((int)1), 1);
        return committable;
    }

    public static void addFileCommittables(ManifestCommittable committable, BinaryRow partition, int bucket) {
        ArrayList<CommitMessageImpl> commitMessages = new ArrayList<CommitMessageImpl>();
        int length = ThreadLocalRandom.current().nextInt(10) + 1;
        for (int i = 0; i < length; ++i) {
            DataIncrement dataIncrement = ManifestCommittableSerializerTest.randomNewFilesIncrement();
            CompactIncrement compactIncrement = ManifestCommittableSerializerTest.randomCompactIncrement();
            CommitMessageImpl commitMessage = new CommitMessageImpl(partition, bucket, dataIncrement, compactIncrement);
            commitMessages.add(commitMessage);
            committable.addFileCommittable((CommitMessage)commitMessage);
        }
        if (!committable.logOffsets().containsKey(bucket)) {
            int offset = ID.incrementAndGet();
            committable.addLogOffset(bucket, (long)offset);
            Assertions.assertThat((Long)((Long)committable.logOffsets().get(bucket))).isEqualTo((long)offset);
        }
    }
}

