/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.AsyncLookupSinkWrite;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.CommittableTypeInfo;
import org.apache.paimon.flink.sink.RowDataStoreWriteOperator;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.flink.sink.StoreSinkWriteImpl;
import org.apache.paimon.flink.utils.InternalRowTypeSerializer;
import org.apache.paimon.flink.utils.InternalTypeInfo;
import org.apache.paimon.flink.utils.InternalTypeSerializer;
import org.apache.paimon.flink.utils.TestingMetricUtils;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.options.Options;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.StreamTableScan;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class WriterOperatorTest {
    @TempDir
    public java.nio.file.Path tempDir;
    private Path tablePath;

    @BeforeEach
    public void before() {
        this.tablePath = new Path(this.tempDir.toString());
    }

    @Test
    public void testPrimaryKeyTableMetrics() throws Exception {
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT()}, (String[])new String[]{"a", "b"});
        Options options = new Options();
        options.set("bucket", "1");
        options.set("write-buffer-size", "256 b");
        options.set("page-size", "32 b");
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.singletonList("a"), Collections.emptyList(), options);
        this.testMetricsImpl(table);
    }

    @Test
    public void testAppendOnlyTableMetrics() throws Exception {
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT()}, (String[])new String[]{"a", "b"});
        Options options = new Options();
        options.set("write-buffer-for-append", "true");
        options.set("write-buffer-size", "256 b");
        options.set("page-size", "32 b");
        options.set("write-buffer-spillable", "false");
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.emptyList(), options);
        this.testMetricsImpl(table);
    }

    private void testMetricsImpl(FileStoreTable fileStoreTable) throws Exception {
        String tableName = this.tablePath.getName();
        RowDataStoreWriteOperator operator = new RowDataStoreWriteOperator(fileStoreTable, null, (StoreSinkWrite.Provider & Serializable)(table, commitUser, state, ioManager, memoryPool, metricGroup) -> new StoreSinkWriteImpl(table, commitUser, state, ioManager, false, false, true, memoryPool, metricGroup), "test");
        OneInputStreamOperatorTestHarness<InternalRow, Committable> harness = this.createHarness(operator);
        TypeSerializer serializer = new CommittableTypeInfo().createSerializer(new ExecutionConfig());
        harness.setup(serializer);
        harness.open();
        int size = 10;
        for (int i = 0; i < size; ++i) {
            GenericRow row = GenericRow.of((Object[])new Object[]{1, 1});
            harness.processElement((Object)row, 1L);
        }
        harness.prepareSnapshotPreBarrier(1L);
        harness.snapshot(1L, 2L);
        harness.notifyOfCompletedCheckpoint(1L);
        OperatorMetricGroup metricGroup2 = operator.getMetricGroup();
        MetricGroup writerBufferMetricGroup = metricGroup2.addGroup("paimon").addGroup("table", tableName).addGroup("writerBuffer");
        Gauge bufferPreemptCount = TestingMetricUtils.getGauge(writerBufferMetricGroup, "bufferPreemptCount");
        Assertions.assertThat((Long)((Long)bufferPreemptCount.getValue())).isEqualTo(0L);
        Gauge totalWriteBufferSizeByte = TestingMetricUtils.getGauge(writerBufferMetricGroup, "totalWriteBufferSizeByte");
        Assertions.assertThat((Long)((Long)totalWriteBufferSizeByte.getValue())).isEqualTo(256L);
        GenericRow row = GenericRow.of((Object[])new Object[]{1, 1});
        harness.processElement((Object)row, 1L);
        Gauge usedWriteBufferSizeByte = TestingMetricUtils.getGauge(writerBufferMetricGroup, "usedWriteBufferSizeByte");
        Assertions.assertThat((Long)((Long)usedWriteBufferSizeByte.getValue())).isGreaterThan(0L);
        harness.close();
    }

    @Test
    public void testAsyncLookupWithFailure() throws Exception {
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.INT()}, (String[])new String[]{"pt", "k", "v"});
        Options options = new Options();
        options.set("bucket", "1");
        options.set("changelog-producer", "lookup");
        FileStoreTable fileStoreTable = this.createFileStoreTable(rowType, Arrays.asList("pt", "k"), Collections.singletonList("k"), options);
        RowDataStoreWriteOperator operator = this.getAsyncLookupWriteOperator(fileStoreTable, false);
        OneInputStreamOperatorTestHarness<InternalRow, Committable> harness = this.createHarness(operator);
        TableCommitImpl commit = fileStoreTable.newCommit("test");
        TypeSerializer serializer = new CommittableTypeInfo().createSerializer(new ExecutionConfig());
        harness.setup(serializer);
        harness.open();
        harness.processElement((Object)GenericRow.of((Object[])new Object[]{1, 10, 100}), 1L);
        harness.processElement((Object)GenericRow.of((Object[])new Object[]{2, 20, 200}), 2L);
        harness.processElement((Object)GenericRow.of((Object[])new Object[]{3, 30, 300}), 3L);
        harness.prepareSnapshotPreBarrier(1L);
        harness.snapshot(1L, 10L);
        harness.notifyOfCompletedCheckpoint(1L);
        this.commitAll(harness, commit, 1L);
        harness.processElement((Object)GenericRow.of((Object[])new Object[]{1, 10, 101}), 11L);
        harness.processElement((Object)GenericRow.of((Object[])new Object[]{3, 30, 301}), 13L);
        harness.prepareSnapshotPreBarrier(2L);
        OperatorSubtaskState state = harness.snapshot(2L, 20L);
        harness.notifyOfCompletedCheckpoint(2L);
        this.commitAll(harness, commit, 2L);
        harness.close();
        operator = this.getAsyncLookupWriteOperator(fileStoreTable, true);
        harness = this.createHarness(operator);
        harness.setup(serializer);
        harness.initializeState(state);
        harness.open();
        harness.prepareSnapshotPreBarrier(3L);
        harness.snapshot(3L, 30L);
        harness.notifyOfCompletedCheckpoint(3L);
        this.commitAll(harness, commit, 3L);
        harness.close();
        commit.close();
        ReadBuilder readBuilder = fileStoreTable.newReadBuilder();
        StreamTableScan scan = readBuilder.newStreamScan();
        List splits = scan.plan().splits();
        TableRead read = readBuilder.newRead();
        RecordReader reader = read.createReader(splits);
        ArrayList actual = new ArrayList();
        reader.forEachRemaining(row -> actual.add(String.format("%s[%d, %d, %d]", row.getRowKind().shortString(), row.getInt(0), row.getInt(1), row.getInt(2))));
        Assertions.assertThat(actual).containsExactlyInAnyOrder((Object[])new String[]{"+I[1, 10, 101]", "+I[2, 20, 200]", "+I[3, 30, 301]"});
    }

    private RowDataStoreWriteOperator getAsyncLookupWriteOperator(FileStoreTable fileStoreTable, boolean waitCompaction) {
        return new RowDataStoreWriteOperator(fileStoreTable, null, (StoreSinkWrite.Provider & Serializable)(table, commitUser, state, ioManager, memoryPool, metricGroup) -> new AsyncLookupSinkWrite(table, commitUser, state, ioManager, false, waitCompaction, true, memoryPool, metricGroup), "test");
    }

    private void commitAll(OneInputStreamOperatorTestHarness<InternalRow, Committable> harness, TableCommitImpl commit, long commitIdentifier) {
        ArrayList<CommitMessage> commitMessages = new ArrayList<CommitMessage>();
        while (!harness.getOutput().isEmpty()) {
            Committable committable = (Committable)((StreamRecord)harness.getOutput().poll()).getValue();
            Assertions.assertThat((Comparable)committable.kind()).isEqualTo((Object)Committable.Kind.FILE);
            commitMessages.add((CommitMessage)committable.wrappedCommittable());
        }
        commit.commit(commitIdentifier, commitMessages);
    }

    private FileStoreTable createFileStoreTable(RowType rowType, List<String> primaryKeys, List<String> partitionKeys, Options conf) throws Exception {
        conf.set(CoreOptions.PATH, (Object)this.tablePath.toString());
        SchemaManager schemaManager = new SchemaManager((FileIO)LocalFileIO.create(), this.tablePath);
        schemaManager.createTable(new Schema(rowType.getFields(), partitionKeys, primaryKeys, conf.toMap(), ""));
        return FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (Options)conf);
    }

    private OneInputStreamOperatorTestHarness<InternalRow, Committable> createHarness(RowDataStoreWriteOperator operator) throws Exception {
        InternalTypeInfo internalRowInternalTypeInfo = new InternalTypeInfo((InternalTypeSerializer)new InternalRowTypeSerializer(RowType.builder().build()));
        return new OneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, internalRowInternalTypeInfo.createSerializer(new ExecutionConfig()));
    }
}

